/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.IConfigurable;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.core.utils.Utils;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class GrassPath
extends Block
implements IConfigurable {
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;
    private static Item tinkersShovel;

    public GrassPath() {
        super(Material.field_151577_b);
        this.func_149711_c(0.6f);
        this.func_149713_g(255);
        this.setHarvestLevel("shovel", 0);
        this.field_149783_u = true;
        this.func_149672_a(field_149779_h);
        this.func_149658_d("grass_path");
        this.func_149663_c(Utils.getUnlocalisedName("grass_path"));
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.func_149647_a((CreativeTabs)(EtFuturum.enableGrassPath ? EtFuturum.creativeTab : null));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Blocks.field_150346_d.func_149650_a(meta, rand, fortune);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.func_147439_a(x, y + 1, z).func_149688_o().func_76220_a()) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? Blocks.field_150346_d.func_149691_a(side, 0) : (side == 1 ? this.field_149761_L : this.sideIcon);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N() + "_top");
        this.sideIcon = reg.func_94245_a(this.func_149641_N() + "_side");
    }

    @Override
    public boolean isEnabled() {
        return EtFuturum.enableGrassPath;
    }

    public static void onPlayerInteract(PlayerInteractEvent event) {
        if (EtFuturum.enableGrassPath && event.entityPlayer != null) {
            ItemStack stack;
            World world = event.entityPlayer.field_70170_p;
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && world.func_147439_a(event.x, event.y, event.z) == Blocks.field_150349_c && (stack = event.entityPlayer.func_71045_bC()) != null && (stack.func_77973_b() instanceof ItemSpade || GrassPath.isTinkersShovel(stack))) {
                world.func_147449_b(event.x, event.y, event.z, ModBlocks.grass_path);
                event.entityPlayer.func_71038_i();
                stack.func_77972_a(1, (EntityLivingBase)event.entityPlayer);
                world.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), Block.field_149767_g.func_150498_e(), 1.0f, 0.8f);
            }
        }
    }

    private static boolean isTinkersShovel(ItemStack stack) {
        if (EtFuturum.isTinkersConstructLoaded) {
            if (tinkersShovel == null) {
                try {
                    Class<?> TinkerTools = Class.forName("tconstruct.tools.TinkerTools");
                    Field field = TinkerTools.getDeclaredField("shovel");
                    field.setAccessible(true);
                    tinkersShovel = (Item)field.get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return tinkersShovel == stack.func_77973_b();
        }
        return false;
    }
}

