/*
 * Decompiled with CFR 0.152.
 */
package latmod.xpt.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.BlockDimPos;
import ftb.lib.LMDimUtils;
import ftb.lib.api.tile.TileLM;
import latmod.xpt.XPTChatMessages;
import latmod.xpt.XPTConfig;
import latmod.xpt.XPTItems;
import latmod.xpt.item.ItemLinkCard;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class TileTeleporter
extends TileLM {
    public BlockDimPos linked = null;
    public int cooldown = 0;
    public int pcooldown = 0;
    private String name;

    public void readTileData(NBTTagCompound tag) {
        super.readTileData(tag);
        this.linked = tag.func_74764_b("Link") ? new BlockDimPos(tag.func_74759_k("Link")) : null;
        this.pcooldown = this.cooldown = tag.func_74762_e("Cooldown");
        this.name = tag.func_74764_b("Name") ? tag.func_74779_i("Name") : null;
    }

    public void writeTileData(NBTTagCompound tag) {
        super.writeTileData(tag);
        if (this.linked != null) {
            tag.func_74783_a("Link", this.linked.toIntArray());
        }
        if (this.cooldown > 0) {
            tag.func_74768_a("Cooldown", this.cooldown);
        }
        if (this.name != null) {
            tag.func_74778_a("Name", this.name);
        }
    }

    public void readTileClientData(NBTTagCompound tag) {
        this.linked = tag.func_74764_b("L") ? new BlockDimPos(tag.func_74759_k("L")) : null;
        this.pcooldown = this.cooldown = tag.func_74762_e("C");
        this.name = tag.func_74764_b("N") ? tag.func_74779_i("N") : null;
    }

    public void writeTileClientData(NBTTagCompound tag) {
        if (this.linked != null) {
            tag.func_74783_a("L", this.linked.toIntArray());
        }
        if (this.cooldown > 0) {
            tag.func_74768_a("C", this.cooldown);
        }
        if (this.name != null) {
            tag.func_74778_a("N", this.name);
        }
    }

    public int getType() {
        if (this.field_145850_b != null && this.linked != null) {
            return this.linked.dim == this.getDimension() ? 1 : 2;
        }
        return 0;
    }

    public void onUpdate() {
        this.pcooldown = this.cooldown;
        if (this.cooldown < 0) {
            this.cooldown = 0;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            if (this.cooldown == 0 && this.isServer()) {
                this.func_70296_d();
            }
        }
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        if (this.field_145850_b.field_72995_K || is == null) {
            return true;
        }
        if (is.func_77973_b() == Items.field_151057_cb) {
            if (!is.func_82837_s()) {
                return true;
            }
            this.setName(is.func_82833_r());
            if (!ep.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
            this.func_70296_d();
            return true;
        }
        if (is.func_77973_b() == XPTItems.link_card) {
            if (ItemLinkCard.hasData(is)) {
                XPTChatMessages msg = XPTChatMessages.INVALID_BLOCK;
                int[] pos = is.func_77978_p().func_74759_k("Coords");
                TileTeleporter t = TileTeleporter.getTileXPT(pos[0], pos[1], pos[2], pos[3]);
                if (t != null) {
                    int levels;
                    boolean crossdim = pos[3] != this.getDimension();
                    int n = levels = XPTConfig.only_linking_uses_xp.get() ? this.getLevels(t.field_145851_c, t.field_145848_d, t.field_145849_e, crossdim) : 0;
                    if (!XPTConfig.canConsumeLevels(ep, levels)) {
                        XPTChatMessages.NEED_XP_LEVEL_LINK.print((ICommandSender)ep, Integer.toString(levels));
                        return true;
                    }
                    msg = this.createLink(t, true);
                    if (msg == XPTChatMessages.LINK_CREATED) {
                        --is.field_77994_a;
                        XPTConfig.consumeLevels(ep, levels);
                    }
                }
                msg.print((ICommandSender)ep, new Object[0]);
            } else if (this.field_145848_d > 0) {
                if (is.field_77994_a > 1) {
                    if (!ep.field_71075_bZ.field_75098_d) {
                        --is.field_77994_a;
                    }
                    ItemStack is1 = new ItemStack((Item)XPTItems.link_card);
                    is1.func_77982_d(new NBTTagCompound());
                    is1.func_77978_p().func_74783_a("Coords", new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g});
                    if (ep.field_71071_by.func_70441_a(is1)) {
                        ep.field_71070_bA.func_75142_b();
                    } else {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, is1));
                    }
                } else {
                    is.func_77982_d(new NBTTagCompound());
                    is.func_77978_p().func_74783_a("Coords", new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g});
                }
            }
        }
        return true;
    }

    public XPTChatMessages createLink(TileTeleporter t, boolean updateLink) {
        if (t == null || !this.isServer()) {
            return XPTChatMessages.INVALID_BLOCK;
        }
        if (this.linked != null && this.linked.equalsPos(t.linked)) {
            return XPTChatMessages.ALREADY_LINKED;
        }
        if (t.equals((Object)this)) {
            return XPTChatMessages.ALREADY_LINKED;
        }
        TileTeleporter t0 = this.getLinkedTile();
        if (t0 != null) {
            t0.linked = null;
            t0.func_70296_d();
        }
        this.linked = new BlockDimPos(t.field_145851_c, t.field_145848_d, t.field_145849_e, t.getDimension());
        if (updateLink && (t = this.getLinkedTile()) != null) {
            t.createLink(this, false);
        }
        this.func_70296_d();
        return XPTChatMessages.LINK_CREATED;
    }

    public static TileTeleporter getTileXPT(int x, int y, int z, int dim) {
        TileEntity te;
        if (y < 0 || y > 256) {
            return null;
        }
        World w = LMDimUtils.getWorld((int)dim);
        if (w != null && (te = w.func_147438_o(x, y, z)) != null && te instanceof TileTeleporter) {
            return (TileTeleporter)te;
        }
        return null;
    }

    public TileTeleporter getLinkedTile() {
        if (this.linked == null) {
            return null;
        }
        return TileTeleporter.getTileXPT(this.linked.x, this.linked.y, this.linked.z, this.linked.dim);
    }

    public void onPlayerCollided(EntityPlayerMP ep) {
        if (this.linked != null && this.isServer() && this.cooldown <= 0 && ep.func_70093_af() && !(ep instanceof FakePlayer)) {
            ep.func_70095_a(false);
            TileTeleporter t = this.getLinkedTile();
            if (t == null || t.linked == null || this.equals((Object)t.getLinkedTile())) {
                int levels;
                if (t != null && t.linked == null) {
                    t.createLink(this, false);
                }
                boolean crossdim = this.linked.dim != this.getDimension();
                int n = levels = XPTConfig.only_linking_uses_xp.get() ? 0 : this.getLevels(this.linked.x, this.linked.y, this.linked.z, crossdim);
                if (!XPTConfig.canConsumeLevels((EntityPlayer)ep, levels)) {
                    XPTChatMessages.NEED_XP_LEVEL_TP.print((ICommandSender)ep, Integer.toString(levels));
                    return;
                }
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
                if (LMDimUtils.teleportPlayer((Entity)ep, (BlockDimPos)this.linked)) {
                    XPTConfig.consumeLevels((EntityPlayer)ep, levels);
                    this.cooldown = XPTConfig.cooldownTicks();
                    this.func_70296_d();
                    if (t != null) {
                        t.cooldown = this.cooldown;
                        t.func_70296_d();
                    }
                    ep.field_70170_p.func_72908_a((double)this.linked.x + 0.5, (double)this.linked.y + 1.5, (double)this.linked.z + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
                }
            }
        }
    }

    private int getLevels(int x, int y, int z, boolean crossdim) {
        if (crossdim) {
            return XPTConfig.levels_for_crossdim.get();
        }
        double dist = crossdim ? 0.0 : Math.sqrt(this.func_145835_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
        return Math.max(0, (XPTConfig.levels_for_1000_blocks.get() > 0 ? MathHelper.func_76143_f((double)((double)XPTConfig.levels_for_1000_blocks.get() * dist / 1000.0)) : 0) - 1);
    }

    public void onPlacedBy(EntityPlayer el, ItemStack is) {
        if (is.func_82837_s()) {
            this.setName(is.func_82833_r());
        }
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        double d = 0.5;
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - d), (double)this.field_145848_d, (double)((double)this.field_145849_e - d), (double)((double)this.field_145851_c + 1.0 + d), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 1.0 + d));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 64.0;
    }

    public void onBroken() {
        super.onBroken();
    }

    public void setName(String s) {
        this.name = s == null || s.isEmpty() ? null : s;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }
}

