/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.misc.vecmath;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class Vecs3d {
    protected double x;
    protected double y;
    protected double z;
    protected World w = null;

    public Vecs3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vecs3d(double x, double y, double z, World w) {
        this(x, y, z);
        this.w = w;
    }

    public Vecs3d(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w());
    }

    public Vecs3d(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vecs3d(Vec3 vec, World w) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        this.w = w;
    }

    public boolean hasWorld() {
        return this.w != null;
    }

    public Vecs3d add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vecs3d add(ForgeDirection dir) {
        return this.add(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Vecs3d add(Vecs3d vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vecs3d sub(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vecs3d sub(ForgeDirection dir) {
        return this.sub(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Vecs3d sub(Vecs3d vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    public Vecs3d mul(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vecs3d mul(double multiplier) {
        return this.mul(multiplier, multiplier, multiplier);
    }

    public Vecs3d mul(ForgeDirection direction) {
        return this.mul(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public Vecs3d multiply(Vecs3d v) {
        return this.mul(v.getX(), v.getY(), v.getZ());
    }

    public Vecs3d div(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vecs3d div(double multiplier) {
        return this.div(multiplier, multiplier, multiplier);
    }

    public Vecs3d div(ForgeDirection direction) {
        return this.div(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vecs3d normalize() {
        Vecs3d v = this.clone();
        double len = this.length();
        if (len == 0.0) {
            return v;
        }
        v.x /= len;
        v.y /= len;
        v.z /= len;
        return v;
    }

    public Vecs3d abs() {
        return new Vecs3d(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public double dot(Vecs3d v) {
        return this.x * v.getX() + this.y * v.getY() + this.z * v.getZ();
    }

    public Vecs3d cross(Vecs3d v) {
        return new Vecs3d(this.y * v.getZ() - this.z * v.getY(), this.x * v.getZ() - this.z * v.getX(), this.x * v.getY() - this.y * v.getX());
    }

    public Vecs3d getRelative(double x, double y, double z) {
        return this.clone().add(x, y, z);
    }

    public Vecs3d getRelative(ForgeDirection dir) {
        return this.getRelative(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public ForgeDirection getDirectionTo(Vecs3d vec) {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getBlockX() + d.offsetX != vec.getBlockX() || this.getBlockY() + d.offsetY != vec.getBlockY() || this.getBlockZ() + d.offsetZ != vec.getBlockZ()) continue;
            return d;
        }
        return null;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Vecs3d clone() {
        return new Vecs3d(this.x, this.y, this.z, this.w);
    }

    public boolean hasTileEntity() {
        if (this.hasWorld()) {
            return this.w.func_147438_o((int)this.x, (int)this.y, (int)this.z) != null;
        }
        return false;
    }

    public TileEntity getTileEntity() {
        if (this.hasTileEntity()) {
            return this.w.func_147438_o((int)this.x, (int)this.y, (int)this.z);
        }
        return null;
    }

    public boolean isBlock(Block b) {
        return this.isBlock(b, false);
    }

    public boolean isBlock(Block b, boolean checkAir) {
        if (this.hasWorld()) {
            Block bl = this.w.func_147439_a((int)this.x, (int)this.y, (int)this.z);
            if (b == null && bl == Blocks.field_150350_a) {
                return true;
            }
            if (b == null && checkAir && bl.func_149688_o() == Material.field_151579_a) {
                return true;
            }
            if (b == null && checkAir && bl.isAir((IBlockAccess)this.w, (int)this.x, (int)this.y, (int)this.z)) {
                return true;
            }
            return bl.getClass().isInstance(b);
        }
        return false;
    }

    public int getBlockMeta() {
        if (this.hasWorld()) {
            return this.w.func_72805_g((int)this.x, (int)this.y, (int)this.z);
        }
        return -1;
    }

    public Block getBlock() {
        return this.getBlock(false);
    }

    public Block getBlock(boolean airIsNull) {
        if (this.hasWorld()) {
            if (airIsNull && this.isBlock(null, true)) {
                return null;
            }
            return this.w.func_147439_a((int)this.x, (int)this.y, (int)this.z);
        }
        return null;
    }

    public World getWorld() {
        return this.w;
    }

    public Vecs3d setWorld(World world) {
        this.w = world;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockX() {
        return (int)Math.floor(this.x);
    }

    public int getBlockY() {
        return (int)Math.floor(this.y);
    }

    public int getBlockZ() {
        return (int)Math.floor(this.z);
    }

    public double distanceTo(Vecs3d vec) {
        return this.distanceTo(vec.x, vec.y, vec.z);
    }

    public double distanceTo(double x, double y, double z) {
        double dx = x - this.x;
        double dy = y - this.y;
        double dz = z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vecs3d) {
            Vecs3d vec = (Vecs3d)obj;
            return vec.w == this.w && vec.x == this.x && vec.y == this.y && vec.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.x).hashCode() + new Double(this.y).hashCode() << 8 + new Double(this.z).hashCode() << 16;
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public String toString() {
        String s = "Vector3{";
        if (this.hasWorld()) {
            s = s + "w=" + this.w.field_73011_w.field_76574_g + ";";
        }
        s = s + "x=" + this.x + ";y=" + this.y + ";z=" + this.z + "}";
        return s;
    }

    public ForgeDirection toForgeDirection() {
        if (this.z == 1.0) {
            return ForgeDirection.SOUTH;
        }
        if (this.z == -1.0) {
            return ForgeDirection.NORTH;
        }
        if (this.x == 1.0) {
            return ForgeDirection.EAST;
        }
        if (this.x == -1.0) {
            return ForgeDirection.WEST;
        }
        if (this.y == 1.0) {
            return ForgeDirection.UP;
        }
        if (this.y == -1.0) {
            return ForgeDirection.DOWN;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static Vecs3d fromString(String s) {
        if (s.startsWith("Vector3{") && s.endsWith("}")) {
            World w = null;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            String s2 = s.substring(s.indexOf("{") + 1, s.lastIndexOf("}"));
            StringTokenizer st = new StringTokenizer(s2, ";");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.toLowerCase().startsWith("w")) {
                    int world = Integer.parseInt(t.split("=")[1]);
                    if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                        for (WorldServer wo : MinecraftServer.func_71276_C().field_71305_c) {
                            if (wo.field_73011_w.field_76574_g != world) continue;
                            w = wo;
                            break;
                        }
                    } else {
                        w = Vecs3d.getClientWorld(world);
                    }
                }
                if (t.toLowerCase().startsWith("x")) {
                    x = Double.parseDouble(t.split("=")[1]);
                }
                if (t.toLowerCase().startsWith("y")) {
                    y = Double.parseDouble(t.split("=")[1]);
                }
                if (!t.toLowerCase().startsWith("z")) continue;
                z = Double.parseDouble(t.split("=")[1]);
            }
            if (w != null) {
                return new Vecs3d(x, y, z, w);
            }
            return new Vecs3d(x, y, z);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld(int world) {
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g != world) {
            return null;
        }
        return Minecraft.func_71410_x().field_71441_e;
    }
}

