/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.multiblock.component;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class MultiblockComponent {
    public ChunkCoordinates relPos;
    public final Block block;
    public final int meta;

    public MultiblockComponent(ChunkCoordinates relPos, Block block, int meta) {
        this.relPos = relPos;
        this.block = block;
        this.meta = meta;
    }

    public ChunkCoordinates getRelativePosition() {
        return this.relPos;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean matches(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this.getBlock() && (this.meta == -1 || world.func_72805_g(x, y, z) == this.meta);
    }

    public ItemStack[] getMaterials() {
        return new ItemStack[]{new ItemStack(this.block, 1, this.meta)};
    }

    public void rotate(double angle) {
        double x = this.relPos.field_71574_a;
        double z = this.relPos.field_71573_c;
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double xn = x * cos - z * sin;
        double zn = x * sin + z * cos;
        this.relPos = new ChunkCoordinates((int)Math.round(xn), this.relPos.field_71572_b, (int)Math.round(zn));
    }

    public MultiblockComponent copy() {
        return new MultiblockComponent(this.relPos, this.block, this.meta);
    }
}

