/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import openmods.reflection.TypeUtils;
import openmods.utils.CachedFactory;
import openperipheral.api.converter.IConverter;
import openperipheral.api.struct.ScriptStruct;
import openperipheral.api.struct.StructField;

public class StructHandlerProvider {
    public static final StructHandlerProvider instance = new StructHandlerProvider();
    private static final Ordering<Field> FIELD_NAME_ORDERING = Ordering.natural().onResultOf((Function)new Function<Field, String>(){

        public String apply(@Nullable Field input) {
            return input != null ? input.getName() : "";
        }
    });
    private final CachedFactory<Class<?>, Boolean> checkedClasses = new CachedFactory<Class<?>, Boolean>(){

        protected Boolean create(Class<?> key) {
            return key.getAnnotation(ScriptStruct.class) != null;
        }
    };
    private final CachedFactory<Class<?>, IStructHandler> handlers = new CachedFactory<Class<?>, IStructHandler>(){

        protected IStructHandler create(Class<?> cls) {
            if (cls.getEnclosingClass() != null && !Modifier.isStatic(cls.getModifiers())) {
                throw new InvalidStructureException("Can't create serializer for not-static inner " + cls);
            }
            ScriptStruct struct = cls.getAnnotation(ScriptStruct.class);
            if (struct == null) {
                throw new InvalidStructureException("Trying to generate serializer for unserializable " + cls);
            }
            try {
                Constructor<?> ctor = cls.getConstructor(new Class[0]);
                return new StructHandler(struct, ctor);
            }
            catch (Exception e) {
                throw new InvalidStructureException(cls, (Throwable)e);
            }
        }
    };

    public boolean isStruct(Class<?> cls) {
        return (Boolean)this.checkedClasses.getOrCreate(cls);
    }

    public IStructHandler getHandler(Class<?> cls) {
        return (IStructHandler)this.handlers.getOrCreate(cls);
    }

    private static class StructHandler
    implements IStructHandler {
        private final Constructor<?> ctor;
        private final Map<String, IFieldHandler> namedFields;
        private final List<IFieldHandler> indexedFields;
        private final Set<IFieldHandler> optionalFields;
        private final ScriptStruct.Output output;

        public StructHandler(ScriptStruct meta, Constructor<?> ctor) {
            this.ctor = ctor;
            this.output = meta.defaultOutput();
            ImmutableSet.Builder optionalFields = ImmutableSet.builder();
            Class<?> cls = this.ctor.getDeclaringClass();
            ArrayList sortedFields = Lists.newArrayList((Object[])cls.getFields());
            Collections.sort(sortedFields, FIELD_NAME_ORDERING);
            TreeMap indexedFields = Maps.newTreeMap();
            int autoIndex = 0;
            for (Field field : sortedFields) {
                StructField fieldMarker = field.getAnnotation(StructField.class);
                if (fieldMarker == null) continue;
                boolean isOptional = fieldMarker.optional();
                int markerIndex = fieldMarker.index();
                int index = markerIndex != Integer.MIN_VALUE ? markerIndex : autoIndex;
                ++autoIndex;
                Object handler = new FieldHandler(cls, field, field.getName(), index, isOptional);
                IFieldHandler prev = indexedFields.put(index, handler);
                if (prev != null) {
                    throw new IllegalArgumentException(String.format("Duplicate index %d on fields %s and %s", index, ((FieldHandler)handler).name(), prev.name()));
                }
                if (!isOptional) continue;
                optionalFields.add(handler);
            }
            this.optionalFields = optionalFields.build();
            int fieldCount = indexedFields.size();
            Object[] collectedFields = new IFieldHandler[fieldCount];
            for (IFieldHandler handler : indexedFields.values()) {
                int index = handler.index();
                Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"Negative index on field %s", (Object[])new Object[]{handler.name()});
                Preconditions.checkArgument((index < fieldCount ? 1 : 0) != 0, (String)"Non-continuous field numbering on field %s (max index allowed: %s)", (Object[])new Object[]{handler.name(), fieldCount - 1});
                collectedFields[index] = handler;
            }
            this.indexedFields = ImmutableList.copyOf((Object[])collectedFields);
            ImmutableMap.Builder namedFields = ImmutableMap.builder();
            for (Object handler : collectedFields) {
                Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"Non-continuous field numbering");
                namedFields.put((Object)handler.name(), handler);
            }
            this.namedFields = namedFields.build();
        }

        @Override
        public Object toJava(IConverter converter, Map<?, ?> obj, int indexOffset) {
            Object result;
            try {
                result = this.ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create object", e);
            }
            Set safeFields = Sets.newIdentityHashSet();
            safeFields.addAll(this.optionalFields);
            for (Map.Entry<?, ?> entry : obj.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key instanceof String) {
                    IFieldHandler f = this.namedFields.get(key);
                    Preconditions.checkArgument((f != null ? 1 : 0) != 0, (String)"Extraneous field: %s = %s", (Object[])new Object[]{key, value});
                    StructHandler.setField(converter, result, key, f, value);
                    safeFields.add(f);
                    continue;
                }
                if (key instanceof Number) {
                    int index = ((Number)key).intValue() - indexOffset;
                    Preconditions.checkArgument((index < this.indexedFields.size() ? 1 : 0) != 0, (String)"Index %s is outside of allowed range for structure", (Object[])new Object[]{index});
                    IFieldHandler f = this.indexedFields.get(index);
                    Preconditions.checkArgument((f != null ? 1 : 0) != 0, (String)"Extraneous field: %s = %s", (Object[])new Object[]{key, value});
                    StructHandler.setField(converter, result, key, f, value);
                    safeFields.add(f);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Extraneous field %s = %s", key, value));
            }
            for (Map.Entry<Object, Object> entry : this.namedFields.entrySet()) {
                if (safeFields.contains(entry.getValue())) continue;
                throw new IllegalArgumentException(String.format("Field %s not set", entry.getKey()));
            }
            return result;
        }

        private static void setField(IConverter converter, Object obj, Object fieldKey, IFieldHandler field, Object value) {
            Object converted = StructHandler.convertToJava(converter, field, fieldKey, value);
            field.set(obj, converted);
        }

        private static Object convertToJava(IConverter converter, IFieldHandler field, Object key, Object value) {
            try {
                return converter.toJava(value, field.type());
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to convert field " + key, ex);
            }
        }

        private static Object convertFromJava(IConverter converter, IFieldHandler field, Object key, Object value) {
            try {
                return converter.fromJava(value);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to convert field " + key, ex);
            }
        }

        @Override
        public Map<?, ?> fromJava(IConverter converter, Object obj, int indexOffset) {
            if (this.output == ScriptStruct.Output.OBJECT) {
                HashMap result = Maps.newHashMap();
                for (Map.Entry<String, IFieldHandler> e : this.namedFields.entrySet()) {
                    StructHandler.addFieldFromJava(converter, obj, result, e.getKey(), e.getValue());
                }
                return result;
            }
            HashMap result = Maps.newHashMap();
            int index = indexOffset;
            for (IFieldHandler handler : this.indexedFields) {
                StructHandler.addFieldFromJava(converter, obj, result, index++, handler);
            }
            return result;
        }

        private static <T> void addFieldFromJava(IConverter converter, Object obj, Map<T, Object> result, T key, IFieldHandler f) {
            Object value = f.get(obj);
            Object converted = StructHandler.convertFromJava(converter, f, key, value);
            result.put(key, converted);
        }

        @Override
        public List<IFieldHandler> fields() {
            return this.indexedFields;
        }

        @Override
        public IFieldHandler field(String name) {
            return this.namedFields.get(name);
        }

        @Override
        public ScriptStruct.Output defaultOutput() {
            return this.output;
        }
    }

    private static class FieldHandler
    implements IFieldHandler {
        private final Type type;
        private final Field field;
        private final String name;
        private final int index;
        private final boolean isOptional;

        public FieldHandler(Class<?> ownerCls, Field field, String name, int index, boolean isOptional) {
            TypeToken fieldType = TypeUtils.resolveFieldType(ownerCls, (Field)field);
            this.type = fieldType.getType();
            this.field = field;
            this.name = name;
            this.index = index;
            this.isOptional = isOptional;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Object get(Object target) {
            try {
                return this.field.get(target);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to get value of field " + this.field, ex);
            }
        }

        @Override
        public void set(Object target, Object value) {
            try {
                this.field.set(target, value);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to set value of field " + this.field, ex);
            }
        }
    }

    public static interface IStructHandler {
        public Object toJava(IConverter var1, Map<?, ?> var2, int var3);

        public Map<?, ?> fromJava(IConverter var1, Object var2, int var3);

        public IFieldHandler field(String var1);

        public List<IFieldHandler> fields();

        public ScriptStruct.Output defaultOutput();
    }

    public static interface IFieldHandler {
        public int index();

        public String name();

        public Type type();

        public boolean isOptional();

        public Object get(Object var1);

        public void set(Object var1, Object var2);
    }

    public static class InvalidStructureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidStructureException(Class<?> cls, Throwable cause) {
            super("Invalid structure: " + cls, cause);
        }

        public InvalidStructureException(String message) {
            super(message);
        }
    }
}

