/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import openmods.calc.ExecutableList;
import openmods.calc.ICompiler;
import openmods.calc.IExecutable;
import openmods.calc.IValueParser;
import openmods.calc.InvalidTokenException;
import openmods.calc.Operator;
import openmods.calc.OperatorDictionary;
import openmods.calc.SymbolReference;
import openmods.calc.Token;
import openmods.calc.TokenType;
import openmods.calc.Value;

public class PostfixCompiler<E>
implements ICompiler<E> {
    private final IValueParser<E> valueParser;
    private final OperatorDictionary<E> operators;

    public PostfixCompiler(IValueParser<E> valueParser, OperatorDictionary<E> operators) {
        this.valueParser = valueParser;
        this.operators = operators;
    }

    @Override
    public IExecutable<E> compile(Iterable<Token> input) {
        ArrayList result = Lists.newArrayList();
        for (Token token : input) {
            result.add(this.compileToken(token));
        }
        return new ExecutableList(result);
    }

    private IExecutable<E> compileToken(Token token) {
        String value = token.value;
        if (token.type == TokenType.OPERATOR) {
            Operator<E> operator = this.operators.getAnyOperator(value);
            Preconditions.checkArgument((operator != null ? 1 : 0) != 0, (Object)("Invalid operator: " + token));
            return operator;
        }
        if (token.type == TokenType.SYMBOL) {
            return new SymbolReference(value);
        }
        if (token.type == TokenType.SYMBOL_WITH_ARGS) {
            return PostfixCompiler.parseSymbolWithArgs(value);
        }
        if (token.type.isValue()) {
            try {
                E parsedValue = this.valueParser.parseToken(token);
                return Value.create(parsedValue);
            }
            catch (Throwable t) {
                throw new InvalidTokenException(token, t);
            }
        }
        throw new InvalidTokenException(token);
    }

    private static <E> IExecutable<E> parseSymbolWithArgs(String value) {
        int argsStart = value.indexOf(64);
        Preconditions.checkArgument((argsStart >= 0 ? 1 : 0) != 0, (String)"No args in token '%s'", (Object[])new Object[]{value});
        String id = value.substring(0, argsStart);
        SymbolReference ref = new SymbolReference(id);
        try {
            String args = value.substring(argsStart + 1, value.length());
            int argsSeparator = args.indexOf(44);
            if (argsSeparator >= 0) {
                String retCountStr;
                String argCountStr = args.substring(0, argsSeparator);
                if (!argCountStr.isEmpty()) {
                    int argCount = Integer.parseInt(argCountStr);
                    ref.setArgumentsCount(argCount);
                }
                if (!(retCountStr = args.substring(argsSeparator + 1, args.length())).isEmpty()) {
                    int retCount = Integer.parseInt(retCountStr);
                    ref.setReturnsCount(retCount);
                }
            } else {
                int argCount = Integer.parseInt(args);
                ref.setArgumentsCount(argCount);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't parse args on token '" + value + "'", e);
        }
        return ref;
    }
}

