/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import java.math.BigInteger;
import openmods.calc.BigIntParser;
import openmods.calc.BigIntPrinter;
import openmods.calc.BinaryFunction;
import openmods.calc.BinaryOperator;
import openmods.calc.Calculator;
import openmods.calc.ISymbol;
import openmods.calc.OperatorDictionary;
import openmods.calc.TernaryFunction;
import openmods.calc.TopFrame;
import openmods.calc.UnaryFunction;
import openmods.calc.UnaryOperator;
import openmods.config.simpler.Configurable;

public class BigIntCalculator
extends Calculator<BigInteger> {
    @Configurable
    public int base = 10;
    @Configurable
    public boolean uniformBaseNotation = false;
    private final BigIntPrinter printer = new BigIntPrinter();
    private static final int MAX_PRIO = 6;

    public BigIntCalculator() {
        super(new BigIntParser(), BigInteger.ZERO);
    }

    @Override
    protected void setupOperators(OperatorDictionary<BigInteger> operators) {
        operators.registerUnaryOperator("~", new UnaryOperator<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger value) {
                return value.not();
            }
        });
        operators.registerUnaryOperator("neg", new UnaryOperator<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger value) {
                return value.negate();
            }
        });
        operators.registerBinaryOperator("^", new BinaryOperator<BigInteger>(1){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.xor(right);
            }
        });
        operators.registerBinaryOperator("|", new BinaryOperator<BigInteger>(1){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.or(right);
            }
        });
        operators.registerBinaryOperator("&", new BinaryOperator<BigInteger>(1){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.and(right);
            }
        });
        operators.registerMixedOperator("+", new BinaryOperator<BigInteger>(2){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.add(right);
            }
        }, new UnaryOperator<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger value) {
                return value;
            }
        });
        operators.registerMixedOperator("-", new BinaryOperator<BigInteger>(2){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.subtract(right);
            }
        }, new UnaryOperator<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger value) {
                return value.negate();
            }
        });
        operators.registerBinaryOperator("*", new BinaryOperator<BigInteger>(3){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.multiply(right);
            }
        });
        operators.registerBinaryOperator("/", new BinaryOperator<BigInteger>(3){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.divide(right);
            }
        });
        operators.registerBinaryOperator("%", new BinaryOperator<BigInteger>(3){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.mod(right);
            }
        });
        operators.registerBinaryOperator("**", new BinaryOperator<BigInteger>(4){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.pow(right.intValue());
            }
        });
        operators.registerBinaryOperator("<<", new BinaryOperator<BigInteger>(5){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.shiftLeft(right.intValue());
            }
        });
        operators.registerBinaryOperator(">>", new BinaryOperator<BigInteger>(5){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.shiftRight(right.intValue());
            }
        });
    }

    @Override
    protected void setupGlobals(TopFrame<BigInteger> globals) {
        globals.setSymbol("abs", (ISymbol<BigInteger>)new UnaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger value) {
                return value.abs();
            }
        });
        globals.setSymbol("sgn", (ISymbol<BigInteger>)new UnaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger value) {
                return BigInteger.valueOf(value.signum());
            }
        });
        globals.setSymbol("min", new Calculator.AccumulatorFunction(){

            protected BigInteger accumulate(BigInteger result, BigInteger value) {
                return result.min(value);
            }
        });
        globals.setSymbol("max", new Calculator.AccumulatorFunction(){

            protected BigInteger accumulate(BigInteger result, BigInteger value) {
                return result.max(value);
            }
        });
        globals.setSymbol("gcd", (ISymbol<BigInteger>)new BinaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.gcd(right);
            }
        });
        globals.setSymbol("gcd", (ISymbol<BigInteger>)new BinaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger left, BigInteger right) {
                return left.gcd(right);
            }
        });
        globals.setSymbol("modpow", (ISymbol<BigInteger>)new TernaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger first, BigInteger second, BigInteger third) {
                return first.modPow(second, third);
            }
        });
        globals.setSymbol("get", (ISymbol<BigInteger>)new BinaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger first, BigInteger second) {
                return first.testBit(second.intValue()) ? BigInteger.ONE : BigInteger.ZERO;
            }
        });
        globals.setSymbol("set", (ISymbol<BigInteger>)new BinaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger first, BigInteger second) {
                return first.setBit(second.intValue());
            }
        });
        globals.setSymbol("clear", (ISymbol<BigInteger>)new BinaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger first, BigInteger second) {
                return first.clearBit(second.intValue());
            }
        });
        globals.setSymbol("flip", (ISymbol<BigInteger>)new BinaryFunction<BigInteger>(){

            @Override
            protected BigInteger execute(BigInteger first, BigInteger second) {
                return first.flipBit(second.intValue());
            }
        });
    }

    @Override
    public String toString(BigInteger value) {
        if (this.base < 2) {
            return "invalid radix";
        }
        return BigIntCalculator.decorateBase(!this.uniformBaseNotation, this.base, this.base <= 36 ? value.toString(this.base) : this.printer.toString(value, this.base));
    }
}

