/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.block;

import com.whammich.sstow.tileentity.TileEntityCage;
import com.whammich.sstow.utils.HolidayHelper;
import com.whammich.sstow.utils.ModLogger;
import com.whammich.sstow.utils.Register;
import com.whammich.sstow.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCage
extends BlockContainer {
    public IIcon[] icons = new IIcon[5];
    private IIcon front;

    public BlockCage() {
        super(Material.field_151573_f);
        this.func_149663_c("sstow.cage_block");
        this.func_149647_a(Register.CREATIVE_TAB);
        this.field_149782_v = 3.0f;
        this.field_149781_w = 3.0f;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int xPos, int yPos, int zPos, int p_149736_5_) {
        TileEntityCage tile = (TileEntityCage)world.func_147438_o(xPos, yPos, zPos);
        if (tile.func_70301_a(0) != null) {
            ItemStack shard = tile.func_70301_a(0);
            byte tier = Utils.getShardTier(shard);
            switch (tier) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 7;
                }
                case 4: {
                    return 10;
                }
                case 5: {
                    return 15;
                }
            }
            return 0;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float f1, float f2, float f3) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile == null) {
                ModLogger.logFatal("ERROR: no tile entity found at coords: " + x + " " + y + " " + " " + z);
                return false;
            }
            if (player.func_70093_af()) {
                if (world.func_72805_g(x, y, z) == 0) {
                    return false;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                world.func_72838_d((Entity)new EntityItem(world, (double)x + (double)dir.offsetX * 1.75, (double)y + (double)dir.offsetY * 1.75 + 0.5, (double)z + (double)dir.offsetZ * 1.75, ((IInventory)tile).func_70298_a(0, 1)));
            } else {
                if (world.func_72805_g(x, y, z) != 0) {
                    return false;
                }
                ItemStack stack = player.func_70694_bm();
                if (stack == null || stack.func_77973_b() != Register.SOUL_SHARD || !Utils.isShardBound(stack) || Utils.getShardTier(stack) == 0) {
                    return false;
                }
                ItemStack newShard = stack.func_77946_l();
                newShard.field_77994_a = 1;
                ((IInventory)tile).func_70299_a(0, newShard);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityCage) {
            ((TileEntityCage)tile).checkRedstone();
        }
    }

    public void onBlockPlacedBy(World world, int xCoord, int yCoord, int zCoord, EntityPlayer entity, ItemStack itemstack) {
        entity.getDisplayName();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) != 0) {
            world.func_72921_c(x, y, z, 0, 2);
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && meta != 0) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile == null) {
                ModLogger.logFatal("ERROR: no tile entity found at coords: " + x + " " + y + " " + " " + z);
                return;
            }
            ItemStack stack = ((IInventory)tile).func_70298_a(0, 1);
            if (stack != null) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, stack));
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCage();
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public int func_149692_a(int par1) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        if (HolidayHelper.isChristmas()) {
            this.icons = new IIcon[4];
            for (int i = 0; i < 4; ++i) {
                this.icons[i] = iconRegister.func_94245_a("sstow:cage_" + i + "_xmas");
            }
        } else {
            this.icons = new IIcon[5];
            for (int i = 0; i < 5; ++i) {
                this.icons[i] = iconRegister.func_94245_a("sstow:cage_" + i);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int sideInt, int meta) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)sideInt);
        if (HolidayHelper.isChristmas()) {
            if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) {
                return this.icons[3];
            }
            if (meta == 2) {
                return this.icons[1];
            }
            if (meta == 1) {
                return this.icons[1];
            }
            return this.icons[0];
        }
        if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) {
            if (meta == 2) {
                return this.icons[4];
            }
            return this.icons[3];
        }
        if (meta == 2) {
            return this.icons[2];
        }
        if (meta == 1) {
            return this.icons[1];
        }
        return this.icons[0];
    }
}

