/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.ASMEventHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.ListenerList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.api.GraveDropsEvent;
import openblocks.api.GraveSpawnEvent;
import openblocks.common.PlayerInventoryStore;
import openblocks.common.tileentity.TileEntityGrave;
import openmods.Log;
import openmods.inventory.GenericInventory;
import openmods.inventory.legacy.ItemDistribution;
import openmods.utils.Coord;
import openmods.utils.TagUtils;
import openmods.world.DelayedActionTickHandler;
import org.apache.logging.log4j.Level;

public class PlayerDeathHandler {
    private static final Comparator<Coord> SEARCH_COMPARATOR = new Comparator<Coord>(){

        private int coordSum(Coord c) {
            return Math.abs(c.x) + Math.abs(c.y) + Math.abs(c.z);
        }

        private int coordMax(Coord c) {
            return Math.max(Math.max(Math.abs(c.x), Math.abs(c.y)), Math.abs(c.z));
        }

        @Override
        public int compare(Coord a, Coord b) {
            int diff = this.coordSum(a) - this.coordSum(b);
            if (diff != 0) {
                return diff;
            }
            return this.coordMax(b) - this.coordMax(a);
        }
    };
    private static SearchOrder searchOrder;
    private static final GravePlacementChecker POLITE;
    private static final GravePlacementChecker BRUTAL;

    private static Iterable<Coord> getSearchOrder(int size) {
        if (searchOrder == null || PlayerDeathHandler.searchOrder.size != size) {
            searchOrder = new SearchOrder(size);
        }
        return searchOrder;
    }

    private static Level debugLevel() {
        return Config.debugGraves ? Level.INFO : Level.DEBUG;
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void onPlayerDrops(PlayerDropsEvent event) {
        World world = event.entityPlayer.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (Config.debugGraves) {
            PlayerDeathHandler.dumpDebugInfo(event);
        }
        EntityPlayer player = event.entityPlayer;
        if (OpenBlocks.Blocks.grave == null) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"OpenBlocks graves disabled, not placing (player '%s')", (Object[])new Object[]{player});
            return;
        }
        if (player instanceof FakePlayer) {
            Log.debug((String)"'%s' (%s) is a fake player, grave will not be spawned", (Object[])new Object[]{player, player.getClass()});
            return;
        }
        if (event.isCanceled()) {
            Log.warn((String)"Event for player '%s' cancelled, grave will not be spawned", (Object[])new Object[]{player});
            return;
        }
        ArrayList drops = event.drops;
        if (drops.isEmpty()) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"No drops from player '%s', grave will not be spawned'", (Object[])new Object[]{player});
            return;
        }
        GameRules gameRules = world.func_82736_K();
        if (gameRules.func_82766_b("keepInventory") || !gameRules.func_82766_b("openblocks:spawn_graves")) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"Graves disabled by gamerule (player '%s')", (Object[])new Object[]{player});
            return;
        }
        GraveDropsEvent dropsEvent = new GraveDropsEvent(player);
        for (EntityItem drop : drops) {
            dropsEvent.addItem(drop);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)dropsEvent)) {
            Log.warn((String)"Grave drops event for player '%s' cancelled, grave will not be spawned'", (Object[])new Object[]{player});
            return;
        }
        drops.clear();
        ArrayList graveLoot = Lists.newArrayList();
        block5: for (GraveDropsEvent.ItemAction entry : dropsEvent.drops) {
            switch (entry.action) {
                case DELETE: {
                    if (!Config.debugGraves) continue block5;
                    Log.info((String)"Item %s is going to be deleted", (Object[])new Object[]{entry.item});
                    continue block5;
                }
                case DROP: {
                    if (Config.debugGraves) {
                        Log.info((String)"Item %s is going to be dropped", (Object[])new Object[]{entry.item});
                    }
                    drops.add(entry.item);
                    continue block5;
                }
            }
            graveLoot.add(entry.item);
        }
        if (graveLoot.isEmpty()) {
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"No grave drops left for player '%s' after event filtering, grave will not be spawned'", (Object[])new Object[]{player});
            return;
        }
        Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"Scheduling grave placement for player '%s':'%s' with %d item(s)", (Object[])new Object[]{player, player.func_146103_bH(), graveLoot.size()});
        DelayedActionTickHandler.INSTANCE.addTickCallback(world, (Runnable)new GraveCallable(world, player, graveLoot));
    }

    private static void dumpDebugInfo(PlayerDropsEvent event) {
        Log.info((String)"Trying to spawn grave for player '%s':'%s'", (Object[])new Object[]{event.entityPlayer, event.entityPlayer.func_146103_bH()});
        int i = 0;
        for (EntityItem e : event.drops) {
            Log.info((String)"\tGrave drop %d: %s -> %s", (Object[])new Object[]{i++, e.getClass(), e.func_92059_d()});
        }
        ListenerList listeners = event.getListenerList();
        try {
            int busId = 0;
            while (true) {
                Log.info((String)"Dumping event %s listeners on bus %d", (Object[])new Object[]{event.getClass(), busId});
                for (IEventListener listener : listeners.getListeners(busId)) {
                    if (listener instanceof ASMEventHandler) {
                        try {
                            ASMEventHandler handler = (ASMEventHandler)listener;
                            Object o = ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)handler, (String[])new String[]{"handler"});
                            Log.info((String)"\t'%s' (handler %s, priority: %s)", (Object[])new Object[]{handler, o.getClass(), handler.getPriority()});
                            continue;
                        }
                        catch (Throwable e) {
                            Log.log((Level)Level.INFO, (Throwable)e, (String)"Exception while getting field", (Object[])new Object[0]);
                        }
                    }
                    Log.info((String)"\t%s", (Object[])new Object[]{listener.getClass()});
                }
                ++busId;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    static {
        POLITE = new GravePlacementChecker(){

            @Override
            public boolean checkBlock(World world, int x, int y, int z, Block block) {
                return block.isAir((IBlockAccess)world, x, y, z) || block.isReplaceable((IBlockAccess)world, x, y, z);
            }
        };
        BRUTAL = new GravePlacementChecker(){

            @Override
            public boolean checkBlock(World world, int x, int y, int z, Block block) {
                return block.func_149712_f(world, x, y, z) >= 0.0f && world.func_147438_o(x, y, z) == null;
            }
        };
    }

    private static class GraveCallable
    implements Runnable {
        private final IChatComponent cause;
        private final GameProfile stiffId;
        private final int posX;
        private final int posY;
        private final int posZ;
        private final List<EntityItem> loot;
        private final WeakReference<World> world;
        private final WeakReference<EntityPlayer> exPlayer;

        public GraveCallable(World world, EntityPlayer exPlayer, List<EntityItem> loot) {
            this.posX = MathHelper.func_76128_c((double)exPlayer.field_70165_t);
            this.posY = MathHelper.func_76128_c((double)exPlayer.field_70163_u);
            this.posZ = MathHelper.func_76128_c((double)exPlayer.field_70161_v);
            this.world = new WeakReference<World>(world);
            this.exPlayer = new WeakReference<EntityPlayer>(exPlayer);
            this.stiffId = exPlayer.func_146103_bH();
            IChatComponent day = GraveCallable.formatDate(world);
            IChatComponent deathCause = exPlayer.func_110142_aN().func_151521_b();
            this.cause = new ChatComponentTranslation("openblocks.misc.grave_msg", new Object[]{deathCause, day});
            this.loot = ImmutableList.copyOf(loot);
        }

        private static IChatComponent formatDate(World world) {
            long time = world.func_82737_E();
            String day = String.format("%.1f", (double)time / 24000.0);
            ChatComponentText dayComponent = new ChatComponentText(day);
            dayComponent.func_150256_b().func_150238_a(EnumChatFormatting.WHITE).func_150227_a(Boolean.valueOf(true));
            return dayComponent;
        }

        private void setCommonStoreInfo(NBTTagCompound meta, boolean placed) {
            meta.func_74778_a("PlayerName", this.stiffId.getName());
            meta.func_74778_a("PlayerUUID", this.stiffId.getId().toString());
            meta.func_74782_a("PlayerLocation", (NBTBase)TagUtils.store((int)this.posX, (int)this.posY, (int)this.posZ));
            meta.func_74757_a("Placed", placed);
        }

        private boolean tryPlaceGrave(World world, final int x, final int y, final int z, String gravestoneText, IChatComponent deathMessage) {
            world.func_147465_d(x, y, z, (Block)OpenBlocks.Blocks.grave, 0, 3);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile == null || !(tile instanceof TileEntityGrave)) {
                Log.warn((String)"Failed to place grave @ %d,%d,%d: invalid tile entity: %s(%s)", (Object[])new Object[]{x, y, z, tile, tile != null ? tile.getClass() : "?"});
                return false;
            }
            TileEntityGrave grave = (TileEntityGrave)tile;
            IInventory loot = this.getLoot();
            if (Config.backupGraves) {
                this.backupGrave(world, loot, new PlayerInventoryStore.ExtrasFiller(){

                    @Override
                    public void addExtras(NBTTagCompound meta) {
                        GraveCallable.this.setCommonStoreInfo(meta, true);
                        meta.func_74782_a("GraveLocation", (NBTBase)TagUtils.store((int)x, (int)y, (int)z));
                    }
                });
            }
            Log.info((String)"Grave for (%s,%s) was spawned at (%d,%d,%d)", (Object[])new Object[]{this.stiffId.getId(), this.stiffId.getName(), x, y, z});
            grave.setUsername(gravestoneText);
            grave.setLoot(loot);
            grave.setDeathMessage(deathMessage);
            return true;
        }

        protected IInventory getLoot() {
            GenericInventory loot = new GenericInventory("tmpplayer", false, this.loot.size());
            for (EntityItem entityItem : this.loot) {
                ItemStack stack = entityItem.func_92059_d();
                if (stack == null) continue;
                ItemDistribution.insertItemIntoInventory((IInventory)loot, (ItemStack)stack.func_77946_l());
            }
            return loot;
        }

        private boolean trySpawnGrave(EntityPlayer player, World world) {
            GraveSpawnEvent evt;
            Coord location = this.findLocation(world, player);
            String gravestoneText = this.stiffId.getName();
            GraveSpawnEvent graveSpawnEvent = evt = location == null ? new GraveSpawnEvent(player, this.loot, gravestoneText, this.cause) : new GraveSpawnEvent(player, location.x, location.y, location.z, this.loot, gravestoneText, this.cause);
            if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                Log.warn((String)"Grave event for player %s cancelled, no grave will spawn", (Object[])new Object[]{this.stiffId});
                return false;
            }
            if (!evt.hasLocation()) {
                Log.warn((String)"No location for grave found, no grave will spawn", (Object[])new Object[]{this.stiffId});
                return false;
            }
            int x = evt.getX();
            int y = evt.getY();
            int z = evt.getZ();
            Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"Grave for %s will be spawned at (%d,%d,%d)", (Object[])new Object[]{this.stiffId, x, y, z});
            if (Config.graveBase && GraveCallable.canSpawnBase(world, player, x, y - 1, z)) {
                world.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
            }
            return this.tryPlaceGrave(world, evt.getX(), evt.getY(), evt.getZ(), evt.gravestoneText, evt.clickText);
        }

        private static boolean canSpawnBase(World world, EntityPlayer player, int x, int y, int z) {
            return world.func_72899_e(x, y, z) && world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z) && world.func_72962_a(player, x, y, z);
        }

        private Coord findLocation(World world, EntityPlayer player, GravePlacementChecker checker) {
            int correctedY = Config.voidGraves ? Math.max(this.posY, 1) : this.posY;
            int searchSize = Config.graveSpawnRange / 2;
            for (Coord c : PlayerDeathHandler.getSearchOrder(searchSize)) {
                int x = this.posX + c.x;
                int y = correctedY + c.y;
                int z = this.posZ + c.z;
                if (!checker.canPlace(world, player, x, y, z)) continue;
                return new Coord(x, y, z);
            }
            return null;
        }

        private Coord findLocation(World world, EntityPlayer player) {
            Coord location = this.findLocation(world, player, POLITE);
            if (location != null) {
                return location;
            }
            if (Config.destructiveGraves) {
                Log.warn((String)"Failed to place grave for player %s, going berserk", (Object[])new Object[]{this.stiffId});
                return this.findLocation(world, player, BRUTAL);
            }
            return null;
        }

        private void backupGrave(World world, IInventory loot, PlayerInventoryStore.ExtrasFiller filler) {
            try {
                File backup = PlayerInventoryStore.instance.storeInventory(loot, this.stiffId.getName(), "grave", world, filler);
                Log.log((Level)PlayerDeathHandler.debugLevel(), (String)"Grave backup for player %s saved to %s", (Object[])new Object[]{this.stiffId, backup});
            }
            catch (Throwable t) {
                Log.warn((String)"Failed to store grave backup for player %s", (Object[])new Object[]{this.stiffId});
            }
        }

        @Override
        public void run() {
            EntityPlayer player = (EntityPlayer)this.exPlayer.get();
            if (player == null) {
                Log.warn((String)"Lost player while placing player %s grave", (Object[])new Object[]{this.stiffId});
                return;
            }
            World world = (World)this.world.get();
            if (world == null) {
                Log.warn((String)"Lost world while placing player %s grave", (Object[])new Object[]{this.stiffId});
                return;
            }
            if (!this.trySpawnGrave(player, world)) {
                if (Config.backupGraves) {
                    IInventory loot = this.getLoot();
                    this.backupGrave(world, loot, new PlayerInventoryStore.ExtrasFiller(){

                        @Override
                        public void addExtras(NBTTagCompound meta) {
                            GraveCallable.this.setCommonStoreInfo(meta, false);
                        }
                    });
                }
                for (EntityItem drop : this.loot) {
                    world.func_72838_d((Entity)drop);
                }
            }
        }
    }

    private static abstract class GravePlacementChecker {
        private GravePlacementChecker() {
        }

        public boolean canPlace(World world, EntityPlayer player, int x, int y, int z) {
            if (!world.func_72899_e(x, y, z)) {
                return false;
            }
            if (!world.func_72962_a(player, x, y, z)) {
                return false;
            }
            Block block = world.func_147439_a(x, y, z);
            return this.checkBlock(world, x, y, z, block);
        }

        public abstract boolean checkBlock(World var1, int var2, int var3, int var4, Block var5);
    }

    private static class SearchOrder
    implements Iterable<Coord> {
        public final int size;
        private final List<Coord> coords;

        public SearchOrder(int size) {
            this.size = size;
            ArrayList coords = Lists.newArrayList();
            for (int x = -size; x <= size; ++x) {
                for (int y = -size; y <= size; ++y) {
                    for (int z = -size; z <= size; ++z) {
                        coords.add(new Coord(x, y, z));
                    }
                }
            }
            Collections.sort(coords, SEARCH_COMPARATOR);
            this.coords = ImmutableList.copyOf((Collection)coords);
        }

        @Override
        public Iterator<Coord> iterator() {
            return this.coords.iterator();
        }
    }
}

