/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics;

import cofh.api.core.IInitializer;
import cofh.core.CoFHProps;
import cofh.core.util.ConfigHandler;
import cofh.lib.util.helpers.MathHelper;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cofh.thermaldynamics.core.Proxy;
import cofh.thermaldynamics.core.TDProps;
import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.debughelper.CommandThermalDebug;
import cofh.thermaldynamics.debughelper.DebugHelper;
import cofh.thermaldynamics.debughelper.PacketDebug;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.entity.TileTransportDuctCrossover;
import cofh.thermaldynamics.gui.GuiHandler;
import cofh.thermaldynamics.gui.TDCreativeTab;
import cofh.thermaldynamics.gui.TDCreativeTabCovers;
import cofh.thermaldynamics.item.ItemCover;
import cofh.thermaldynamics.item.ItemFilter;
import cofh.thermaldynamics.item.ItemRelay;
import cofh.thermaldynamics.item.ItemRetriever;
import cofh.thermaldynamics.item.ItemServo;
import cofh.thermaldynamics.plugins.TDPlugins;
import cofh.thermaldynamics.util.crafting.RecipeCover;
import cofh.thermaldynamics.util.crafting.TDCrafting;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ThermalDynamics", name="Thermal Dynamics", version="1.7.10R1.2.0", dependencies="required-after:CoFHCore@[1.7.10R3.1.2,1.7.10R3.2.0);required-after:ThermalFoundation@[1.7.10R1.2.4,1.7.10R1.3.0);", guiFactory="cofh.thermaldynamics.gui.GuiConfigTDFactory", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class ThermalDynamics
extends BaseMod {
    public static final String modId = "ThermalDynamics";
    public static final String modName = "Thermal Dynamics";
    public static final String version = "1.7.10R1.2.0";
    public static final String version_max = "1.7.10R1.3.0";
    public static final String dependencies = "required-after:CoFHCore@[1.7.10R3.1.2,1.7.10R3.2.0);required-after:ThermalFoundation@[1.7.10R1.2.4,1.7.10R1.3.0);";
    public static final String modGuiFactory = "cofh.thermaldynamics.gui.GuiConfigTDFactory";
    public static final String version_group = "required-after:ThermalDynamics@[1.7.10R1.2.0,1.7.10R1.3.0);";
    public static final String releaseURL = "https://raw.github.com/CoFH/VERSION/master/ThermalDynamics";
    @Mod.Instance(value="ThermalDynamics")
    public static ThermalDynamics instance;
    @SidedProxy(clientSide="cofh.thermaldynamics.core.ProxyClient", serverSide="cofh.thermaldynamics.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final ConfigHandler configClient;
    public static final GuiHandler guiHandler;
    public static CreativeTabs tabCommon;
    public static CreativeTabs tabCovers;
    LinkedList<IInitializer> initializerList = new LinkedList();
    public static BlockDuct[] blockDuct;
    public static ItemServo itemServo;
    public static ItemFilter itemFilter;
    public static ItemCover itemCover;
    public static ItemRetriever itemRetriever;
    public static ItemRelay itemRelay;

    public ThermalDynamics() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this, releaseURL, "http://teamcofh.com/downloads/"));
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/thermaldynamics/common.cfg"), true));
        configClient.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/thermaldynamics/client.cfg"), true));
        tabCommon = new TDCreativeTab();
        RecipeSorter.register((String)"thermaldynamics:cover", RecipeCover.class, (RecipeSorter.Category)RecipeSorter.Category.UNKNOWN, (String)"after:forge:shapedore");
        this.configOptions();
        TDDucts.addDucts();
        int n = (int)Math.ceil((double)TDDucts.ductList.size() / 16.0);
        blockDuct = new BlockDuct[n];
        for (int i = 0; i < n; ++i) {
            ThermalDynamics.blockDuct[i] = this.addBlock(new BlockDuct(i));
        }
        itemServo = this.addItem(new ItemServo());
        itemFilter = this.addItem(new ItemFilter());
        itemCover = this.addItem(new ItemCover());
        itemRetriever = this.addItem(new ItemRetriever());
        itemRelay = this.addItem(new ItemRelay());
        for (IInitializer iInitializer : this.initializerList) {
            iInitializer.preInit();
        }
        TDPlugins.preInit();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent fMLInitializationEvent) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        for (IInitializer iInitializer : this.initializerList) {
            iInitializer.initialize();
        }
        FMLCommonHandler.instance().bus().register((Object)TickHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)TickHandler.instance);
        PacketDebug.initialize();
        DebugHelper.initialize();
        TDPlugins.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        for (IInitializer iInitializer : this.initializerList) {
            iInitializer.postInit();
        }
        TDCrafting.loadRecipes();
        proxy.registerRenderInformation();
        TDPlugins.postInit();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        TDPlugins.loadComplete();
        config.cleanUp(false, true);
        configClient.cleanUp(false, true);
        log.info("Thermal Dynamics: Load Complete.");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent fMLServerStartingEvent) {
        if (DebugHelper.debug) {
            fMLServerStartingEvent.registerServerCommand((ICommand)new CommandThermalDebug());
        }
    }

    void configOptions() {
        String string = "Duct.Transport";
        String string2 = "Must be between 0 and 120 ticks.";
        TileTransportDuctCrossover.CHARGE_TIME = (byte)MathHelper.clamp((int)config.get(string, "CrossoverChargeTime", (int)TileTransportDuctCrossover.CHARGE_TIME, string2), (int)0, (int)TileTransportDuctCrossover.CHARGE_TIME);
        string2 = "This value affects the size of the inner duct model, such as fluids. Lower it if you experience texture z-fighting.";
        TDProps.smallInnerModelScaling = MathHelper.clamp((float)((float)configClient.get("Render", "InnerModelScaling", 0.99, string2)), (float)0.5f, (float)0.99f);
        string2 = "This value affects the size of the inner duct model, such as fluids, on the large (octagonal) ducts. Lower it if you experience texture z-fighting.";
        TDProps.largeInnerModelScaling = MathHelper.clamp((float)((float)configClient.get("Render", "LargeInnerModelScaling", 0.99, string2)), (float)0.5f, (float)0.99f);
        if (ItemCover.enableCreativeTab = configClient.get("Interface.CreativeTab", "Covers.Enable", ItemCover.enableCreativeTab)) {
            tabCovers = new TDCreativeTabCovers();
        }
        ItemCover.showInNEI = configClient.get("Plugins.NEI", "Covers.Show", ItemCover.showInNEI, "Set to TRUE to show Covers in NEI.");
    }

    public <T extends Block> T addBlock(T t) {
        this.initializerList.add((IInitializer)t);
        return t;
    }

    public <T extends Item> T addItem(T t) {
        this.initializerList.add((IInitializer)t);
        return t;
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    @Mod.EventHandler
    public void checkMappings(FMLMissingMappingsEvent fMLMissingMappingsEvent) {
        for (FMLMissingMappingsEvent.MissingMapping missingMapping : fMLMissingMappingsEvent.get()) {
            if (!"ThermalDynamics:TestDuct".equals(missingMapping.name)) continue;
            if (missingMapping.type == GameRegistry.Type.BLOCK) {
                missingMapping.remap((Block)blockDuct[0]);
                continue;
            }
            missingMapping.remap(Item.func_150898_a((Block)blockDuct[0]));
        }
    }

    static {
        log = LogManager.getLogger((String)modId);
        config = new ConfigHandler(version);
        configClient = new ConfigHandler(version);
        guiHandler = new GuiHandler();
    }
}

