/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.position.BlockPosition;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;

public abstract class MFRLiquidMover {
    public static boolean manuallyFillTank(ITankContainerBucketable iTankContainerBucketable, EntityPlayer entityPlayer) {
        Item item;
        IFluidContainerItem iFluidContainerItem;
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        if (fluidStack != null) {
            Item item2 = itemStack.func_77973_b();
            if (iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, fluidStack, false) == fluidStack.amount) {
                iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, fluidStack, true);
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    if (item2.hasContainerItem(itemStack)) {
                        ItemStack itemStack2 = item2.getContainerItem(itemStack);
                        if (itemStack2 != null && itemStack2.func_77984_f() && itemStack2.func_77960_j() > itemStack2.func_77958_k()) {
                            itemStack2 = null;
                        }
                        MFRLiquidMover.disposePlayerItem(itemStack, itemStack2, entityPlayer, true);
                    } else {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, UtilInventory.consumeItem(itemStack, entityPlayer));
                    }
                    if (!entityPlayer.field_70170_p.field_72995_K) {
                        entityPlayer.field_71070_bA.func_75142_b();
                        ((EntityPlayerMP)entityPlayer).func_71110_a(entityPlayer.field_71070_bA, entityPlayer.field_71070_bA.func_75138_a());
                    }
                }
                return true;
            }
        } else if (itemStack != null && itemStack.func_77973_b() instanceof IFluidContainerItem && iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, fluidStack = (iFluidContainerItem = (IFluidContainerItem)(item = itemStack.func_77973_b())).getFluid(itemStack), false) > 0) {
            int n = iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, fluidStack, true);
            ItemStack itemStack3 = itemStack.func_77979_a(1);
            ++itemStack.field_77994_a;
            iFluidContainerItem.drain(itemStack3, n, true);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                if (item.hasContainerItem(itemStack3) && (itemStack3 = item.getContainerItem(itemStack3)) != null && itemStack3.func_77984_f() && itemStack3.func_77960_j() > itemStack3.func_77958_k()) {
                    itemStack3 = null;
                }
                MFRLiquidMover.disposePlayerItem(itemStack, itemStack3, entityPlayer, true);
                if (!entityPlayer.field_70170_p.field_72995_K) {
                    entityPlayer.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)entityPlayer).func_71110_a(entityPlayer.field_71070_bA, entityPlayer.field_71070_bA.func_75138_a());
                }
            }
            return true;
        }
        return false;
    }

    public static boolean manuallyDrainTank(ITankContainerBucketable iTankContainerBucketable, EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        boolean bl = false;
        if (itemStack != null && (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack) || (bl = itemStack.func_77973_b() instanceof IFluidContainerItem))) {
            for (FluidTankInfo fluidTankInfo : iTankContainerBucketable.getTankInfo(ForgeDirection.UNKNOWN)) {
                FluidStack fluidStack = fluidTankInfo.fluid;
                if (fluidStack == null || fluidStack.amount == 0) continue;
                ItemStack itemStack2 = null;
                FluidStack fluidStack2 = null;
                if (bl) {
                    IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)itemStack.func_77973_b();
                    itemStack2 = itemStack.func_77946_l();
                    itemStack2.field_77994_a = 1;
                    if (iFluidContainerItem.fill(itemStack2, fluidStack, false) > 0) {
                        int n = iFluidContainerItem.fill(itemStack2, fluidStack, true);
                        fluidStack2 = new FluidStack(fluidStack, n);
                        FluidStack fluidStack3 = iTankContainerBucketable.drain(ForgeDirection.UNKNOWN, fluidStack2, false);
                        if (fluidStack3 == null || fluidStack3.amount < n) {
                            itemStack2 = null;
                        }
                    } else {
                        itemStack2 = null;
                    }
                } else {
                    itemStack2 = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack);
                    if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack2)) {
                        fluidStack2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack2);
                        FluidStack fluidStack4 = iTankContainerBucketable.drain(ForgeDirection.UNKNOWN, fluidStack2, false);
                        if (fluidStack4 == null || fluidStack4.amount < fluidStack2.amount) {
                            itemStack2 = null;
                        }
                    } else {
                        itemStack2 = null;
                    }
                }
                if (itemStack2 == null || !MFRLiquidMover.disposePlayerItem(itemStack, itemStack2, entityPlayer, MFRConfig.dropFilledContainers.getBoolean(true))) continue;
                if (!entityPlayer.field_70170_p.field_72995_K) {
                    entityPlayer.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)entityPlayer).func_71110_a(entityPlayer.field_71070_bA, entityPlayer.field_71070_bA.func_75138_a());
                }
                iTankContainerBucketable.drain(ForgeDirection.UNKNOWN, fluidStack2, true);
                return true;
            }
        }
        return false;
    }

    public static boolean disposePlayerItem(ItemStack itemStack, ItemStack itemStack2, EntityPlayer entityPlayer, boolean bl) {
        return MFRLiquidMover.disposePlayerItem(itemStack, itemStack2, entityPlayer, bl, true);
    }

    public static boolean disposePlayerItem(ItemStack itemStack, ItemStack itemStack2, EntityPlayer entityPlayer, boolean bl, boolean bl2) {
        if (entityPlayer == null || entityPlayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (bl2 && itemStack.field_77994_a <= 1) {
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, itemStack2);
            return true;
        }
        if (bl) {
            --itemStack.field_77994_a;
            if (itemStack2 != null && !entityPlayer.field_71071_by.func_70441_a(itemStack2)) {
                entityPlayer.func_146097_a(itemStack2, false, true);
            }
            return true;
        }
        return false;
    }

    public static int fillTankWithXP(FluidTankAdv fluidTankAdv, EntityXPOrb entityXPOrb) {
        int n = fluidTankAdv.getSpace();
        int n2 = (int)((float)n / 66.666664f);
        if (n <= 0) {
            return 0;
        }
        int n3 = Math.min(entityXPOrb.field_70530_e, n2);
        entityXPOrb.field_70530_e -= n3;
        if (entityXPOrb.field_70530_e <= 0) {
            entityXPOrb.func_70106_y();
            n3 = Math.max(n3, 0);
        }
        if (n3 > 0) {
            n3 = (int)((float)n3 * 66.666664f);
            fluidTankAdv.fill(FluidRegistry.getFluidStack((String)"mobessence", (int)n3), true);
            return n3;
        }
        return 0;
    }

    public static void pumpLiquid(IFluidTank iFluidTank, TileEntityFactory tileEntityFactory) {
        if (iFluidTank != null && iFluidTank.getFluid() != null && iFluidTank.getFluid().amount > 0) {
            FluidStack fluidStack = iFluidTank.getFluid().copy();
            fluidStack.amount = Math.min(fluidStack.amount, 1000);
            for (BlockPosition blockPosition : new BlockPosition((TileEntity)tileEntityFactory).getAdjacent(true)) {
                TileEntity tileEntity = tileEntityFactory.func_145831_w().func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
                if (!(tileEntity instanceof IFluidHandler) || !((IFluidHandler)tileEntity).canFill(blockPosition.orientation.getOpposite(), fluidStack.getFluid())) continue;
                int n = ((IFluidHandler)tileEntity).fill(blockPosition.orientation.getOpposite(), fluidStack, true);
                iFluidTank.drain(n, true);
                fluidStack.amount -= n;
                if (fluidStack.amount > 0) continue;
                break;
            }
        }
    }
}

