/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.render;

import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.render.TickRotator;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public abstract class ItemRendererBase
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderBlocks = NullHelper.notnullM((RenderBlocks)data[0], "Game state error: Missing RenderBlock parameter");
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        this.setup(type, item, renderBlocks);
        this.render(item, renderBlocks);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    protected void setup(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GL11.glEnable((int)2884);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GL11.glEnable((int)2884);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (item.func_82839_y()) {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                if (this.shouldRotateInItemFrame()) {
                    TickRotator.getInstance().rotateGl(2.0);
                }
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
    }

    protected boolean shouldRotateInItemFrame() {
        return Config.rotationInItemframesEnabled.getBoolean();
    }

    protected abstract void render(ItemStack var1, RenderBlocks var2);
}

