/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.common.vecmath.Vector3d;
import info.loenwind.enderioaddons.render.CachableRenderStatement;
import info.loenwind.enderioaddons.render.RenderingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class CacheRenderer {
    private static final ForgeDirection[] AROUND = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    private static final double ROTATION_AMOUNT = 1.5707963267948966;
    private final List<CachableRenderStatement> csr = new ArrayList<CachableRenderStatement>();
    private BoundingBox bb = null;
    private final Vector3d[] verts = new Vector3d[8];
    private boolean doLighting = true;
    private VertexTransform xForm = null;
    private float[] brightnessPerSide = null;
    private float brightness_TL = 1.0f;
    private float brightness_TR = 1.0f;
    private float brightness_BL = 1.0f;
    private float brightness_BR = 1.0f;

    public CacheRenderer copy() {
        CacheRenderer o = new CacheRenderer();
        o.csr.clear();
        o.csr.addAll(this.csr);
        for (int i = 0; i < this.verts.length; ++i) {
            o.verts[i].set(this.verts[i].x, this.verts[i].y, this.verts[i].z);
        }
        o.doLighting = this.doLighting;
        o.xForm = this.xForm;
        o.brightnessPerSide = this.brightnessPerSide;
        o.brightness_TL = this.brightness_TL;
        o.brightness_TR = this.brightness_TR;
        o.brightness_BL = this.brightness_BL;
        o.brightness_BR = this.brightness_BR;
        return o;
    }

    public CacheRenderer() {
        this.csr.add(new CRS_start());
        for (int i = 0; i < this.verts.length; ++i) {
            this.verts[i] = new Vector3d();
        }
    }

    public CacheRenderer setBB(BoundingBox bb) {
        this.bb = bb;
        this.calculateVerts();
        return this;
    }

    private void calculateVerts() {
        this.verts[0].set((double)this.bb.minX, (double)this.bb.minY, (double)this.bb.minZ);
        this.verts[1].set((double)this.bb.maxX, (double)this.bb.minY, (double)this.bb.minZ);
        this.verts[2].set((double)this.bb.maxX, (double)this.bb.maxY, (double)this.bb.minZ);
        this.verts[3].set((double)this.bb.minX, (double)this.bb.maxY, (double)this.bb.minZ);
        this.verts[4].set((double)this.bb.minX, (double)this.bb.minY, (double)this.bb.maxZ);
        this.verts[5].set((double)this.bb.maxX, (double)this.bb.minY, (double)this.bb.maxZ);
        this.verts[6].set((double)this.bb.maxX, (double)this.bb.maxY, (double)this.bb.maxZ);
        this.verts[7].set((double)this.bb.minX, (double)this.bb.maxY, (double)this.bb.maxZ);
    }

    public CacheRenderer setXform(VertexTransform xForm) {
        this.calculateVerts();
        this.xForm = xForm;
        for (Vector3d vec : this.verts) {
            xForm.apply(vec);
        }
        return this;
    }

    public CacheRenderer setLighting(boolean doLighting) {
        this.doLighting = doLighting;
        return this;
    }

    public CacheRenderer setLighting(int mixedBrightness, float u, float v) {
        this.doLighting = false;
        this.csr.add(new CRS_Light(mixedBrightness, u, v));
        return this;
    }

    public List<CachableRenderStatement> finishDrawing() {
        this.csr.add(new CRS_end());
        return this.csr;
    }

    public CacheRenderer setBrightnessPerSide(float[] brightnessPerSide) {
        this.brightnessPerSide = brightnessPerSide;
        return this;
    }

    public CacheRenderer setBrightness(float brightness_TL, float brightness_TR, float brightness_BL, float brightness_BR) {
        this.brightness_TL = brightness_TL;
        this.brightness_TR = brightness_TR;
        this.brightness_BL = brightness_BL;
        this.brightness_BR = brightness_BR;
        return this;
    }

    public CacheRenderer setBrightness(float brightness_T, float brightness_B) {
        this.brightness_TL = brightness_T;
        this.brightness_TR = brightness_T;
        this.brightness_BL = brightness_B;
        this.brightness_BR = brightness_B;
        return this;
    }

    public CacheRenderer setBrightness(float brightness) {
        this.brightness_TL = brightness;
        this.brightness_TR = brightness;
        this.brightness_BL = brightness;
        this.brightness_BR = brightness;
        return this;
    }

    public void addSingleFace(ForgeDirection face, float minU, float maxU, float minV, float maxV, boolean inside) {
        byte color_BR;
        byte color_BL;
        byte color_TR;
        byte color_TL;
        ForgeDirection aa_normal = CacheRenderer.rotate(this.xForm, inside ? face.getOpposite() : face);
        if (this.doLighting) {
            this.csr.add(new CRS_Lightmap(aa_normal));
        }
        if (this.brightnessPerSide != null) {
            color_TL = (byte)(this.brightnessPerSide[aa_normal.ordinal()] * this.brightness_TL * 255.0f);
            color_TR = (byte)(this.brightnessPerSide[aa_normal.ordinal()] * this.brightness_TR * 255.0f);
            color_BL = (byte)(this.brightnessPerSide[aa_normal.ordinal()] * this.brightness_BL * 255.0f);
            color_BR = (byte)(this.brightnessPerSide[aa_normal.ordinal()] * this.brightness_BR * 255.0f);
        } else {
            color_TL = (byte)(this.brightness_TL * 255.0f);
            color_TR = (byte)(this.brightness_TR * 255.0f);
            color_BL = (byte)(this.brightness_BL * 255.0f);
            color_BR = (byte)(this.brightness_BR * 255.0f);
        }
        if (inside) {
            switch (face) {
                case NORTH: {
                    this.csr.add(new CRS_Normal(this.verts[0], this.verts[1], this.verts[2]));
                    this.csr.add(new CRS_Vertex(this.verts[0], maxU, maxV, this.verts[1].distance(this.verts[0]), color_BR));
                    this.csr.add(new CRS_Vertex(this.verts[1], minU, maxV, this.verts[1].distance(this.verts[0]), color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[2], minU, minV, this.verts[3].distance(this.verts[2]), color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[3], maxU, minV, this.verts[3].distance(this.verts[2]), color_TR));
                    break;
                }
                case SOUTH: {
                    this.csr.add(new CRS_Normal(this.verts[5], this.verts[4], this.verts[7]));
                    this.csr.add(new CRS_Vertex(this.verts[5], maxU, maxV, this.verts[4].distance(this.verts[5]), color_BR));
                    this.csr.add(new CRS_Vertex(this.verts[4], minU, maxV, this.verts[4].distance(this.verts[5]), color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[7], minU, minV, this.verts[6].distance(this.verts[7]), color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[6], maxU, minV, this.verts[6].distance(this.verts[7]), color_TR));
                    break;
                }
                case UP: {
                    this.csr.add(new CRS_Normal(this.verts[2], this.verts[6], this.verts[7]));
                    this.csr.add(new CRS_Vertex(this.verts[2], maxU, minV, 1.0, color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[6], maxU, maxV, 1.0, color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[7], minU, maxV, 1.0, color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[3], minU, minV, 1.0, color_TL));
                    break;
                }
                case DOWN: {
                    this.csr.add(new CRS_Normal(this.verts[1], this.verts[0], this.verts[4]));
                    this.csr.add(new CRS_Vertex(this.verts[1], maxU, minV, 1.0, color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[0], minU, minV, 1.0, color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[4], minU, maxV, 1.0, color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[5], maxU, maxV, 1.0, color_BL));
                    break;
                }
                case EAST: {
                    this.csr.add(new CRS_Normal(this.verts[1], this.verts[5], this.verts[6]));
                    this.csr.add(new CRS_Vertex(this.verts[1], maxU, maxV, this.verts[5].distance(this.verts[1]), color_BR));
                    this.csr.add(new CRS_Vertex(this.verts[5], minU, maxV, this.verts[5].distance(this.verts[1]), color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[6], minU, minV, this.verts[2].distance(this.verts[6]), color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[2], maxU, minV, this.verts[2].distance(this.verts[6]), color_TR));
                    break;
                }
                case WEST: {
                    this.csr.add(new CRS_Normal(this.verts[4], this.verts[0], this.verts[3]));
                    this.csr.add(new CRS_Vertex(this.verts[4], maxU, maxV, this.verts[0].distance(this.verts[4]), color_BR));
                    this.csr.add(new CRS_Vertex(this.verts[0], minU, maxV, this.verts[0].distance(this.verts[4]), color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[3], minU, minV, this.verts[7].distance(this.verts[3]), color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[7], maxU, minV, this.verts[7].distance(this.verts[3]), color_TR));
                    break;
                }
            }
        } else {
            switch (face) {
                case NORTH: {
                    this.csr.add(new CRS_Normal(this.verts[1], this.verts[0], this.verts[3]));
                    this.csr.add(new CRS_Vertex(this.verts[1], minU, maxV, this.verts[1].distance(this.verts[0]), color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[0], maxU, maxV, this.verts[1].distance(this.verts[0]), color_BR));
                    this.csr.add(new CRS_Vertex(this.verts[3], maxU, minV, this.verts[3].distance(this.verts[2]), color_TR));
                    this.csr.add(new CRS_Vertex(this.verts[2], minU, minV, this.verts[3].distance(this.verts[2]), color_TL));
                    break;
                }
                case SOUTH: {
                    this.csr.add(new CRS_Normal(this.verts[4], this.verts[5], this.verts[6]));
                    this.csr.add(new CRS_Vertex(this.verts[4], minU, maxV, this.verts[4].distance(this.verts[5]), color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[5], maxU, maxV, this.verts[4].distance(this.verts[5]), color_BR));
                    this.csr.add(new CRS_Vertex(this.verts[6], maxU, minV, this.verts[6].distance(this.verts[7]), color_TR));
                    this.csr.add(new CRS_Vertex(this.verts[7], minU, minV, this.verts[6].distance(this.verts[7]), color_TL));
                    break;
                }
                case UP: {
                    this.csr.add(new CRS_Normal(this.verts[6], this.verts[2], this.verts[3]));
                    this.csr.add(new CRS_Vertex(this.verts[6], maxU, maxV, 1.0, color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[2], maxU, minV, 1.0, color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[3], minU, minV, 1.0, color_TL));
                    this.csr.add(new CRS_Vertex(this.verts[7], minU, maxV, 1.0, color_TL));
                    break;
                }
                case DOWN: {
                    this.csr.add(new CRS_Normal(this.verts[0], this.verts[1], this.verts[5]));
                    this.csr.add(new CRS_Vertex(this.verts[0], minU, minV, 1.0, color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[1], maxU, minV, 1.0, color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[5], maxU, maxV, 1.0, color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[4], minU, maxV, 1.0, color_BL));
                    break;
                }
                case EAST: {
                    this.csr.add(new CRS_Normal(this.verts[5], this.verts[1], this.verts[2]));
                    this.csr.add(new CRS_Vertex(this.verts[5], minU, maxV, this.verts[5].distance(this.verts[1]), color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[1], maxU, maxV, this.verts[5].distance(this.verts[1]), color_BR));
                    this.csr.add(new CRS_Vertex(this.verts[2], maxU, minV, this.verts[2].distance(this.verts[6]), color_TR));
                    this.csr.add(new CRS_Vertex(this.verts[6], minU, minV, this.verts[2].distance(this.verts[6]), color_TL));
                    break;
                }
                case WEST: {
                    this.csr.add(new CRS_Normal(this.verts[0], this.verts[4], this.verts[7]));
                    this.csr.add(new CRS_Vertex(this.verts[0], minU, maxV, this.verts[0].distance(this.verts[4]), color_BL));
                    this.csr.add(new CRS_Vertex(this.verts[4], maxU, maxV, this.verts[0].distance(this.verts[4]), color_BR));
                    this.csr.add(new CRS_Vertex(this.verts[7], maxU, minV, this.verts[7].distance(this.verts[3]), color_TR));
                    this.csr.add(new CRS_Vertex(this.verts[3], minU, minV, this.verts[7].distance(this.verts[3]), color_TL));
                    break;
                }
            }
        }
    }

    public CacheRenderer addSide(ForgeDirection face, IIcon[] icons, boolean inside) {
        IIcon tex = icons[face.ordinal()];
        if (tex != null) {
            float minU = tex.func_94209_e();
            float maxU = tex.func_94212_f();
            float minV = tex.func_94206_g();
            float maxV = tex.func_94210_h();
            this.addSingleFace(face, minU, maxU, minV, maxV, inside);
        }
        return this;
    }

    public CacheRenderer addSide(ForgeDirection face, IIcon tex, boolean inside) {
        if (tex != null) {
            float minU = tex.func_94209_e();
            float maxU = tex.func_94212_f();
            float minV = tex.func_94206_g();
            float maxV = tex.func_94210_h();
            this.addSingleFace(face, minU, maxU, minV, maxV, inside);
        }
        return this;
    }

    public void addSkirt(IIcon[] icons, boolean inside) {
        this.addSides(AROUND, icons, inside);
    }

    public void addSkirt(IIcon tex, boolean inside) {
        this.addSides(AROUND, tex, inside);
    }

    public void addAllSides(IIcon[] icons, boolean inside) {
        this.addSides(ForgeDirection.VALID_DIRECTIONS, icons, inside);
    }

    public void addAllSides(IIcon tex, boolean inside) {
        this.addSides(ForgeDirection.VALID_DIRECTIONS, tex, inside);
    }

    public void addSides(ForgeDirection[] sides, IIcon[] icons, boolean inside) {
        for (ForgeDirection face : sides) {
            IIcon tex = icons[face.ordinal()];
            if (tex == null) continue;
            float minU = tex.func_94209_e();
            float maxU = tex.func_94212_f();
            float minV = tex.func_94206_g();
            float maxV = tex.func_94210_h();
            this.addSingleFace(face, minU, maxU, minV, maxV, inside);
        }
    }

    public void addSides(ForgeDirection[] sides, IIcon tex, boolean inside) {
        if (tex != null) {
            for (ForgeDirection face : sides) {
                float minU = tex.func_94209_e();
                float maxU = tex.func_94212_f();
                float minV = tex.func_94206_g();
                float maxV = tex.func_94210_h();
                this.addSingleFace(face, minU, maxU, minV, maxV, inside);
            }
        }
    }

    public static ForgeDirection rotate(VertexTransform xForm, ForgeDirection dir) {
        if (xForm instanceof VertexRotationFacing) {
            double angle = ((VertexRotationFacing)xForm).getAngle();
            if (angle < 0.7853981633974483 || angle >= 5.497787143782138) {
                return dir;
            }
            if (angle >= 0.7853981633974483 && angle < 2.356194490192345) {
                return dir.getRotation(ForgeDirection.DOWN);
            }
            if (angle >= 2.356194490192345 && angle < 3.9269908169872414) {
                return dir.getOpposite();
            }
            if (angle >= 3.9269908169872414 && angle < 5.497787143782138) {
                return dir.getRotation(ForgeDirection.UP);
            }
        }
        return dir;
    }

    public String toString() {
        return "CacheRenderer [brightnessPerSide=" + Arrays.toString(this.brightnessPerSide) + ", brightness_TL=" + this.brightness_TL + ", brightness_TR=" + this.brightness_TR + ", brightness_BL=" + this.brightness_BL + ", brightness_BR=" + this.brightness_BR + ", csr=" + this.csr + "]";
    }

    private static class CRS_Vertex
    implements CachableRenderStatement {
        private final double u;
        private final double v;
        private final double w;
        private final double x;
        private final double y;
        private final double z;
        private final byte color;

        public CRS_Vertex(Vector3d vec, float u, float v, double w, byte color) {
            this.u = (double)u * w;
            this.v = (double)v * w;
            this.w = w;
            this.x = vec.x;
            this.y = vec.y;
            this.z = vec.z;
            this.color = color;
        }

        @Override
        public void execute(RenderingContext renderingContext) {
            GL11.glColor4ub((byte)this.color, (byte)this.color, (byte)this.color, (byte)-1);
            GL11.glTexCoord4d((double)this.u, (double)this.v, (double)0.0, (double)this.w);
            GL11.glVertex3d((double)(this.x + renderingContext.xOffset), (double)(this.y + renderingContext.yOffset), (double)(this.z + renderingContext.zOffset));
        }

        @Override
        public void execute_tesselated(RenderingContext renderingContext) {
            Tessellator.field_78398_a.func_154352_a(this.color, this.color, this.color);
            Tessellator.field_78398_a.func_78374_a(this.x, this.y, this.z, this.u / this.w, this.v / this.w);
        }

        public String toString() {
            return "CRS_Vertex [u=" + this.u + ", v=" + this.v + ", w=" + this.w + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", color=" + (this.color & 0xFF) + "]";
        }
    }

    private static class CRS_Normal
    implements CachableRenderStatement {
        private final double x;
        private final double y;
        private final double z;
        private static final Vector3d T1 = new Vector3d();
        private static final Vector3d T2 = new Vector3d();
        private static final Vector3d T3 = new Vector3d();

        public CRS_Normal(Vector3d A, Vector3d B, Vector3d C) {
            T1.set(B);
            T1.sub(A);
            T2.set(C);
            T2.sub(A);
            T3.cross(T1, T2);
            T3.normalize();
            this.x = CRS_Normal.T3.x;
            this.y = CRS_Normal.T3.y;
            this.z = CRS_Normal.T3.z;
        }

        @Override
        public void execute(RenderingContext renderingContext) {
            GL11.glNormal3d((double)this.x, (double)this.y, (double)this.z);
        }

        @Override
        public void execute_tesselated(RenderingContext renderingContext) {
            Tessellator.field_78398_a.func_78375_b((float)this.x, (float)this.y, (float)this.z);
        }

        public String toString() {
            return "CRS_Normal [normal=" + this.x + "/" + this.y + "/" + this.z + "]";
        }
    }

    private static class CRS_Light
    implements CachableRenderStatement {
        private final int mixedBrightness;
        private final float u;
        private final float v;

        public CRS_Light(int mixedBrightness, float u, float v) {
            this.mixedBrightness = mixedBrightness;
            this.u = u;
            this.v = v;
        }

        @Override
        public void execute(RenderingContext renderingContext) {
            if (renderingContext.hasLight) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.u, (float)this.v);
            }
        }

        @Override
        public void execute_tesselated(RenderingContext renderingContext) {
            if (renderingContext.hasLight) {
                Tessellator.field_78398_a.func_78380_c(this.mixedBrightness);
            }
        }

        public String toString() {
            return "CRS_Light [mixedBrightness=" + this.mixedBrightness + ", u=" + this.u + ", v=" + this.v + "]";
        }
    }

    private static class CRS_Lightmap
    implements CachableRenderStatement {
        private final int normal;

        public CRS_Lightmap(ForgeDirection normal) {
            this.normal = normal.ordinal();
        }

        @Override
        public void execute(RenderingContext renderingContext) {
            if (renderingContext.hasLight) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)renderingContext.blockLight[this.normal], (float)renderingContext.skyLight[this.normal]);
            }
        }

        @Override
        public void execute_tesselated(RenderingContext renderingContext) {
            if (renderingContext.hasLight) {
                Tessellator.field_78398_a.func_78380_c(renderingContext.mixedLight[this.normal]);
            }
        }

        public String toString() {
            return "CRS_Lightmap [normal=" + ForgeDirection.values()[this.normal] + "]";
        }
    }

    private static class CRS_end
    implements CachableRenderStatement {
        private CRS_end() {
        }

        @Override
        public void execute(RenderingContext renderingContext) {
            GL11.glEnd();
            if (Minecraft.func_71379_u()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
            GL11.glPopAttrib();
        }

        @Override
        public void execute_tesselated(RenderingContext renderingContext) {
        }

        public String toString() {
            return "CRS_end []";
        }
    }

    private static class CRS_start
    implements CachableRenderStatement {
        private CRS_start() {
        }

        @Override
        public void execute(RenderingContext renderingContext) {
            GL11.glPushAttrib((int)1048575);
            GL11.glShadeModel((int)7425);
            GL11.glBegin((int)7);
        }

        @Override
        public void execute_tesselated(RenderingContext renderingContext) {
        }

        public String toString() {
            return "CRS_start []";
        }
    }
}

