/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.network;

import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import info.loenwind.enderioaddons.network.INetworkUpdatable;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketNetworkUpdate
extends MessageTileEntity<TileEntity> {
    private int[] data;

    public PacketNetworkUpdate() {
    }

    public PacketNetworkUpdate(@Nonnull TileEntity tile, int ... data) {
        super(tile);
        this.data = data;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.data.length);
        for (int i : this.data) {
            buf.writeInt(i);
        }
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int len = buf.readByte();
        this.data = new int[len];
        for (int i = 0; i < len; ++i) {
            this.data[i] = buf.readInt();
        }
    }

    public static class HandleNetworkUpdateServer
    implements IMessageHandler<PacketNetworkUpdate, IMessage> {
        public IMessage onMessage(PacketNetworkUpdate message, MessageContext ctx) {
            TileEntity tile;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player != null && (tile = message.getTileEntity(player.field_70170_p)) instanceof INetworkUpdatable) {
                INetworkUpdatable te = (INetworkUpdatable)tile;
                for (int i = 0; i < message.data.length; ++i) {
                    te.networkUpdate(i, message.data[i]);
                }
            }
            return null;
        }
    }

    public static class HandleNetworkUpdateClient
    implements IMessageHandler<PacketNetworkUpdate, IMessage> {
        public IMessage onMessage(PacketNetworkUpdate message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            TileEntity tile = message.getTileEntity(player.field_70170_p);
            if (tile instanceof INetworkUpdatable) {
                INetworkUpdatable te = (INetworkUpdatable)tile;
                for (int i = 0; i < message.data.length; ++i) {
                    te.networkUpdate(i, message.data[i]);
                }
            }
            return null;
        }
    }
}

