/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.network.PacketHandler;
import info.loenwind.enderioaddons.common.InitAware;
import info.loenwind.enderioaddons.network.INetworkUpdatable;
import info.loenwind.enderioaddons.network.PacketNetworkUpdate;
import info.loenwind.enderioaddons.network.PacketParticles;
import info.loenwind.enderioaddons.network.PacketSlotVisibility;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;

public class Manager
implements InitAware {
    private Map<INetworkUpdatable, Integer> networkUpdatables = new WeakHashMap<INetworkUpdatable, Integer>();
    private Map<INetworkUpdatable, int[]> networkUpdatableData = new WeakHashMap<INetworkUpdatable, int[]>();

    @Override
    public void init(FMLPreInitializationEvent event) {
        PacketHandler.INSTANCE.registerMessage(PacketParticles.class, PacketParticles.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketSlotVisibility.class, PacketSlotVisibility.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkUpdate.HandleNetworkUpdateClient.class, PacketNetworkUpdate.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkUpdate.HandleNetworkUpdateServer.class, PacketNetworkUpdate.class, PacketHandler.nextID(), Side.SERVER);
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void init(FMLPostInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void register(INetworkUpdatable te) {
        if (!((TileEntity)te).func_145831_w().field_72995_K) {
            this.networkUpdatables.put(te, te.getNetworkUpdateCheckInterval());
            this.networkUpdatableData.put(te, new int[te.getNetworkUpdateCount()]);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            for (Map.Entry<INetworkUpdatable, Integer> entry : this.networkUpdatables.entrySet()) {
                INetworkUpdatable te = entry.getKey();
                if (te == null) continue;
                int i = entry.getValue();
                if (i-- <= 0) {
                    int[] data = this.networkUpdatableData.get(te);
                    boolean needUpdate = false;
                    for (int j = 0; j < data.length; ++j) {
                        int value = te.getNetworkUpdate(j);
                        if (value == data[j]) continue;
                        data[j] = value;
                        needUpdate = true;
                    }
                    if (needUpdate) {
                        PacketHandler.sendToAllAround((IMessage)new PacketNetworkUpdate((TileEntity)te, data), (TileEntity)((TileEntity)te));
                    }
                    entry.setValue(te.getNetworkUpdateCheckInterval());
                    continue;
                }
                entry.setValue(i);
            }
        }
    }

    public static void sendUpdateToServer(INetworkUpdatable te, int ... data) {
        if (te instanceof TileEntity) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkUpdate((TileEntity)te, data));
        }
    }
}

