/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.voidtank;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.baseclass.TileEnderIOAddons;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.voidtank.BlockVoidTank;
import info.loenwind.enderioaddons.machine.voidtank.PacketVoidTank;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

@Storable
public class TileVoidTank
extends TileEnderIOAddons
implements IFluidHandler,
ITankAccess {
    private static final int ONE_BLOCK_OF_LIQUID = 1000;
    private static int IO_MB_TICK = 100;
    @Nonnull
    @Store
    protected SmartTank tank = new SmartTank(10666);
    @Store
    protected boolean isBroken = false;
    protected int lastUpdateLevel = -1;
    protected boolean tankDirty = false;

    public TileVoidTank() {
        super(new SlotDefinition(1, 1, 1));
    }

    protected boolean doPush(@Nullable ForgeDirection dir) {
        return false;
    }

    protected boolean doPull(ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPull(dir);
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null) {
            if (this.tank.getFluidAmount() > 0) {
                FluidStack canPull = this.tank.getFluid().copy();
                canPull.amount = this.tank.getCapacity() - this.tank.getFluidAmount();
                canPull.amount = Math.min(canPull.amount, IO_MB_TICK);
                FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                if (drained != null && drained.amount > 0) {
                    this.tank.fill(drained, true);
                    this.tankDirty = true;
                    return res;
                }
            } else {
                FluidTankInfo[] infos = target.getTankInfo(dir.getOpposite());
                if (infos != null) {
                    for (FluidTankInfo info : infos) {
                        if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                        FluidStack canPull = info.fluid.copy();
                        canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                        FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                        if (drained == null || drained.amount <= 0) continue;
                        this.tank.fill(drained, true);
                        this.tankDirty = true;
                        return res;
                    }
                }
            }
        }
        return res;
    }

    public int fill(@Nullable ForgeDirection from, @Nullable FluidStack resource, boolean doFill) {
        if (!this.canFill(from) || resource == null || !this.isValidFluid(resource)) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    protected boolean canFill(ForgeDirection from) {
        IoMode mode = this.getIoMode(from);
        return mode != IoMode.PUSH && mode != IoMode.DISABLED;
    }

    protected int fillInternal(@Nonnull FluidStack resource, boolean doFill) {
        int res = this.tank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(@Nullable ForgeDirection from, @Nullable FluidStack resource, boolean doDrain) {
        return null;
    }

    protected FluidStack drainInternal(@Nonnull FluidStack resource, boolean doDrain) {
        FluidStack res = this.tank.drain(resource, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(@Nullable ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    protected FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack res = this.tank.drain(maxDrain, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public boolean canFill(@Nullable ForgeDirection from, @Nullable Fluid fluid) {
        return this.canFill(from) && fluid != null && (this.tank.getFluidAmount() > 0 && this.tank.getFluid().getFluidID() == fluid.getID() || this.tank.getFluidAmount() == 0) && this.isValidFluid(fluid);
    }

    public boolean canDrain(@Nullable ForgeDirection from, @Nullable Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(@Nullable ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    protected int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.tank.getFilledRatio());
        if (level == 0 && this.tank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    public String getMachineName() {
        return BlockVoidTank.ModObject_blockVoidTank.unlocalisedName;
    }

    protected boolean isMachineItemValidForSlot(int i, @Nullable ItemStack item) {
        if (i == 0 && item != null) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            if (fluid != null) {
                return this.isValidFluid(fluid);
            }
            if (item.func_77973_b() == Items.field_151131_as) {
                return true;
            }
            if (item.func_77973_b() == Items.field_151129_at) {
                return true;
            }
            if (item.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)item.func_77973_b()).getFluid(item) != null) {
                return this.isValidFluid(((IFluidContainerItem)item.func_77973_b()).getFluid(item));
            }
            return false;
        }
        return false;
    }

    protected boolean isValidFluid(Fluid fluid) {
        return true;
    }

    protected boolean isValidFluid(FluidStack fluid) {
        return true;
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        return this.doTick(redstoneChecksPassed);
    }

    protected boolean doTick(boolean redstoneChecksPassed) {
        if (redstoneChecksPassed && this.shouldDoWorkThisTick(20)) {
            this.drainFullContainer();
        }
        if (this.isBroken) {
            this.usePower();
        }
        if (this.tank.getFluidAmount() > 0) {
            int drainPerTick = 10;
            switch (this.getCapacitorType()) {
                case BASIC_CAPACITOR: {
                    drainPerTick = 5;
                    break;
                }
                case ACTIVATED_CAPACITOR: {
                    drainPerTick = 10;
                    break;
                }
                case ENDER_CAPACITOR: {
                    drainPerTick = 50;
                }
            }
            int amount = this.tank.getFluidAmount() - this.func_145831_w().field_73012_v.nextInt(drainPerTick * 2);
            if (amount < 0) {
                amount = 0;
            }
            this.tank.setFluidAmount(amount);
            if (!this.isBroken) {
                this.isBroken = true;
                this.func_145831_w().func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 1.0f, true);
                return true;
            }
        }
        if (this.shouldDoWorkThisTick(10) && (this.tankDirty || this.lastUpdateLevel != this.tank.getFluidAmount())) {
            PacketHandler.sendToAllAround((IMessage)new PacketVoidTank(this), (TileEntity)this);
            this.lastUpdateLevel = this.tank.getFluidAmount();
            this.tankDirty = false;
        }
        return false;
    }

    private boolean drainFullContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)this.inventory[this.getSlotDefinition().getMinInputSlot()], (ITankAccess)this);
        if (fill.result.fluidStack == null) {
            return false;
        }
        int slot = this.getSlotDefinition().getMinOutputSlot();
        if (this.inventory[slot] != null && fill.result.itemStack != null) {
            if (this.inventory[slot].func_77985_e() && ItemUtil.areStackMergable((ItemStack)this.inventory[slot], (ItemStack)fill.result.itemStack) && this.inventory[slot].field_77994_a < this.inventory[slot].func_77976_d()) {
                fill.result.itemStack.field_77994_a += this.inventory[slot].field_77994_a;
            } else {
                return false;
            }
        }
        this.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        this.func_70299_a(this.getSlotDefinition().getMinInputSlot(), fill.remainder.itemStack);
        if (fill.result.itemStack != null) {
            this.func_70299_a(slot, fill.result.itemStack);
        }
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    protected IPoweredTask createTask(NBTTagCompound taskTagCompound) {
        return new ContinuousTask((float)this.getPowerUsePerTick());
    }

    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return this.createTask(null);
    }

    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.voidTankContinuousEnergyUseRF1.getInt() * 10, 100000, Config.voidTankContinuousEnergyUseRF1.getInt()));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.voidTankContinuousEnergyUseRF2.getInt() * 5, 500000, Config.voidTankContinuousEnergyUseRF2.getInt()));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.voidTankContinuousEnergyUseRF3.getInt() * 2, 1000000, Config.voidTankContinuousEnergyUseRF3.getInt()));
            }
        }
        this.currentTask = this.createTask(null);
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.isValidFluid(forFluidType) ? this.tank : null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tankDirty = true;
    }

    public boolean isBroken() {
        return this.isBroken;
    }
}

