/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.tcom.engine;

import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.machine.tcom.engine.Item2Mats;
import info.loenwind.enderioaddons.machine.tcom.engine.LinearRandom;
import info.loenwind.enderioaddons.machine.tcom.engine.Mats;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Storable
public class EngineTcom {
    private static final Random rand = new Random();
    @Store(value={Store.StoreFor.ITEM, Store.StoreFor.SAVE})
    private final float[] enchantmentPool = new float[Enchantment.field_77331_b.length];
    @Store
    private final float[] materialPool = new float[Mats.values().length];
    @Store
    private float enchantmentAmount = 0.0f;
    private final float minloss;
    private final float randloss;

    public EngineTcom(float minloss, float randloss) {
        this.minloss = minloss;
        this.randloss = randloss;
    }

    public boolean addable(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return false;
        }
        return Item2Mats.isValid(itemStack);
    }

    public boolean add(ItemStack itemStack) {
        List<Mats> mats = Item2Mats.getMats(itemStack);
        int itemDamage = itemStack.func_77960_j();
        int maxDamage = itemStack.func_77958_k();
        int stackSize = itemStack.field_77994_a;
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        float factor = 0.0f;
        for (int i = 0; i < stackSize; ++i) {
            factor += (float)(maxDamage - itemDamage) / (float)maxDamage * (1.0f - this.minloss - (float)rand.nextDouble() * this.randloss);
        }
        for (Mats mats2 : mats) {
            int n = mats2.ordinal();
            this.materialPool[n] = this.materialPool[n] + 1.0f * factor;
        }
        for (Map.Entry entry : enchantments.entrySet()) {
            int n = (Integer)entry.getKey();
            this.enchantmentPool[n] = this.enchantmentPool[n] + (float)((Integer)entry.getValue()).intValue() * factor;
        }
        this.computeHasEnchantments();
        return true;
    }

    public Map<Enchantment, Float> getEnchantments() {
        HashMap<Enchantment, Float> result = new HashMap<Enchantment, Float>();
        for (int i = 0; i < this.enchantmentPool.length; ++i) {
            if (!(this.enchantmentPool[i] > 0.01f)) continue;
            result.put(Enchantment.field_77331_b[i], Float.valueOf(this.enchantmentPool[i]));
        }
        return result;
    }

    public Map<ItemStack, Float> getMaterials() {
        HashMap<ItemStack, Float> result = new HashMap<ItemStack, Float>();
        for (int i = 0; i < this.materialPool.length; ++i) {
            if (!(this.materialPool[i] > 0.01f)) continue;
            result.put(Mats.values()[i].getItemStack(), Float.valueOf(this.materialPool[i]));
        }
        return result;
    }

    public float getAmount(Mats mat) {
        return this.materialPool[mat.ordinal()];
    }

    public boolean canGet(Mats mat) {
        return this.materialPool[mat.ordinal()] >= 1.0f;
    }

    public boolean get(Mats mat) {
        if (this.materialPool[mat.ordinal()] >= 1.0f) {
            int n = mat.ordinal();
            this.materialPool[n] = this.materialPool[n] - 1.0f;
            return true;
        }
        return false;
    }

    private EnchantmentData getEnchantmentData(int id, int enchantmentPower) {
        Enchantment enchantment = Enchantment.field_77331_b[id];
        int maxLevel = (int)((float)enchantment.func_77325_b() < this.enchantmentPool[id] ? (float)enchantment.func_77325_b() : this.enchantmentPool[id]);
        int level = 1;
        for (int i = 0; i <= enchantmentPower / 8 && maxLevel > level; ++i) {
            int tmp = LinearRandom.getValue(maxLevel, rand);
            if (tmp <= level) continue;
            level = tmp;
        }
        int n = id;
        this.enchantmentPool[n] = this.enchantmentPool[n] - (float)level;
        return new EnchantmentData(enchantment, level);
    }

    public boolean isValidTarget(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null || itemStack.func_77973_b() == Items.field_151134_bR) {
            return false;
        }
        Map enchantmentsOnItemStack = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (int id = 0; id < this.enchantmentPool.length; ++id) {
            if (!(this.enchantmentPool[id] >= 1.0f)) continue;
            Enchantment enchantmentInPool = Enchantment.field_77331_b[id];
            if (itemStack.func_77973_b() == Items.field_151122_aG) {
                if (!enchantmentInPool.isAllowedOnBooks()) continue;
                return true;
            }
            if (!enchantmentInPool.func_92089_a(itemStack)) continue;
            if (enchantmentsOnItemStack.isEmpty()) {
                return true;
            }
            boolean canApply = true;
            for (Integer id2 : enchantmentsOnItemStack.keySet()) {
                Enchantment enchantmentOnItemStack = Enchantment.field_77331_b[id2];
                if (enchantmentInPool.func_77326_a(enchantmentOnItemStack) && enchantmentOnItemStack.func_77326_a(enchantmentInPool)) continue;
                canApply = false;
                break;
            }
            if (!canApply) continue;
            return true;
        }
        return false;
    }

    public Map<Enchantment, Float> getEnchantments(ItemStack itemStack) {
        if (itemStack == null) {
            return this.getEnchantments();
        }
        if (itemStack.func_77973_b() == null || itemStack.func_77973_b() == Items.field_151134_bR) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Enchantment, Float> result = new HashMap<Enchantment, Float>();
        Map enchantmentsOnItemStack = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (int id = 0; id < this.enchantmentPool.length; ++id) {
            if (!(this.enchantmentPool[id] >= 1.0f)) continue;
            Enchantment enchantmentInPool = Enchantment.field_77331_b[id];
            if (itemStack.func_77973_b() == Items.field_151122_aG) {
                if (!enchantmentInPool.isAllowedOnBooks()) continue;
                result.put(enchantmentInPool, Float.valueOf(this.enchantmentPool[id]));
                continue;
            }
            if (!enchantmentInPool.func_92089_a(itemStack)) continue;
            if (enchantmentsOnItemStack.isEmpty()) {
                result.put(enchantmentInPool, Float.valueOf(this.enchantmentPool[id]));
                continue;
            }
            boolean canApply = true;
            for (Integer id2 : enchantmentsOnItemStack.keySet()) {
                Enchantment enchantmentOnItemStack = Enchantment.field_77331_b[id2];
                if (enchantmentInPool.func_77326_a(enchantmentOnItemStack) && enchantmentOnItemStack.func_77326_a(enchantmentInPool)) continue;
                canApply = false;
                break;
            }
            if (!canApply) continue;
            result.put(enchantmentInPool, Float.valueOf(this.enchantmentPool[id]));
        }
        return result;
    }

    public float getEnchantmentAmounts() {
        return this.enchantmentAmount;
    }

    private void computeHasEnchantments() {
        this.enchantmentAmount = 0.0f;
        for (int id = 0; id < this.enchantmentPool.length; ++id) {
            this.enchantmentAmount += this.enchantmentPool[id];
        }
    }

    public boolean addEnchantment(ItemStack itemStack, int id, int enchantmentPower) {
        Enchantment enchantmentInPool = Enchantment.field_77331_b[id];
        if (itemStack == null || itemStack.func_77973_b() == null || itemStack.func_77973_b() == Items.field_151134_bR || itemStack.field_77994_a != 1 || enchantmentInPool == null || this.enchantmentPool[id] < 1.0f) {
            return false;
        }
        if (itemStack.func_77973_b() == Items.field_151122_aG) {
            if (!enchantmentInPool.isAllowedOnBooks()) {
                return false;
            }
            EnchantmentData enchantmentData = this.getEnchantmentData(id, enchantmentPower);
            itemStack.func_150996_a((Item)Items.field_151134_bR);
            Items.field_151134_bR.func_92115_a(itemStack, enchantmentData);
            this.computeHasEnchantments();
            return true;
        }
        if (!enchantmentInPool.func_92089_a(itemStack)) {
            return false;
        }
        Map enchantmentsOnItemStack = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Integer id2 : enchantmentsOnItemStack.keySet()) {
            Enchantment enchantmentOnItemStack = Enchantment.field_77331_b[id2];
            if (enchantmentInPool.func_77326_a(enchantmentOnItemStack) && enchantmentOnItemStack.func_77326_a(enchantmentInPool)) continue;
            return false;
        }
        EnchantmentData enchantmentData = this.getEnchantmentData(id, enchantmentPower);
        itemStack.func_77966_a(enchantmentData.field_76302_b, enchantmentData.field_76303_c);
        this.computeHasEnchantments();
        return true;
    }

    public boolean canAddEnchantment(ItemStack itemStack, int id) {
        Enchantment enchantmentInPool = Enchantment.field_77331_b[id];
        if (itemStack == null || itemStack.func_77973_b() == null || itemStack.func_77973_b() == Items.field_151134_bR || enchantmentInPool == null || this.enchantmentPool[id] < 1.0f) {
            return false;
        }
        if (itemStack.func_77973_b() == Items.field_151122_aG) {
            return enchantmentInPool.isAllowedOnBooks();
        }
        if (!enchantmentInPool.func_92089_a(itemStack)) {
            return false;
        }
        Map enchantmentsOnItemStack = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Integer id2 : enchantmentsOnItemStack.keySet()) {
            Enchantment enchantmentOnItemStack = Enchantment.field_77331_b[id2];
            if (enchantmentInPool.func_77326_a(enchantmentOnItemStack) && enchantmentOnItemStack.func_77326_a(enchantmentInPool)) continue;
            return false;
        }
        return true;
    }
}

