/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.tcom;

import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import info.loenwind.enderioaddons.machine.tcom.TileTcom;
import info.loenwind.enderioaddons.machine.tcom.engine.Mats;
import io.netty.buffer.ByteBuf;
import java.security.InvalidParameterException;
import net.minecraft.tileentity.TileEntity;

public class PacketTcomAction
extends MessageTileEntity<TileTcom>
implements IMessageHandler<PacketTcomAction, IMessage> {
    private Mats mat = null;
    private int enchant = -1;

    public PacketTcomAction() {
    }

    public PacketTcomAction(TileTcom tile) {
        super((TileEntity)tile);
    }

    public PacketTcomAction(TileTcom tile, Mats mat) {
        super((TileEntity)tile);
        this.mat = mat;
    }

    public PacketTcomAction(TileTcom tile, int enchant) {
        super((TileEntity)tile);
        this.enchant = enchant;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.mat != null) {
            buf.writeByte(0);
            buf.writeByte(this.mat.ordinal());
        } else if (this.enchant >= 0) {
            buf.writeByte(1);
            buf.writeShort(this.enchant);
        } else {
            buf.writeByte(2);
        }
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        byte command = buf.readByte();
        if (command == 0) {
            this.mat = Mats.values()[buf.readByte()];
        } else if (command == 1) {
            this.enchant = buf.readShort();
        } else if (command != 2) {
            throw new InvalidParameterException();
        }
    }

    public IMessage onMessage(PacketTcomAction message, MessageContext ctx) {
        TileTcom tile = (TileTcom)message.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
        if (tile == null) {
            return null;
        }
        if (message.mat != null) {
            tile.extractItems(message.mat, ctx.getServerHandler().field_147369_b);
        } else if (message.enchant >= 0) {
            tile.extractEnchantment(message.enchant, ctx.getServerHandler().field_147369_b);
        } else {
            tile.updateClient(ctx.getServerHandler().field_147369_b);
        }
        return null;
    }
}

