/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.part;

import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.Log;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.framework.AbstractBlockFramework;
import info.loenwind.enderioaddons.machine.framework.RendererFrameworkMachine;
import info.loenwind.enderioaddons.machine.part.ItemMachinePart;
import info.loenwind.enderioaddons.machine.part.MachinePart;
import info.loenwind.enderioaddons.machine.tcom.RendererTcom;
import info.loenwind.enderioaddons.render.TickRotator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class MachinePartRenderer
implements IItemRenderer {
    private boolean loggedError = false;
    @Nonnull
    private final RendererFrameworkMachine frameRenderer;
    private static final Impl implTechne = new ImplTechne();
    private static final Impl implBlockAsItem = new ImplBlockAsItem();
    private static final Impl implExplicit = new ImplExplicit();

    public MachinePartRenderer(@Nonnull RendererFrameworkMachine frameRenderer) {
        this.frameRenderer = frameRenderer;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (item != null && MachinePart.values()[item.func_77960_j()].render3d) {
            return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderBlocks = NullHelper.notnullM((RenderBlocks)data[0], "Game state error: Missing RenderBlock parameter");
        ItemStack itemToRender = NullHelper.notnullM(item, "Game state error: Missing item to render");
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        if (item.func_77960_j() == MachinePart.TRAY.ordinal() || item.func_77960_j() == MachinePart.PYLON.ordinal() || item.func_77960_j() == MachinePart.PYLONTANK.ordinal()) {
            this.setup(implExplicit, type, itemToRender, renderBlocks).render(itemToRender, renderBlocks, this.frameRenderer);
        } else if (MachinePart.values()[item.func_77960_j()].renderAsFrameMachine) {
            this.setup(implTechne, type, itemToRender, renderBlocks).render(itemToRender, renderBlocks, this.frameRenderer);
        } else if (MachinePart.values()[item.func_77960_j()].render3d) {
            this.setup(implBlockAsItem, type, itemToRender, renderBlocks).render(itemToRender, renderBlocks, this.frameRenderer);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private Impl setup(Impl impl, IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            impl.setup_Inventory(type, item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            impl.setup_Equipped(type, item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            impl.setup_Entity(type, item, renderBlocks);
        } else if (!this.loggedError) {
            Log.warn((String)"MachinePartRenderer.renderItem: Unsupported render type");
            this.loggedError = true;
        }
        return impl;
    }

    private static class ImplExplicit
    implements Impl {
        private ImplExplicit() {
        }

        @Override
        public void setup_Entity(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            if (Config.rotationInItemframesEnabled.getBoolean() && item.func_82839_y()) {
                TickRotator.getInstance().rotateGl(2.0);
            }
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }

        @Override
        public void setup_Equipped(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
        }

        @Override
        public void setup_Inventory(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }

        @Override
        public void render(ItemStack item, RenderBlocks renderBlocks, RendererFrameworkMachine frameRenderer) {
            GL11.glEnable((int)3008);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
            RenderUtil.bindBlockTexture();
            if (item.func_77960_j() == MachinePart.TRAY.ordinal()) {
                RendererTcom.renderStandaloneTray();
            } else if (item.func_77960_j() == MachinePart.PYLON.ordinal()) {
                RendererTcom.renderStandaloneEnchantmentPylon(false);
            } else if (item.func_77960_j() == MachinePart.PYLONTANK.ordinal()) {
                RendererTcom.renderStandaloneEnchantmentPylon(true);
            }
            Tessellator.field_78398_a.func_78381_a();
            GL11.glDisable((int)3008);
        }
    }

    private static class ImplBlockAsItem
    implements Impl {
        private ImplBlockAsItem() {
        }

        @Override
        public void setup_Entity(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            if (Config.rotationInItemframesEnabled.getBoolean() && item.func_82839_y()) {
                TickRotator.getInstance().rotateGl(2.0);
            }
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }

        @Override
        public void setup_Equipped(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }

        @Override
        public void setup_Inventory(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
        }

        @Override
        public void render(ItemStack item, RenderBlocks renderBlocks, RendererFrameworkMachine frameRenderer) {
            GL11.glEnable((int)3008);
            renderBlocks.func_147757_a(ItemMachinePart.itemMachinePart.func_77617_a(item.func_77960_j()));
            renderBlocks.func_147800_a(Blocks.field_150348_b, 0, 1.0f);
            renderBlocks.func_147771_a();
            GL11.glDisable((int)3008);
        }
    }

    private static class ImplTechne
    implements Impl {
        private ImplTechne() {
        }

        @Override
        public void setup_Entity(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            if (Config.rotationInItemframesEnabled.getBoolean() && item.func_82839_y()) {
                TickRotator.getInstance().rotateGl(2.0);
            }
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            if (!MachinePart.values()[item.func_77960_j()].hasFrame && !MachinePart.values()[item.func_77960_j()].hasTanks) {
                if (MachinePart.values()[item.func_77960_j()].hasSingleTank) {
                    GL11.glTranslatef((float)0.25f, (float)0.25f, (float)-0.25f);
                } else {
                    GL11.glTranslatef((float)0.25f, (float)-0.25f, (float)-0.25f);
                }
            }
        }

        @Override
        public void setup_Equipped(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
            if (!MachinePart.values()[item.func_77960_j()].hasFrame && !MachinePart.values()[item.func_77960_j()].hasTanks) {
                if (MachinePart.values()[item.func_77960_j()].hasSingleTank) {
                    GL11.glTranslatef((float)0.25f, (float)0.25f, (float)-0.25f);
                } else {
                    GL11.glTranslatef((float)0.25f, (float)-0.25f, (float)-0.25f);
                }
                if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                    GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                }
            }
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }

        @Override
        public void setup_Inventory(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderBlocks) {
            if (!MachinePart.values()[item.func_77960_j()].hasFrame && !MachinePart.values()[item.func_77960_j()].hasTanks) {
                if (MachinePart.values()[item.func_77960_j()].hasSingleTank) {
                    GL11.glTranslatef((float)0.25f, (float)0.25f, (float)-0.25f);
                } else {
                    GL11.glTranslatef((float)0.25f, (float)-0.25f, (float)-0.25f);
                }
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            }
        }

        @Override
        public void render(ItemStack item, RenderBlocks renderBlocks, RendererFrameworkMachine frameRenderer) {
            GL11.glEnable((int)3008);
            RenderUtil.bindBlockTexture();
            frameRenderer.renderInventoryBlock((Block)AbstractBlockFramework.blockDummy, item.func_77960_j() + 16, 0, renderBlocks);
            GL11.glDisable((int)3008);
        }
    }

    private static interface Impl {
        public void setup_Entity(IItemRenderer.ItemRenderType var1, ItemStack var2, RenderBlocks var3);

        public void setup_Equipped(IItemRenderer.ItemRenderType var1, ItemStack var2, RenderBlocks var3);

        public void setup_Inventory(IItemRenderer.ItemRenderType var1, ItemStack var2, RenderBlocks var3);

        public void render(@Nonnull ItemStack var1, @Nonnull RenderBlocks var2, RendererFrameworkMachine var3);
    }
}

