/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.ihopper;

import com.enderio.core.common.util.BlockCoord;
import info.loenwind.autosave.IHandler;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.gui.AdvancedRedstoneMode;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

@Storable(handler=RedstoneModeState.class)
public class RedstoneModeState
implements IHandler<RedstoneModeState> {
    private AdvancedRedstoneMode mode = AdvancedRedstoneMode.values()[0];
    private PrevStates prevState = PrevStates.NONE;

    public RedstoneModeState() {
    }

    public RedstoneModeState(AdvancedRedstoneMode mode) {
        this.mode = mode;
    }

    public void setMode(AdvancedRedstoneMode mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.prevState = PrevStates.NONE;
        }
    }

    public AdvancedRedstoneMode getMode() {
        return this.mode;
    }

    public boolean isConditionMet(World world, BlockCoord bc) {
        return this.isConditionMet(world.func_94572_D(bc.x, bc.y, bc.z));
    }

    public boolean isConditionMet(World world, int x, int y, int z) {
        return this.isConditionMet(world.func_94572_D(x, y, z));
    }

    public boolean isConditionMet(int powerLevel) {
        switch (this.mode) {
            case IGNORE: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case OFF: {
                return powerLevel < 1;
            }
            case ON: {
                return powerLevel > 0;
            }
            case RISING_EDGE: {
                if (this.prevState == PrevStates.NONE) {
                    this.prevState = powerLevel == 0 ? PrevStates.OFF : PrevStates.ON;
                    return false;
                }
                if (this.prevState == PrevStates.OFF) {
                    this.prevState = powerLevel == 0 ? PrevStates.OFF : PrevStates.ON;
                    return powerLevel > 0;
                }
                this.prevState = powerLevel == 0 ? PrevStates.OFF : PrevStates.ON;
                return false;
            }
            case FALLING_EDGE: {
                if (this.prevState == PrevStates.NONE) {
                    this.prevState = powerLevel == 0 ? PrevStates.OFF : PrevStates.ON;
                    return false;
                }
                if (this.prevState == PrevStates.ON) {
                    this.prevState = powerLevel == 0 ? PrevStates.OFF : PrevStates.ON;
                    return powerLevel == 0;
                }
                this.prevState = powerLevel == 0 ? PrevStates.OFF : PrevStates.ON;
                return false;
            }
            case HIGH_PULSE: {
                if (this.prevState == PrevStates.NONE) {
                    this.prevState = powerLevel == 0 ? PrevStates.OFF : PrevStates.ON;
                    return false;
                }
                if (this.prevState == PrevStates.OFF) {
                    if (powerLevel >= 14) {
                        this.prevState = PrevStates.ON;
                        return true;
                    }
                    return false;
                }
                if (powerLevel == 0) {
                    this.prevState = PrevStates.OFF;
                }
                return false;
            }
            case LOW_PULSE: {
                if (this.prevState == PrevStates.NONE) {
                    this.prevState = powerLevel >= 14 ? PrevStates.ON : PrevStates.OFF;
                    return false;
                }
                if (this.prevState == PrevStates.ON) {
                    if (powerLevel == 0) {
                        this.prevState = PrevStates.OFF;
                        return true;
                    }
                    return false;
                }
                if (powerLevel >= 14) {
                    this.prevState = PrevStates.ON;
                }
                return false;
            }
        }
        throw new RuntimeException("enum has unexpected values");
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return RedstoneModeState.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean store(Registry registry, Set<Store.StoreFor> phase, NBTTagCompound nbt, String name, RedstoneModeState object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("mode", object.mode.ordinal());
        tag.func_74768_a("prevState", object.prevState.ordinal());
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    public RedstoneModeState read(Registry registry, Set<Store.StoreFor> phase, NBTTagCompound nbt, String name, RedstoneModeState object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        RedstoneModeState result;
        RedstoneModeState redstoneModeState = result = object != null ? object : new RedstoneModeState();
        if (nbt.func_74764_b(name)) {
            NBTTagCompound tag = NullHelper.notnullM(nbt.func_74775_l(name), "NBTTagCompound.getCompoundTag()");
            result.mode = AdvancedRedstoneMode.values()[tag.func_74764_b("mode") ? tag.func_74762_e("mode") : 0];
            result.prevState = PrevStates.values()[tag.func_74764_b("prevState") ? tag.func_74762_e("prevState") : 0];
        }
        return result;
    }

    private static enum PrevStates {
        NONE,
        OFF,
        ON;

    }
}

