/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.ihopper;

import crazypants.enderio.machine.SlotDefinition;

public class GhostlySlotDefinition
extends SlotDefinition {
    public final int minGhostSlot;
    public final int maxGhostSlot;

    public GhostlySlotDefinition(int numInputs, int numOutputs, int numUpgradeSlots, int numGostSlots) {
        super(numInputs, numOutputs, numUpgradeSlots);
        this.minGhostSlot = numGostSlots > 0 ? numInputs + numOutputs + numUpgradeSlots : -1;
        this.maxGhostSlot = this.minGhostSlot + (numGostSlots - 1);
    }

    public GhostlySlotDefinition(int minInputSlot, int maxInputSlot, int minOutputSlot, int maxOutputSlot, int minUpgradeSlot, int maxUpgradeSlot, int minGhostSlot, int maxGhostSlot) {
        super(minInputSlot, maxInputSlot, minOutputSlot, maxOutputSlot, minUpgradeSlot, maxUpgradeSlot);
        this.minGhostSlot = minGhostSlot;
        this.maxGhostSlot = maxGhostSlot;
    }

    public int getNumSlots() {
        return GhostlySlotDefinition.max(this.getMaxInputSlot(), this.getMaxOutputSlot(), this.getMaxUpgradeSlot(), this.getMaxGhostSlot()) + 1;
    }

    public int getMinGhostSlot() {
        return this.minGhostSlot;
    }

    public int getMaxGhostSlot() {
        return this.maxGhostSlot;
    }

    public boolean isGhostSlot(int slot) {
        return slot >= this.minGhostSlot && slot <= this.maxGhostSlot;
    }

    private static int max(int ... a) {
        int x = 0;
        for (int i : a) {
            if (i <= x) continue;
            x = i;
        }
        return x;
    }
}

