/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.framework;

import com.enderio.core.api.client.render.IRenderFace;
import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.CustomCubeRenderer;
import com.enderio.core.client.render.TechneModelRenderer;
import com.enderio.core.client.render.TechneUtil;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.client.render.VertexTransformComposite;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.OverlayRenderer;
import info.loenwind.enderioaddons.machine.framework.GroupObjectWithIcon;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.common.util.ForgeDirection;

public class TechneMachineRenderer<T extends AbstractMachineEntity>
extends TechneModelRenderer {
    @Nonnull
    private CustomCubeRenderer ccr = new CustomCubeRenderer();
    @Nonnull
    private OverlayRenderer overlay = new OverlayRenderer();

    public TechneMachineRenderer(@Nonnull AbstractMachineBlock<T> block, @Nonnull String modelPath) {
        super("enderioaddons", modelPath, block.func_149645_b(), (VertexTransform)new VertexTransformComposite(new VertexTransform[]{new VertexRotationFacing(ForgeDirection.NORTH)}));
    }

    public TechneMachineRenderer(int renderId, @Nonnull String modelPath) {
        super(TechneUtil.getModel((String)"enderioaddons", (String)modelPath), renderId, (VertexTransform)new VertexTransformComposite(new VertexTransform[]{new VertexRotationFacing(ForgeDirection.NORTH)}));
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.setFacingDir(ForgeDirection.SOUTH);
        TechneUtil.vt = this.vt;
        IIcon icon = this.getModelIcon(block, metadata);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        Tessellator.field_78398_a.func_78372_c(0.0f, -0.47f, 0.0f);
        for (GroupObject go : this.getModel(block, metadata)) {
            if (go instanceof GroupObjectWithIcon) {
                TechneUtil.renderWithIcon((GroupObject)go, (IIcon)((GroupObjectWithIcon)go).getControllerTexture(), (IIcon)renderer.field_147840_d, (Tessellator)Tessellator.field_78398_a, null, (int)0, (int)0, (int)0, (VertexTransform)this.vt, (boolean)true);
                continue;
            }
            TechneUtil.renderWithIcon((GroupObject)go, (IIcon)icon, (IIcon)renderer.field_147840_d, (Tessellator)Tessellator.field_78398_a, null, (int)0, (int)0, (int)0, (VertexTransform)this.vt, (boolean)true);
        }
        Tessellator.field_78398_a.func_78372_c(0.0f, 0.47f, 0.0f);
        Tessellator.field_78398_a.func_78381_a();
        TechneUtil.vt = null;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        AbstractMachineEntity te = (AbstractMachineEntity)world.func_147438_o(x, y, z);
        if (te != null) {
            this.setFacingDir(te.getFacingDir());
            this.overlay.setTile(te);
        }
        TechneUtil.vt = this.vt;
        IIcon icon = this.getModelIcon(world, x, y, z, block);
        Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z));
        Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
        Tessellator.field_78398_a.func_78372_c((float)x + 0.5f, (float)y + 0.0375f, (float)z + 0.5f);
        for (GroupObject go : this.getModel(world, x, y, z)) {
            if (go instanceof GroupObjectWithIcon) {
                TechneUtil.renderWithIcon((GroupObject)go, (IIcon)((GroupObjectWithIcon)go).getControllerTexture(), (IIcon)renderer.field_147840_d, (Tessellator)Tessellator.field_78398_a, (IBlockAccess)world, (int)x, (int)y, (int)z, (VertexTransform)this.vt, (boolean)true);
                continue;
            }
            TechneUtil.renderWithIcon((GroupObject)go, (IIcon)icon, (IIcon)renderer.field_147840_d, (Tessellator)Tessellator.field_78398_a, (IBlockAccess)world, (int)x, (int)y, (int)z, (VertexTransform)this.vt, (boolean)true);
        }
        Tessellator.field_78398_a.func_78372_c((float)(-x) - 0.5f, (float)(-y) - 0.0375f, (float)(-z) - 0.5f);
        TechneUtil.vt = null;
        if (renderer.field_147840_d == null) {
            this.ccr.renderBlock(world, block, x, y, z, (IRenderFace)this.overlay);
        }
        return true;
    }

    protected IIcon getModelIcon(Block block, int metadata) {
        return ((AbstractMachineBlock)block).getModelIcon();
    }

    protected IIcon getModelIcon(IBlockAccess world, int x, int y, int z, Block block) {
        return this.getModelIcon(block, 0);
    }

    private void setFacingDir(ForgeDirection dir) {
        VertexRotationFacing rot = (VertexRotationFacing)((VertexTransformComposite)this.vt).xforms[0];
        rot.setRotation(dir);
    }
}

