/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.flag;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.client.render.VertexRotation;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.client.render.VertexTransformComposite;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import info.loenwind.enderioaddons.machine.flag.BlockFlag;
import info.loenwind.enderioaddons.machine.flag.TileFlag;
import info.loenwind.enderioaddons.render.FaceRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TESRFlag
extends TileEntitySpecialRenderer {
    private static final double px = 0.0625;
    private static final VertexRotationFacing xform = new VertexRotationFacing(ForgeDirection.SOUTH);
    private static final BoundingBox[] bb_pole;
    private static final BoundingBox bb_flag;

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTick) {
        if (te instanceof TileFlag) {
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator.field_78398_a.func_78382_b();
            RenderUtil.bindBlockTexture();
            Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
            TESRFlag.renderFlag((TileFlag)te, partialTick);
            Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
            Tessellator.field_78398_a.func_78381_a();
            GL11.glPopAttrib();
        }
    }

    public static void renderFlag(TileFlag te, float partialTick) {
        double poleRotation;
        double flagRotation;
        boolean renderFlag;
        BoundingBox bb;
        IIcon icon = BlockFlag.blockFlag.func_149691_a(6, 0);
        BlockCoord parent = te.getParent();
        BlockCoord location = te.getLocation();
        int renderAge = te.getRenderAge();
        long tickCount = EnderIO.proxy.getTickCount();
        int renderAgeScaled = renderAge / 4;
        if (!te.isCharged()) {
            return;
        }
        if (!(renderAgeScaled <= 7 && renderAge >= 0 || te.func_145831_w().func_147437_c(te.field_145851_c, te.field_145848_d + 1, te.field_145849_e))) {
            renderAgeScaled = 7;
            bb = bb_pole[renderAgeScaled];
            renderFlag = false;
            flagRotation = 0.0;
            poleRotation = 0.0;
            te.resetRenderAge(24);
            te.playSound(1);
        } else if (renderAgeScaled > 15 || renderAge < 0) {
            renderAgeScaled = 15;
            bb = bb_pole[15];
            renderFlag = true;
            if (parent != null) {
                poleRotation = flagRotation = TESRFlag.computeRotation(location, parent);
            } else {
                long tickCountSalted = tickCount + (long)(location.x << 16) + (long)(location.y << 24) + (long)(location.z << 8);
                flagRotation = (double)tickCountSalted * 0.25 % (Math.PI * 2) + (double)partialTick * 0.25 % (Math.PI * 2) - Math.PI;
                poleRotation = 0.0;
            }
        } else {
            int renderAgePartial = renderAge - renderAgeScaled * 4 - 4;
            if (renderAge == 1 && renderAgePartial == -3) {
                te.playSound(0);
            }
            bb = bb_pole[renderAgeScaled].translate(0.0f, (float)((double)(((float)renderAgePartial + partialTick) / 4.0f) * 0.0625), 0.0f);
            renderFlag = false;
            flagRotation = 0.0;
            poleRotation = 0.0;
        }
        xform.setAngle(poleRotation);
        FaceRenderer.setupVertices(bb, (VertexTransform)xform);
        float minU = icon.func_94209_e();
        float maxU = icon.func_94214_a(2.0);
        float minV = icon.func_94206_g();
        float maxV = icon.func_94207_b((double)(renderAgeScaled + 1));
        FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        minU = maxU;
        maxU = icon.func_94214_a(4.0);
        FaceRenderer.renderSingleFace(ForgeDirection.EAST, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        minU = maxU;
        maxU = icon.func_94214_a(6.0);
        FaceRenderer.renderSingleFace(ForgeDirection.WEST, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        minU = maxU;
        maxU = icon.func_94214_a(8.0);
        FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        minU = icon.func_94214_a(2.0);
        maxU = icon.func_94214_a(4.0);
        minV = icon.func_94206_g();
        maxV = icon.func_94207_b(2.0);
        FaceRenderer.renderSingleFace(ForgeDirection.UP, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        if (renderFlag) {
            VertexRotation xform2 = new VertexRotation(0.0, new Vector3d(0.0, 0.5, 0.0), new Vector3d(1.0, 1.25, 0.5));
            xform2.setAngle(0.08726646259971647);
            VertexTransformComposite xform3 = new VertexTransformComposite(new VertexTransform[]{xform2, xform});
            xform.setAngle(flagRotation);
            FaceRenderer.setupVertices(bb_flag, (VertexTransform)xform3);
            minU = icon.func_94214_a(8.0);
            maxU = icon.func_94212_f();
            minV = icon.func_94206_g();
            maxV = icon.func_94207_b(8.0);
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, (tickCount & 4L) == 0L);
            minV = icon.func_94207_b(8.0);
            maxV = icon.func_94210_h();
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, (tickCount & 4L) != 0L);
            xform2.setAngle(-0.08726646259971647);
            FaceRenderer.setupVertices(bb_flag, (VertexTransform)xform3);
            minU = icon.func_94214_a(8.0);
            maxU = icon.func_94212_f();
            minV = icon.func_94206_g();
            maxV = icon.func_94207_b(8.0);
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, (tickCount & 4L) == 0L);
            minV = icon.func_94207_b(8.0);
            maxV = icon.func_94210_h();
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, (tickCount & 4L) != 0L);
        }
    }

    private static double computeRotation(BlockCoord from, BlockCoord to) {
        double d0 = from.x - to.x;
        double d2 = from.z - to.z;
        double f = Math.atan2(d2, d0);
        return Math.PI - f;
    }

    private static BoundingBox makePartialBB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BoundingBox bb = new BoundingBox(0.0625 * (double)minX, 0.0625 * (double)minY, 0.0625 * (double)minZ, 0.0625 * (double)maxX, 0.0625 * (double)maxY, 0.0625 * (double)maxZ);
        return bb;
    }

    static {
        xform.setCenter(new Vector3d(0.5, 0.5, 0.5));
        bb_pole = new BoundingBox[16];
        for (int i = 0; i < 16; ++i) {
            TESRFlag.bb_pole[i] = TESRFlag.makePartialBB(7, 0, 7, 8, i + 1, 8).translate(0.03125f, 0.475f, 0.03125f);
        }
        bb_flag = TESRFlag.makePartialBB(9, 8, 8, 16, 16, 8).translate(0.0f, 0.475f, 0.0f);
    }
}

