/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.drain;

import com.enderio.core.common.util.BlockCoord;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.fluid.FluidType;
import info.loenwind.enderioaddons.machine.drain.IDrainingCallback;
import info.loenwind.enderioaddons.machine.drain.filter.FluidFilter;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public final class FluidHelper {
    @Nonnull
    private final World world;
    @Nonnull
    private final FluidStack stack;
    @Nonnull
    private final Fluid fluid;
    @Nonnull
    private final Block block;
    @Nonnull
    private final ForgeDirection downflowDirection;
    @Nonnull
    private final ForgeDirection upflowDirection;
    @Nonnull
    private final FluidType type;
    @Nullable
    private final BlockCoord startbc;
    private IDrainingCallback hook;
    @Nonnull
    private static final ForgeDirection[] DIRECTIONS_INIT = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    @Nonnull
    public static final ForgeDirection[] DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    private Set<BlockCoord> seen;

    public void setDrainingCallback(@Nonnull IDrainingCallback hook) {
        this.hook = hook;
    }

    private FluidHelper(@Nonnull World world, @Nonnull FluidStack stack, @Nullable BlockCoord startbc) throws Exception {
        this.world = world;
        this.stack = stack;
        this.fluid = NullHelper.notnullF(stack.getFluid(), "FluidStack.getFluid()");
        this.block = NullHelper.notnull(this.fluid.getBlock(), "Invalid Fluid (it has no source block)");
        this.downflowDirection = this.fluid.getDensity() > 0 ? ForgeDirection.DOWN : ForgeDirection.UP;
        ForgeDirection forgeDirection = this.upflowDirection = this.downflowDirection == ForgeDirection.UP ? ForgeDirection.DOWN : ForgeDirection.UP;
        if (this.block instanceof BlockFluidClassic) {
            this.type = FluidType.CLASSIC;
        } else if (this.block instanceof BlockFluidFinite) {
            this.type = FluidType.FINITE;
        } else if (this.block instanceof BlockLiquid) {
            this.type = FluidType.VANILLA;
        } else {
            throw new Exception();
        }
        this.startbc = startbc;
    }

    public static boolean isSourceBlock(@Nonnull World world, @Nonnull BlockCoord bc) {
        if (!world.func_72899_e(bc.x, bc.y, bc.z)) {
            return false;
        }
        Block block = bc.getBlock((IBlockAccess)world);
        if (block instanceof BlockFluidClassic) {
            return ((BlockFluidClassic)block).isSourceBlock((IBlockAccess)world, bc.x, bc.y, bc.z);
        }
        if (block instanceof BlockFluidFinite) {
            return ((BlockFluidFinite)block).canDrain(world, bc.x, bc.y, bc.z);
        }
        if (block instanceof BlockLiquid) {
            return world.func_72805_g(bc.x, bc.y, bc.z) == 0;
        }
        return false;
    }

    @Nullable
    public static FluidHelper getInstance(@Nonnull World world, @Nonnull BlockCoord bc, @Nonnull FluidFilter whitelist, @Nonnull FluidFilter blacklist) {
        FluidHelper result;
        Fluid fluidForBlock;
        BlockCoord direction;
        for (ForgeDirection forgeDirection : DIRECTIONS_INIT) {
            direction = FluidHelper.getLocation(bc, forgeDirection);
            if (!FluidHelper.isSourceBlock(world, direction) || (fluidForBlock = FluidRegistry.lookupFluidForBlock((Block)direction.getBlock((IBlockAccess)world))) == null || !whitelist.isFluid(fluidForBlock) || blacklist.isFluid(fluidForBlock) || (result = FluidHelper.getInstance(world, new FluidStack(fluidForBlock, 1000), direction)) == null) continue;
            return result;
        }
        for (ForgeDirection forgeDirection : DIRECTIONS_INIT) {
            direction = FluidHelper.getLocation(bc, forgeDirection);
            fluidForBlock = FluidRegistry.lookupFluidForBlock((Block)direction.getBlock((IBlockAccess)world));
            if (fluidForBlock == null || !whitelist.isFluid(fluidForBlock) || blacklist.isFluid(fluidForBlock) || (result = FluidHelper.getInstance(world, new FluidStack(fluidForBlock, 1000), direction)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static FluidHelper getInstance(@Nonnull World world, @Nonnull BlockCoord bc, @Nonnull FluidStack fs) {
        BlockCoord direction;
        for (ForgeDirection forgeDirection : DIRECTIONS_INIT) {
            direction = FluidHelper.getLocation(bc, forgeDirection);
            if (!FluidHelper.isSourceBlock(world, direction) || !FluidHelper.isSameLiquid(fs, world, direction)) continue;
            return FluidHelper.getInstance(world, fs, direction);
        }
        for (ForgeDirection forgeDirection : DIRECTIONS_INIT) {
            direction = FluidHelper.getLocation(bc, forgeDirection);
            if (!FluidHelper.isSameLiquid(fs, world, direction)) continue;
            return FluidHelper.getInstance(world, fs, direction);
        }
        return null;
    }

    @Nullable
    public static FluidHelper getInstance(@Nonnull World world, @Nonnull FluidStack stack, @Nullable BlockCoord startbc) {
        try {
            return new FluidHelper(world, stack, startbc);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    public static FluidHelper getInstance(@Nonnull World world, @Nonnull FluidStack stack) {
        return FluidHelper.getInstance(world, stack, null);
    }

    private static boolean isInWorld(@Nonnull BlockCoord bc) {
        return bc.y > 0 && bc.y <= 255;
    }

    public boolean isSameLiquid(@Nonnull BlockCoord bc) {
        return this.world.func_72899_e(bc.x, bc.y, bc.z) && bc.getBlock((IBlockAccess)this.world) == this.block;
    }

    public boolean isSameLiquid(Fluid otherFluid) {
        return this.fluid == otherFluid;
    }

    public static boolean isSameLiquid(@Nonnull FluidStack fs, @Nonnull World world, @Nonnull BlockCoord bc) {
        return world.func_72899_e(bc.x, bc.y, bc.z) && bc.getBlock((IBlockAccess)world) == fs.getFluid().getBlock();
    }

    public boolean isSourceBlock(@Nonnull BlockCoord bc) {
        switch (this.type) {
            case CLASSIC: {
                return ((BlockFluidClassic)this.block).isSourceBlock((IBlockAccess)this.world, bc.x, bc.y, bc.z);
            }
            case FINITE: {
                return false;
            }
            case VANILLA: {
                return this.world.func_72805_g(bc.x, bc.y, bc.z) == 0;
            }
        }
        throw new IllegalStateException("unreachable code");
    }

    public boolean isFlowingBlock(@Nonnull BlockCoord bc) {
        switch (this.type) {
            case CLASSIC: {
                return !((BlockFluidClassic)this.block).isSourceBlock((IBlockAccess)this.world, bc.x, bc.y, bc.z);
            }
            case FINITE: {
                return false;
            }
            case VANILLA: {
                return this.world.func_72805_g(bc.x, bc.y, bc.z) != 0;
            }
        }
        throw new IllegalStateException("unreachable code");
    }

    @Nonnull
    public static BlockCoord getLocation(@Nonnull BlockCoord bc, ForgeDirection dir) {
        NullHelper.notnull(dir, "ForgeDirection went AWOL");
        return new BlockCoord(bc.x + dir.offsetX, bc.y + dir.offsetY, bc.z + dir.offsetZ);
    }

    public boolean isFlowingVertically2(@Nonnull BlockCoord bc) {
        BlockCoord downflow = FluidHelper.getLocation(bc, this.downflowDirection);
        return this.isSameLiquid(FluidHelper.getLocation(bc, ForgeDirection.UP)) && this.isSameLiquid(FluidHelper.getLocation(bc, ForgeDirection.DOWN)) && !this.isSourceBlock(downflow);
    }

    public boolean isUpflow(@Nonnull BlockCoord bc0, @Nonnull BlockCoord bc1) {
        switch (this.type) {
            case CLASSIC: {
                return this.world.func_72805_g(bc1.x, bc1.y, bc1.z) < this.world.func_72805_g(bc0.x, bc0.y, bc0.z) || this.isSameLiquid(FluidHelper.getLocation(bc1, this.upflowDirection));
            }
            case FINITE: {
                return this.world.func_72805_g(bc1.x, bc1.y, bc1.z) > this.world.func_72805_g(bc0.x, bc0.y, bc0.z);
            }
            case VANILLA: {
                return this.world.func_72805_g(bc1.x, bc1.y, bc1.z) < this.world.func_72805_g(bc0.x, bc0.y, bc0.z) || (this.world.func_72805_g(bc1.x, bc1.y, bc1.z) & 8) != 0;
            }
        }
        throw new IllegalStateException("unreachable code");
    }

    public void doFlow(@Nonnull BlockCoord bc0, @Nonnull BlockCoord bc1) {
        if (FluidHelper.isInWorld(bc1)) {
            this.world.func_147465_d(bc1.x, bc1.y, bc1.z, this.world.func_147439_a(bc0.x, bc0.y, bc0.z), this.world.func_72805_g(bc0.x, bc0.y, bc0.z), 3);
        }
        switch (this.type) {
            case FINITE: {
                this.world.func_147468_f(bc0.x, bc0.y, bc0.z);
                break;
            }
            case CLASSIC: 
            case VANILLA: {
                if (this.adjCount(bc0) > 1) {
                    this.world.func_147465_d(bc0.x, bc0.y, bc0.z, this.world.func_147439_a(bc0.x, bc0.y, bc0.z), 1, 3);
                    if (this.fluid != FluidRegistry.WATER || this.hook == null) break;
                    this.preventWater(bc0);
                    this.preventWater(bc1);
                    break;
                }
                this.world.func_147468_f(bc0.x, bc0.y, bc0.z);
            }
        }
    }

    private void preventWater(@Nonnull BlockCoord bc) {
        for (ForgeDirection forgeDirection : DIRECTIONS) {
            BlockCoord bc1 = FluidHelper.getLocation(bc, forgeDirection);
            if (!this.isSameLiquid(bc1) || this.isSourceBlock(bc1)) continue;
            this.hook.onWaterDrainNearby(this.world, bc1);
        }
        this.hook.onWaterDrain(this.world, bc);
    }

    private int adjCount(@Nonnull BlockCoord bc) {
        int result = 0;
        for (ForgeDirection forgeDirection : DIRECTIONS) {
            if (!this.isSameLiquid(FluidHelper.getLocation(bc, forgeDirection))) continue;
            ++result;
        }
        return result;
    }

    public boolean findAndPullSourceBlock(@Nonnull BlockCoord bc) {
        this.seen = new HashSet<BlockCoord>();
        return this.findAndPullSourceBlock(bc, false);
    }

    @Nonnull
    public ReturnObject eatOrPullFluid() {
        return this.eatOrPullFluid(NullHelper.notnull(this.startbc, "FluidHelper starting position has not been set"));
    }

    @Nonnull
    public ReturnObject eatOrPullFluid(@Nonnull BlockCoord bc) {
        ReturnObject result = new ReturnObject();
        if (this.isSameLiquid(bc)) {
            if (!this.isSourceBlock(bc)) {
                this.seen = new HashSet<BlockCoord>();
                result.inProgress = this.findAndPullSourceBlock(bc, true);
            }
            if (this.isSourceBlock(bc)) {
                switch (this.type) {
                    case CLASSIC: 
                    case FINITE: {
                        if (((IFluidBlock)this.block).canDrain(this.world, bc.x, bc.y, bc.z)) {
                            result.result = ((IFluidBlock)this.block).drain(this.world, bc.x, bc.y, bc.z, true);
                            break;
                        }
                        result.isDry = true;
                        break;
                    }
                    case VANILLA: {
                        result.result = this.stack.copy();
                        NullHelper.notnullF(result.result, (String)"FluidStack.copy()").amount = 1000;
                        if (this.fluid == FluidRegistry.WATER && this.hook != null) {
                            this.hook.onWaterDrain(this.world, bc);
                        }
                        this.world.func_147468_f(bc.x, bc.y, bc.z);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unreachable code");
                    }
                }
            }
            if (!result.inProgress && result.result == null) {
                result.isDry = true;
                for (BlockCoord blockCoord : this.seen) {
                    if (!this.isFlowingBlock(blockCoord = NullHelper.notnull(blockCoord, "FluidHelper is confused: I remember to have visited an invalid location?")) || !this.isSameLiquid(blockCoord)) continue;
                    this.world.func_147468_f(blockCoord.x, blockCoord.y, blockCoord.z);
                }
            }
        } else {
            result.isDry = true;
        }
        return result;
    }

    private boolean findAndPullSourceBlock(@Nonnull BlockCoord bc, boolean foundStepUp) {
        if (!this.seen.contains(bc)) {
            this.seen.add(bc);
            BlockCoord upflow = FluidHelper.getLocation(bc, this.upflowDirection);
            if (FluidHelper.isInWorld(upflow) && this.isSameLiquid(upflow)) {
                if (this.isSourceBlock(upflow)) {
                    this.doFlow(upflow, bc);
                    return true;
                }
                if (this.findAndPullSourceBlock(upflow, true)) {
                    return true;
                }
            }
            for (ForgeDirection dir : DIRECTIONS) {
                BlockCoord bc2 = FluidHelper.getLocation(bc, dir);
                if (!this.isSameLiquid(bc2)) continue;
                if (this.isSourceBlock(bc2)) {
                    if (foundStepUp) {
                        if (this.isSameLiquid(FluidHelper.getLocation(bc2, this.downflowDirection)) && !this.isSourceBlock(FluidHelper.getLocation(bc2, this.downflowDirection)) && this.isSameLiquid(FluidHelper.getLocation(bc, this.downflowDirection)) && !this.isSourceBlock(FluidHelper.getLocation(bc, this.downflowDirection))) {
                            this.doFlow(bc2, FluidHelper.getLocation(bc2, this.downflowDirection));
                        } else {
                            this.doFlow(bc2, bc);
                        }
                    }
                    return true;
                }
                if (!this.isUpflow(bc, bc2) || this.isFlowingVertically2(bc2) || !this.findAndPullSourceBlock(bc2, foundStepUp)) continue;
                return true;
            }
        }
        return false;
    }

    public FluidStack getFluidStack() {
        return this.stack;
    }

    public static class ReturnObject {
        public boolean isDry = false;
        public boolean inProgress = false;
        @Nullable
        public FluidStack result = null;
    }
}

