/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.cobbleworks;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.cobbleworks.BlockCobbleworks;
import info.loenwind.enderioaddons.machine.framework.AbstractTileFramework;
import info.loenwind.enderioaddons.machine.framework.IFrameworkMachine;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@Storable
public class TileCobbleworks
extends AbstractTileFramework
implements IFrameworkMachine {
    static final int SLOTS_PER_WORK = 4;
    static final int WORKS = 3;
    @Nonnull
    private final Mapping[] outputMapping = new Mapping[13];
    @GameRegistry.ItemStackHolder(value="EnderIO:blockCrafter")
    public static final ItemStack blockCrafter = null;
    @GameRegistry.ItemStackHolder(value="EnderIO:blockAlloySmelter")
    public static final ItemStack blockAlloySmelter = null;
    @GameRegistry.ItemStackHolder(value="EnderIO:blockSagMill")
    public static final ItemStack blockSagMill = null;
    private boolean inputsChanged = true;
    private int capTickLimit = 0;
    @Store(value={Store.StoreFor.CLIENT})
    private int active = 0;
    @Store(value={Store.StoreFor.CLIENT})
    private int activeWorks = 0;

    public TileCobbleworks() {
        super(new SlotDefinition(3, 13, 1));
    }

    public String getMachineName() {
        return BlockCobbleworks.ModObject_blockCobbleworks.unlocalisedName;
    }

    public void init() {
        super.init();
        this.inputsChanged = true;
        this.computeOutputMapping();
    }

    private static boolean isUpgradeMachine(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item == blockCrafter.func_77973_b() || item == blockAlloySmelter.func_77973_b() || item == blockSagMill.func_77973_b();
    }

    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (this.slotDefinition.isInputSlot(i)) {
            return TileCobbleworks.isUpgradeMachine(itemstack);
        }
        if (this.slotDefinition.isOutputSlot(i)) {
            Mapping mapping = this.outputMapping[i - this.slotDefinition.minOutputSlot];
            return mapping != null && itemstack != null && mapping.itemStack.func_77969_a(itemstack);
        }
        return false;
    }

    public int getInventoryStackLimit(int slot) {
        if (this.slotDefinition.isInputSlot(slot)) {
            return 1;
        }
        return 64;
    }

    public int func_70297_j_() {
        return this.getInventoryStackLimit(0);
    }

    public boolean isActive() {
        return this.hasPower() && this.redstoneCheckPassed && this.active > 0;
    }

    boolean isActive(int work) {
        if (work == 0) {
            return this.activeWorks != 0;
        }
        if (work == 1) {
            return (this.activeWorks & 0x1FFE) != 0;
        }
        if (work == 2) {
            return (this.activeWorks & 0x1FE0) != 0;
        }
        if (work == 3) {
            return (this.activeWorks & 0x1E00) != 0;
        }
        return false;
    }

    protected void updateEntityClient() {
        if (this.active > 0) {
            --this.active;
        }
        super.updateEntityClient();
    }

    protected boolean processTasks(boolean rsCheckPassed) {
        boolean updateClient = this.computeOutputMapping();
        if (rsCheckPassed && this.reCraft()) {
            this.active = 40;
            return true;
        }
        if (this.active > 0) {
            --this.active;
            return updateClient;
        }
        if (this.activeWorks != 0) {
            this.activeWorks = 0;
            return true;
        }
        return updateClient;
    }

    private int outputSlotNo(int no) {
        return no + this.slotDefinition.minOutputSlot;
    }

    @Nullable
    private ItemStack outputSlot(int no) {
        return this.inventory[this.outputSlotNo(no)];
    }

    private void outputSlot(int no, @Nullable ItemStack is) {
        this.inventory[this.outputSlotNo((int)no)] = is;
    }

    int outputSlotNo(int work, int no) {
        return this.outputSlotNo(TileCobbleworks.outputMappingNo(work, no));
    }

    private static int outputMappingNo(int work, int no) {
        return work == 0 ? 0 : (work - 1) * 4 + no;
    }

    private void outputMapping(int work, int no, @Nullable Mapping mapping) {
        this.outputMapping[TileCobbleworks.outputMappingNo((int)work, (int)no)] = mapping;
    }

    @Nullable
    private Mapping outputMapping(int work, int no) {
        return this.outputMapping[TileCobbleworks.outputMappingNo(work, no)];
    }

    int inputSlotNo(int no) {
        return no + this.slotDefinition.minInputSlot - 1;
    }

    @Nullable
    private ItemStack inputSlot(int no) {
        return this.inventory[this.inputSlotNo(no)];
    }

    private static void clear(@Nonnull Object[] list) {
        for (int i = 0; i < list.length; ++i) {
            list[i] = null;
        }
    }

    @Nonnull
    private List<Mapping> getInputForWork(int work) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        if (work == 1) {
            result.add(this.outputMapping(0, 0));
        } else {
            for (int i = 1; i <= 4; ++i) {
                result.add(this.outputMapping(work - 1, i));
            }
        }
        return result;
    }

    private boolean computeOutputMapping() {
        if (!this.inputsChanged || this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return false;
        }
        this.inputsChanged = false;
        TileCobbleworks.clear(this.outputMapping);
        this.outputMapping(0, 0, new Mapping(OperationType.NONE, new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 1), Config.cobbleWorksRfPerCobblestone.getInt(), -1, null, 0));
        for (int work = 1; work <= 3; ++work) {
            ItemStack machine = this.inputSlot(work);
            List<Mapping> input = this.getInputForWork(work);
            ArrayList<Mapping> output = new ArrayList<Mapping>();
            if (machine != null && machine.func_77973_b() != null && !input.isEmpty()) {
                for (Mapping mapping : input) {
                    if (mapping == null) continue;
                    if (machine.func_77973_b() == blockCrafter.func_77973_b()) {
                        this.computeCrafterOutput(output, mapping);
                        continue;
                    }
                    if (machine.func_77973_b() == blockAlloySmelter.func_77973_b()) {
                        TileCobbleworks.computeMachineOutput(output, mapping, ModObject.blockAlloySmelter.unlocalisedName, OperationType.SMELTING);
                        continue;
                    }
                    if (machine.func_77973_b() != blockSagMill.func_77973_b()) continue;
                    TileCobbleworks.computeMachineOutput(output, mapping, ModObject.blockSagMill.unlocalisedName, OperationType.CRUSHING);
                }
            }
            for (Mapping mapping : output) {
                int i;
                boolean done = false;
                Mapping om0 = this.outputMapping(0, 0);
                if (om0 != null && om0.itemStack.func_77969_a(mapping.itemStack)) {
                    done = true;
                }
                for (int w = 1; !done && w < work; ++w) {
                    for (int i2 = 1; !done && i2 <= 4; ++i2) {
                        Mapping om = this.outputMapping(w, i2);
                        if (om == null || !om.itemStack.func_77969_a(mapping.itemStack)) continue;
                        done = true;
                    }
                }
                for (i = 1; !done && i <= 4; ++i) {
                    Mapping om = this.outputMapping(work, i);
                    if (om == null || !om.itemStack.func_77969_a(mapping.itemStack)) continue;
                    done = true;
                    if (om.costInRF <= mapping.costInRF) continue;
                    mapping.position = TileCobbleworks.outputMappingNo(work, i);
                    this.outputMapping(work, i, mapping);
                }
                for (i = 1; !done && i <= 4; ++i) {
                    if (this.outputMapping(work, i) != null) continue;
                    done = true;
                    mapping.position = TileCobbleworks.outputMappingNo(work, i);
                    this.outputMapping(work, i, mapping);
                }
                if (done) continue;
            }
        }
        return true;
    }

    private static void computeMachineOutput(@Nonnull List<Mapping> output, @Nonnull Mapping input, String machineName, @Nonnull OperationType operationType) {
        ItemStack stackcopy = input.itemStack.func_77946_l();
        stackcopy.field_77994_a = 1;
        MachineRecipeInput mri = new MachineRecipeInput(0, stackcopy);
        List recipes = MachineRecipeRegistry.instance.getRecipesForInput(machineName, mri);
        for (IMachineRecipe recipe : recipes) {
            IMachineRecipe.ResultStack[] completedResult;
            for (IMachineRecipe.ResultStack resultStack : completedResult = recipe.getCompletedResult(0.0f, new MachineRecipeInput[]{mri})) {
                if (resultStack.item == null) continue;
                output.add(new Mapping(operationType, resultStack.item.func_77946_l(), recipe.getEnergyRequired(new MachineRecipeInput[]{mri}), input.position, input.itemStack, 1));
            }
        }
    }

    private void computeCrafterOutput(@Nonnull List<Mapping> output, @Nonnull Mapping input) {
        int i;
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i2 = 0; i2 < 9; ++i2) {
            inv.func_70299_a(i2, input.itemStack);
        }
        ItemStack crafted = CraftingManager.func_77594_a().func_82787_a(inv, this.field_145850_b);
        if (crafted != null) {
            output.add(new Mapping(OperationType.CRAFTING, crafted.func_77946_l(), crazypants.enderio.config.Config.crafterRfPerCraft, input.position, input.itemStack, 9));
        }
        for (i = 0; i < 9; ++i) {
            inv.func_70299_a(i, null);
        }
        inv.func_70299_a(0, input.itemStack);
        inv.func_70299_a(1, input.itemStack);
        inv.func_70299_a(3, input.itemStack);
        inv.func_70299_a(4, input.itemStack);
        crafted = CraftingManager.func_77594_a().func_82787_a(inv, this.field_145850_b);
        if (crafted != null) {
            output.add(new Mapping(OperationType.CRAFTING, crafted.func_77946_l(), crazypants.enderio.config.Config.crafterRfPerCraft, input.position, input.itemStack, 4));
        }
        for (i = 0; i < 9; ++i) {
            inv.func_70299_a(i, null);
        }
        inv.func_70299_a(0, input.itemStack);
        crafted = CraftingManager.func_77594_a().func_82787_a(inv, this.field_145850_b);
        if (crafted != null) {
            output.add(new Mapping(OperationType.CRAFTING, crafted.func_77946_l(), crazypants.enderio.config.Config.crafterRfPerCraft, input.position, input.itemStack, 1));
        }
        for (i = 0; i < 6; ++i) {
            inv.func_70299_a(i, input.itemStack);
        }
        for (i = 6; i < 9; ++i) {
            inv.func_70299_a(i, null);
        }
        crafted = CraftingManager.func_77594_a().func_82787_a(inv, this.field_145850_b);
        if (crafted != null) {
            output.add(new Mapping(OperationType.CRAFTING, crafted.func_77946_l(), crazypants.enderio.config.Config.crafterRfPerCraft, input.position, input.itemStack, 4));
        }
    }

    private int applyDiscounts(int RFcost, @Nonnull OperationType operationType) {
        int cost = RFcost;
        switch (operationType) {
            case CRAFTING: {
                cost -= cost * Config.cobbleWorksRfDiscountForCrafting.getInt() / 100;
                break;
            }
            case CRUSHING: {
                cost -= cost * Config.cobbleWorksRfDiscountForCrushing.getInt() / 100;
                break;
            }
            case SMELTING: {
                cost -= cost * Config.cobbleWorksRfDiscountForSmelting.getInt() / 100;
                break;
            }
        }
        switch (this.getCapacitorType()) {
            case ENDER_CAPACITOR: {
                cost -= cost * Config.cobbleWorksRfDiscountPerUpgrade.getInt() / 100;
            }
            case ACTIVATED_CAPACITOR: {
                cost -= cost * Config.cobbleWorksRfDiscountPerUpgrade.getInt() / 100;
            }
        }
        if (cost < 0) {
            cost = 0;
        }
        return cost;
    }

    private boolean reCraft() {
        if (this.capTickLimit < this.getCapacitor().getMaxEnergyExtracted()) {
            this.capTickLimit += this.getCapacitor().getMaxEnergyExtracted();
        }
        boolean reSync = false;
        this.activeWorks = 0;
        for (int i = this.outputMapping.length - 1; i >= 0; --i) {
            Mapping mapping = this.outputMapping[i];
            if (mapping == null) continue;
            ItemStack slot = this.outputSlot(mapping.position);
            if (slot == null) {
                slot = mapping.itemStack.func_77946_l();
                slot.field_77994_a = 0;
            }
            if (!mapping.itemStack.func_77969_a(slot)) continue;
            boolean goodToGo = true;
            ItemStack parentStack = null;
            if (!(mapping.parent < 0 || (parentStack = this.outputSlot(mapping.parent)) != null && parentStack.field_77994_a >= mapping.inputAmount && parentStack.func_77969_a(mapping.inputItemStack))) {
                goodToGo = false;
            }
            boolean parentChanged = false;
            boolean slotChanged = false;
            while (goodToGo && slot.field_77994_a < slot.func_77976_d() && slot.field_77994_a + mapping.itemStack.field_77994_a <= slot.func_77976_d()) {
                if (this.usePower(this.applyDiscounts(mapping.costInRF, mapping.operationType))) {
                    slot.field_77994_a += mapping.itemStack.field_77994_a;
                    slotChanged = true;
                    this.activeWorks |= 1 << i;
                    if (parentStack == null) continue;
                    parentStack.field_77994_a -= mapping.inputAmount;
                    parentChanged = true;
                    if (parentStack.field_77994_a >= mapping.inputAmount) continue;
                    goodToGo = false;
                    if (parentStack.field_77994_a > 0) continue;
                    parentStack = null;
                    continue;
                }
                goodToGo = false;
            }
            if (parentChanged) {
                this.outputSlot(mapping.parent, parentStack);
                reSync = true;
            }
            if (!slotChanged) continue;
            if (slot.field_77994_a > 0) {
                this.outputSlot(mapping.position, slot);
            } else {
                this.outputSlot(mapping.position, null);
            }
            reSync = true;
        }
        return reSync;
    }

    public boolean usePower(int wantToUse) {
        if (EnderIOAddons.mode24) {
            return true;
        }
        if (wantToUse > this.getEnergyStored() || wantToUse > this.capTickLimit && this.capTickLimit < this.getCapacitor().getMaxEnergyExtracted()) {
            return false;
        }
        this.setEnergyStored(this.getEnergyStored() - wantToUse);
        this.capTickLimit -= wantToUse;
        return true;
    }

    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(crazypants.enderio.config.Config.powerConduitTierOneRF, 100000, crazypants.enderio.config.Config.powerConduitTierOneRF));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(crazypants.enderio.config.Config.powerConduitTierTwoRF, 200000, crazypants.enderio.config.Config.powerConduitTierTwoRF));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(crazypants.enderio.config.Config.powerConduitTierThreeRF, 500000, crazypants.enderio.config.Config.powerConduitTierThreeRF));
            }
        }
        this.inputsChanged = true;
    }

    public void func_70299_a(int slot, ItemStack contents) {
        if (this.slotDefinition.isInputSlot(slot) && TileCobbleworks.differs(contents, this.inventory[slot])) {
            this.inputsChanged = true;
        }
        super.func_70299_a(slot, contents);
    }

    private static boolean differs(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        return a.func_77973_b() != b.func_77973_b();
    }

    public ItemStack func_70298_a(int fromSlot, int amount) {
        if (this.slotDefinition.isInputSlot(fromSlot)) {
            this.inputsChanged = true;
        }
        return super.func_70298_a(fromSlot, amount);
    }

    @Override
    public boolean hasTank(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        return true;
    }

    @Override
    public Fluid getTankFluid(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        switch (tankSlot) {
            case FRONT_LEFT: 
            case BACK_RIGHT: {
                return FluidRegistry.LAVA;
            }
            case FRONT_RIGHT: 
            case BACK_LEFT: {
                return FluidRegistry.WATER;
            }
        }
        return null;
    }

    @Override
    public boolean hasController() {
        return true;
    }

    @Override
    public String getControllerModelName() {
        return BlockCobbleworks.blockCobbleworks.getControllerModelName();
    }

    @Override
    public boolean renderSlot(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        if (tankSlot != IFrameworkMachine.TankSlot.FRONT_LEFT) {
            ItemStack stack = this.inputSlot(tankSlot.ordinal());
            return stack != null && stack.func_77973_b() != null;
        }
        return false;
    }

    @Override
    public IIcon getSlotIcon(@Nonnull IFrameworkMachine.TankSlot tankSlot, int side) {
        ItemStack stack = this.inputSlot(tankSlot.ordinal());
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == blockCrafter.func_77973_b()) {
            return EnderIO.blockCrafter.func_149691_a(side, 0);
        }
        if (stack.func_77973_b() == blockAlloySmelter.func_77973_b()) {
            return EnderIO.blockAlloySmelter.func_149691_a(side, 0);
        }
        if (stack.func_77973_b() == blockSagMill.func_77973_b()) {
            return EnderIO.blockCrusher.func_149691_a(side, 0);
        }
        return null;
    }

    public String getSoundName() {
        return "machine.cobbleworks";
    }

    private static class Mapping {
        @Nonnull
        final OperationType operationType;
        @Nonnull
        final ItemStack itemStack;
        final int costInRF;
        final int parent;
        int position = 0;
        final int inputAmount;
        @Nullable
        final ItemStack inputItemStack;

        public Mapping(@Nonnull OperationType operationType, ItemStack itemStack, int costInRF, int parent, @Nullable ItemStack inputItemStack, int inputAmount) {
            if (itemStack == null) {
                throw new NullPointerException("Unexpected NULL ItemStack");
            }
            this.operationType = operationType;
            this.itemStack = itemStack;
            this.costInRF = costInRF;
            this.parent = parent;
            this.inputItemStack = inputItemStack;
            this.inputAmount = inputAmount;
        }
    }

    private static enum OperationType {
        NONE,
        CRAFTING,
        SMELTING,
        CRUSHING;

    }
}

