/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.afarm.module;

import com.InfinityRaider.AgriCraft.api.v1.ISeedStats;
import com.enderio.core.common.util.ItemUtil;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.afarm.Notif;
import info.loenwind.enderioaddons.machine.afarm.SlotDefinitionAfarm;
import info.loenwind.enderioaddons.machine.afarm.WorkTile;
import info.loenwind.enderioaddons.machine.afarm.module.IAfarmControlModule;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SeedAnalyzerModule
implements IAfarmControlModule {
    private static final String growth = "growth";
    private static final String gain = "gain";
    private static final String strength = "strength";
    private static final String analyzed = "analyzed";

    @Override
    public void doWork(WorkTile workTile) {
        SlotDefinitionAfarm slotDef = (SlotDefinitionAfarm)workTile.farm.getSlotDefinition();
        boolean foundSeeds = false;
        for (int slot = slotDef.getMinSlot(SlotDefinitionAfarm.SLOT.SEED); slot <= slotDef.getMaxSlot(SlotDefinitionAfarm.SLOT.SEED); ++slot) {
            ItemStack stack = workTile.farm.func_70301_a(slot);
            if (stack == null || stack.func_77973_b() == null) continue;
            workTile.farm.notifications.remove((Object)Notif.NO_SEEDS);
            foundSeeds = true;
            ISeedStats seedStats = workTile.agricraft.getSeedStats(stack);
            if (seedStats == null || SeedAnalyzerModule.isAnalyzed(stack)) continue;
            if (workTile.farm.canUsePower(Config.farmRFperAnalyzing.getInt())) {
                workTile.farm.notifications.remove((Object)Notif.NO_POWER);
                workTile.farm.usePower(Config.farmRFperAnalyzing.getInt());
                SeedAnalyzerModule.analyze(stack);
                SeedAnalyzerModule.reStack(workTile, slotDef, slot, stack);
                workTile.farm.func_70296_d();
                return;
            }
            workTile.farm.notifications.add(Notif.NO_POWER);
            return;
        }
        if (!foundSeeds) {
            workTile.farm.notifications.add(Notif.NO_SEEDS);
        }
    }

    private static void reStack(WorkTile workTile, SlotDefinitionAfarm slotDef, int slot, ItemStack stack) {
        for (int slot2 = slotDef.getMinSlot(SlotDefinitionAfarm.SLOT.SEED); slot2 <= slotDef.getMaxSlot(SlotDefinitionAfarm.SLOT.SEED); ++slot2) {
            ItemStack stack2;
            if (slot2 == slot || !ItemUtil.areStackMergable((ItemStack)stack, (ItemStack)(stack2 = workTile.farm.func_70301_a(slot2))) || stack2.field_77994_a >= stack2.func_77976_d()) continue;
            int free = stack2.func_77976_d() - stack2.field_77994_a;
            if (free >= stack.field_77994_a) {
                stack2.field_77994_a += stack.field_77994_a;
                stack.field_77994_a = 0;
                workTile.farm.func_70299_a(slot, null);
                return;
            }
            stack2.field_77994_a = stack2.func_77976_d();
            stack.field_77994_a -= free;
        }
    }

    private static void analyze(ItemStack specimen) {
        NBTTagCompound tag;
        if (specimen.func_77942_o()) {
            tag = specimen.func_77978_p();
            if (tag.func_74764_b(growth) && tag.func_74764_b(gain) && tag.func_74764_b(strength)) {
                tag.func_74757_a(analyzed, true);
                return;
            }
        } else {
            tag = new NBTTagCompound();
            specimen.func_77982_d(tag);
        }
        tag.func_74777_a(growth, (short)1);
        tag.func_74777_a(gain, (short)1);
        tag.func_74777_a(strength, (short)1);
        tag.func_74757_a(analyzed, true);
    }

    public static boolean isAnalyzed(ItemStack specimen) {
        NBTTagCompound tag;
        if (specimen.func_77942_o() && (tag = specimen.func_77978_p()).func_74764_b(analyzed)) {
            return tag.func_74767_n(analyzed);
        }
        return false;
    }

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public boolean isCompatibleWith(IAfarmControlModule other) {
        return !(other instanceof SeedAnalyzerModule);
    }

    static boolean isSameSeed(ItemStack seed1, ItemStack seed2) {
        if (seed1.func_77973_b() == seed2.func_77973_b()) {
            NBTBase o2;
            NBTBase o1;
            if (seed1.func_77960_j() != Short.MAX_VALUE && seed2.func_77960_j() != Short.MAX_VALUE && seed1.func_77960_j() != seed2.func_77960_j()) {
                return false;
            }
            if (seed1.field_77990_d == seed2.field_77990_d || seed1.field_77990_d == null || seed2.field_77990_d == null || ItemStack.func_77970_a((ItemStack)seed1, (ItemStack)seed2)) {
                return true;
            }
            for (Object key : seed1.field_77990_d.func_150296_c()) {
                if (growth.equals(key) || gain.equals(key) || strength.equals(key) || analyzed.equals(key)) continue;
                o1 = seed1.field_77990_d.func_74781_a((String)key);
                if (o1 == null != ((o2 = seed2.field_77990_d.func_74781_a((String)key)) == null)) {
                    return false;
                }
                if (o1 == null || o1.equals(o2)) continue;
                return false;
            }
            for (Object key : seed2.field_77990_d.func_150296_c()) {
                if (growth.equals(key) || gain.equals(key) || strength.equals(key) || analyzed.equals(key)) continue;
                o1 = seed1.field_77990_d.func_74781_a((String)key);
                if (o1 == null != ((o2 = seed2.field_77990_d.func_74781_a((String)key)) == null)) {
                    return false;
                }
                if (o1 == null || o1.equals(o2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

