/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.afarm.module;

import com.InfinityRaider.AgriCraft.api.v1.SeedRequirementStatus;
import info.loenwind.enderioaddons.common.Log;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.afarm.Notif;
import info.loenwind.enderioaddons.machine.afarm.SlotDefinitionAfarm;
import info.loenwind.enderioaddons.machine.afarm.WorkTile;
import info.loenwind.enderioaddons.machine.afarm.module.IAfarmControlModule;
import info.loenwind.enderioaddons.machine.afarm.module.SeedAnalyzerModule;
import net.minecraft.item.ItemStack;

public class PlantModule
implements IAfarmControlModule {
    @Override
    public void doWork(WorkTile workTile) {
        if (workTile.allowPlanting && !workTile.doPlanting && workTile.isEmpty) {
            SlotDefinitionAfarm slotDef = (SlotDefinitionAfarm)workTile.farm.getSlotDefinition();
            ItemStack template = workTile.seedSlot != -1 ? workTile.farm.func_70301_a(workTile.seedSlot + slotDef.getMinSlot(SlotDefinitionAfarm.SLOT.SEED_GHOST)) : null;
            boolean foundSeeds = false;
            for (int slot = slotDef.getMinSlot(SlotDefinitionAfarm.SLOT.SEED); slot <= slotDef.getMaxSlot(SlotDefinitionAfarm.SLOT.SEED); ++slot) {
                ItemStack stack = workTile.farm.func_70301_a(slot);
                if (stack == null || stack.func_77973_b() == null) continue;
                workTile.farm.notifications.remove((Object)Notif.NO_SEEDS);
                foundSeeds = true;
                if (template != null && !SeedAnalyzerModule.isSameSeed(template, stack)) continue;
                SeedRequirementStatus status = workTile.agricraft.canApplySeeds(workTile.farm.func_145831_w(), workTile.bc.x, workTile.bc.y, workTile.bc.z, stack);
                if (status == SeedRequirementStatus.NEEDS_TILLING) {
                    workTile.doTill = true;
                    return;
                }
                if (status == SeedRequirementStatus.CAN_APPLY) {
                    workTile.doPlanting = true;
                    workTile.seedStorageSlot = slot;
                    return;
                }
                if (!Config.farmDebugLoggingEnabled.getBoolean()) continue;
                Log.info(status + " when trying " + stack + " at " + workTile.bc);
            }
            if (!foundSeeds) {
                workTile.farm.notifications.add(Notif.NO_SEEDS);
            }
        }
    }

    @Override
    public int getPriority() {
        return 40;
    }

    @Override
    public boolean isCompatibleWith(IAfarmControlModule other) {
        return !(other instanceof PlantModule);
    }
}

