/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.afarm;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import info.loenwind.enderioaddons.common.Profiler;
import info.loenwind.enderioaddons.machine.afarm.BlockAfarm;
import info.loenwind.enderioaddons.machine.afarm.TileAfarm;
import info.loenwind.enderioaddons.render.CachableRenderStatement;
import info.loenwind.enderioaddons.render.CacheRenderer;
import info.loenwind.enderioaddons.render.FaceRenderer;
import info.loenwind.enderioaddons.render.OverlayRenderer;
import info.loenwind.enderioaddons.render.RenderingContext;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RendererAfarm
implements ISimpleBlockRenderingHandler {
    private static final VertXForm xform_main = new VertXForm(0.85, 0.5, true, true, true);
    private static final BoundingBox bb_body = BoundingBox.UNIT_CUBE;
    private static final float hatThickness = 0.15f;
    private static final BoundingBox bb_hat = BoundingBox.UNIT_CUBE.scale(1.0f, 0.15f, 1.0f).translate(0.0f, 0.375f, 0.0f);
    private static final BoundingBox bb_hati = new BoundingBox((double)RendererAfarm.bb_hat.minX, (double)RendererAfarm.bb_hat.minY, (double)RendererAfarm.bb_hat.minZ, (double)RendererAfarm.bb_hat.maxX, (double)RendererAfarm.bb_hat.maxY - 0.05, (double)RendererAfarm.bb_hat.maxZ);
    private static final float scale_cross = 0.7f;
    private static final float width_cross = 0.5f;
    private static final float trans_cross = 0.15f;
    private static final VertXForm xform_cross1 = new VertXForm(0.5, 0.5, true, false, false);
    private static final BoundingBox bb_cross1 = BoundingBox.UNIT_CUBE.scale(0.5f, 0.7f, 1.0f).translate(0.0f, -0.15f, 0.0f);
    private static final float scale_light = RendererAfarm.bb_hat.minY - RendererAfarm.bb_cross1.maxY;
    private static final float trans_light = (1.0f - scale_light) / 2.0f;
    private static final BoundingBox bb_light1 = BoundingBox.UNIT_CUBE.scale(0.5f, scale_light, 1.0f).translate(0.0f, -trans_light + RendererAfarm.bb_cross1.maxY, 0.0f);
    private static final VertXForm xform_cross2 = new VertXForm(0.5, 0.5, false, true, false);
    private static final BoundingBox bb_cross2 = BoundingBox.UNIT_CUBE.scale(1.0f, 0.7f, 0.5f).translate(0.0f, -0.15f, 0.0f);
    private static final BoundingBox bb_light2 = BoundingBox.UNIT_CUBE.scale(1.0f, scale_light, 0.5f).translate(0.0f, -trans_light + RendererAfarm.bb_cross1.maxY, 0.0f);
    private static List<CachableRenderStatement> csr_online;
    private static List<CachableRenderStatement> csr_offline;
    private static boolean reloadHandlerRegistered;

    public RendererAfarm() {
        if (!reloadHandlerRegistered) {
            RenderUtil.registerReloadListener((IResourceManagerReloadListener)new textReload());
            reloadHandlerRegistered = true;
        }
    }

    private static void setup() {
        if (csr_online == null || csr_offline == null) {
            long id = Profiler.client.start_always();
            IIcon[] icons = RenderUtil.getBlockTextures((Block)BlockAfarm.blockAfarm, (int)0);
            CacheRenderer r = new CacheRenderer().setLighting(true).setBrightnessPerSide(FaceRenderer.stdBrightness);
            r.setBB(bb_body).setXform(xform_main).setBrightness(1.0f, 0.7f).addSkirt(icons, false);
            r.setBrightness(1.0f, 1.0f).addSide(ForgeDirection.UP, icons, false).addSide(ForgeDirection.DOWN, icons, false);
            r.setBB(bb_hat).setXform(xform_main).addSkirt(icons, false);
            r.setBB(bb_hati).setXform(xform_main).setBrightness(0.0f, 1.0f).addSkirt(icons, true);
            r.setBB(bb_cross1).setXform(xform_cross1).setBrightness(1.0f, 0.8f).addSkirt(icons, false);
            r.setBB(bb_cross2).setXform(xform_cross2).setBrightness(1.0f, 0.8f).addSkirt(icons, false);
            CacheRenderer r2 = r.copy();
            r2.setBB(bb_cross1).setXform(xform_cross1).setBrightness(0.8f, 0.8f).addSide(ForgeDirection.UP, icons, false);
            r2.setBB(bb_cross2).setXform(xform_cross2).setBrightness(0.8f, 0.8f).addSide(ForgeDirection.UP, icons, false);
            r.setLighting(0xF000F0, 240.0f, 240.0f).setBrightnessPerSide(null).setBrightness(1.0f, 1.0f);
            r.setBB(bb_light1).setXform(xform_cross1).addSkirt(BlockAfarm.farmlight, false);
            r.setBB(bb_light2).setXform(xform_cross2).addSkirt(BlockAfarm.farmlight, false);
            csr_online = r.finishDrawing();
            csr_offline = r2.finishDrawing();
            Profiler.client.stop(id, "farm setup");
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tileEntity;
        RendererAfarm.setup();
        boolean active = false;
        TileAfarm te = null;
        if (world != null && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileAfarm) {
            te = (TileAfarm)tileEntity;
            active = te.isActive();
        }
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        if (renderer.field_147840_d != null) {
            FaceRenderer.setLightingReference(world, (Block)BlockAfarm.blockAfarm, x, y, z);
            FaceRenderer.renderCube(bb_body, renderer.field_147840_d, (VertexTransform)xform_main, null, false);
            FaceRenderer.renderCube(bb_cross1, renderer.field_147840_d, (VertexTransform)xform_cross1, null, false);
            FaceRenderer.renderCube(bb_cross2, renderer.field_147840_d, (VertexTransform)xform_cross2, null, false);
            FaceRenderer.clearLightingReference();
        } else {
            OverlayRenderer.renderOverlays(world, x, y, z, null, null, BlockAfarm.blockAfarm, te);
            new RenderingContext(world, new BlockCoord(x, y, z)).execute(active ? csr_online : csr_offline, "farm world");
        }
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    public static void renderBlock(boolean active) {
        RendererAfarm.setup();
        new RenderingContext().execute(active ? csr_online : csr_offline, "farm item");
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockAfarm.blockAfarm.func_149645_b();
    }

    static {
        reloadHandlerRegistered = false;
    }

    private class textReload
    implements IResourceManagerReloadListener {
        private textReload() {
        }

        public void func_110549_a(IResourceManager p_110549_1_) {
            csr_online = (csr_offline = null);
        }
    }

    private static class VertXForm
    implements VertexTransform {
        private final double cutoff;
        private final double pinch;
        private final boolean pinchX;
        private final boolean pinchZ;
        private final boolean scaleY;

        public VertXForm(double cutoff, double pinch, boolean pinchX, boolean pinchZ, boolean scaleY) {
            this.cutoff = cutoff;
            this.pinch = pinch;
            this.pinchX = pinchX;
            this.pinchZ = pinchZ;
            this.scaleY = scaleY;
        }

        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(Vector3d vec) {
            if (vec.y > this.cutoff) {
                double pinchi;
                double d = pinchi = this.scaleY ? this.pinch : 1.0 - this.pinch * vec.y;
                if (this.pinchX) {
                    vec.x -= 0.5;
                    vec.x *= pinchi;
                    vec.x += 0.5;
                }
                if (this.pinchZ) {
                    vec.z -= 0.5;
                    vec.z *= pinchi;
                    vec.z += 0.5;
                }
            }
            if (this.scaleY || vec.y > this.cutoff) {
                double scale = 0.8;
                vec.y -= 0.5;
                vec.y *= scale;
                vec.y += 0.5 * scale;
            }
        }

        public void applyToNormal(Vector3f vec) {
        }
    }
}

