/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.fluid;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import crazypants.enderio.fluid.BlockFluidEio;
import crazypants.enderio.fluid.BucketHandler;
import crazypants.enderio.fluid.ItemBucketEio;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.baseclass.BlockFluidEioA;
import info.loenwind.enderioaddons.common.NullHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;

public enum Fluids {
    BRINE1("brine1", 1250, 3000, 7, false, null),
    BRINE2("brine2", 1500, 5000, 4, false, null),
    BRINE3("brine3", 1750, 7000, 2, false, null),
    BRINE4("brine4", 2000, 9000, 1, false, null),
    MILK("milk", 1050, 2500, 6, true, Items.field_151117_aB);

    @Nonnull
    private final String name;
    private final int density;
    private final int viscosity;
    private final int quanta;
    private final boolean allowSubstitutes;
    private Fluid fluid;
    private BlockFluidEio block;
    private Item bucket;

    private Fluids(String name, int density, int viscosity, int quanta, boolean allowSubstitutes, Item bucket) {
        this.name = name;
        this.density = density;
        this.viscosity = viscosity;
        this.quanta = quanta;
        this.allowSubstitutes = allowSubstitutes;
        this.bucket = bucket;
    }

    public static void init(FMLPreInitializationEvent event) {
        for (Fluids fluid : Fluids.values()) {
            Fluid newFluid = new Fluid(fluid.name);
            newFluid.setDensity(fluid.density).setViscosity(fluid.viscosity);
            if (FluidRegistry.registerFluid((Fluid)newFluid)) {
                fluid.fluid = newFluid;
            } else if (fluid.allowSubstitutes) {
                fluid.fluid = FluidRegistry.getFluid((String)fluid.name);
            } else {
                throw new RuntimeException("Failed to register fluid '" + fluid.name + "', there already is a conflicting fluid with the same name.");
            }
            fluid.block = BlockFluidEioA.create(newFluid, NullHelper.notnullF(Material.field_151586_h, "Material.water"));
            fluid.block.setQuantaPerBlock(fluid.quanta);
            if (fluid.bucket == null) {
                ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid.fluid, 1000), (ItemStack)new ItemStack(Items.field_151133_ar));
                if (filled == null) {
                    fluid.bucket = ItemBucketEio.create((Fluid)newFluid);
                    fluid.bucket.func_111206_d(EnderIOAddons.DOMAIN + ":" + "bucket" + StringUtils.capitalize((String)fluid.name));
                    continue;
                }
                fluid.bucket = filled.func_77973_b();
                continue;
            }
            FluidContainerRegistry.registerFluidContainer((Fluid)fluid.fluid, (ItemStack)new ItemStack(fluid.bucket), (ItemStack)new ItemStack(Items.field_151133_ar));
            BucketHandler.instance.registerFluid((Block)fluid.getBlock(), fluid.bucket);
        }
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public BlockFluidEio getBlock() {
        return this.block;
    }

    public Item getBucket() {
        return this.bucket;
    }
}

