/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.config;

import info.loenwind.enderioaddons.common.Log;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.config.WeightedItemStack;
import info.loenwind.enderioaddons.machine.waterworks.engine.MinecraftItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ItemHelper {
    private static final Pattern p = Pattern.compile("^\\s*([^:\\s]+):([^@\\s]+)(?:@(-?\\d+))?\\s*(?:=\\s*(\\d+)\\s*)?$");
    private static final Map<Config, Pair<String, List<WeightedItemStack>>> cache = new HashMap<Config, Pair<String, List<WeightedItemStack>>>();

    public static List<WeightedItemStack> readWeightedList(String input) {
        if (input == null || input.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WeightedItemStack> result = new ArrayList<WeightedItemStack>();
        for (String item : input.split(",|;")) {
            if (item == null || item.trim().isEmpty()) continue;
            Matcher matcher = p.matcher(item);
            if (matcher.matches()) {
                String modid = matcher.group(1);
                String itemid = matcher.group(2);
                String metaS = matcher.group(3);
                String weightS = matcher.group(4);
                try {
                    int meta;
                    if (modid == null || itemid == null) {
                        throw new NumberFormatException();
                    }
                    int n = meta = metaS == null ? 0 : Integer.valueOf(metaS);
                    if (meta == -1) {
                        meta = Short.MAX_VALUE;
                    } else if (meta < 0 || meta >= 4096) {
                        throw new NumberFormatException();
                    }
                    int weight = weightS == null ? 1 : Integer.valueOf(weightS);
                    MinecraftItem mci = new MinecraftItem(modid, itemid, meta);
                    ItemStack stack = mci.getItemStack();
                    if (stack != null) {
                        result.add(new WeightedItemStack(weight, stack));
                        continue;
                    }
                    Log.info("Could not find item '" + modid + ":" + itemid + "@" + meta + "', ignoring");
                }
                catch (NumberFormatException e) {
                    Log.error("Error while reading config. '" + item + "' is not a valid item specifier");
                }
                continue;
            }
            Log.error("Error while reading config. '" + item + "' is not a valid item specifier");
        }
        if (result.isEmpty()) {
            Log.error("Error while reading config. '" + input + "' gave zero valid items.");
        }
        return result;
    }

    public static List<WeightedItemStack> readWeightedList(Config config) {
        Pair<String, List<WeightedItemStack>> pair;
        if (cache.containsKey((Object)config) && ((String)(pair = cache.get((Object)config)).getLeft()).equals(config.getString())) {
            return (List)pair.getRight();
        }
        List<WeightedItemStack> result = ItemHelper.readWeightedList(config.getString());
        cache.put(config, (Pair<String, List<WeightedItemStack>>)Pair.of((Object)config.getString(), result));
        return result;
    }

    public static List<ItemStack> readList(Config config) {
        List<WeightedItemStack> weightedList = ItemHelper.readWeightedList(config);
        if (weightedList == null) {
            return null;
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (WeightedItemStack weightedItemStack : weightedList) {
            result.add(weightedItemStack.getStack());
        }
        return result;
    }
}

