/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import java.lang.reflect.Type;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class WrappedStackSerializer
implements JsonSerializer<WrappedStack>,
JsonDeserializer<WrappedStack> {
    private static final String TYPE_ITEM_STACK = "itemstack";
    private static final String TYPE_ORE_STACK = "orestack";
    private static final String TYPE_FLUID_STACK = "fluidstack";

    public WrappedStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            WrappedStack wrappedStack = null;
            if (jsonObject.has(TYPE_ITEM_STACK)) {
                try {
                    ItemStack itemStack = (ItemStack)context.deserialize(jsonObject.get(TYPE_ITEM_STACK), ItemStack.class);
                    wrappedStack = WrappedStack.wrap(itemStack);
                }
                catch (JsonParseException itemStack) {}
            } else if (jsonObject.has(TYPE_ORE_STACK)) {
                try {
                    OreStack oreStack = (OreStack)context.deserialize(jsonObject.get(TYPE_ORE_STACK), OreStack.class);
                    wrappedStack = WrappedStack.wrap(oreStack);
                }
                catch (JsonParseException oreStack) {}
            } else if (jsonObject.has(TYPE_FLUID_STACK)) {
                try {
                    FluidStack fluidStack = (FluidStack)context.deserialize(jsonObject.get(TYPE_FLUID_STACK), FluidStack.class);
                    wrappedStack = WrappedStack.wrap(fluidStack);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            if (wrappedStack != null) {
                return wrappedStack;
            }
        }
        return null;
    }

    public JsonElement serialize(WrappedStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        if (src != null && src.getWrappedObject() != null) {
            jsonObject.add(src.getWrappedObject().getClass().getSimpleName().toLowerCase(), context.serialize(src.getWrappedObject()));
            return jsonObject;
        }
        return null;
    }
}

