/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackSerializer
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    private static final String NAME = "name";
    private static final String META_VALUE = "metaValue";
    private static final String TAG_COMPOUND = "tagCompound";

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            Item item;
            JsonObject jsonObject = json.getAsJsonObject();
            String name = null;
            int metaValue = 0;
            NBTTagCompound tagCompound = null;
            if (jsonObject.has(NAME) && jsonObject.get(NAME).isJsonPrimitive()) {
                name = jsonObject.getAsJsonPrimitive(NAME).getAsString();
            }
            if (jsonObject.has(META_VALUE) && jsonObject.get(META_VALUE).isJsonPrimitive()) {
                try {
                    metaValue = jsonObject.getAsJsonPrimitive(META_VALUE).getAsInt();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (jsonObject.has(TAG_COMPOUND) && jsonObject.get(TAG_COMPOUND).isJsonPrimitive()) {
                try {
                    NBTBase nbtBase = JsonToNBT.func_150315_a((String)jsonObject.getAsJsonPrimitive(TAG_COMPOUND).getAsString());
                    if (nbtBase instanceof NBTTagCompound) {
                        tagCompound = (NBTTagCompound)nbtBase;
                    }
                }
                catch (NBTException nbtBase) {
                    // empty catch block
                }
            }
            if (name != null && (item = (Item)Item.field_150901_e.func_82594_a(name)) != null) {
                ItemStack itemStack = new ItemStack((Item)Item.field_150901_e.func_82594_a(name), 1, metaValue);
                if (tagCompound != null) {
                    itemStack.func_77982_d(tagCompound);
                }
                return itemStack;
            }
        }
        return null;
    }

    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        if (src != null && src.func_77973_b() != null) {
            JsonObject jsonObject = new JsonObject();
            if (Item.field_150901_e.func_148750_c((Object)src.func_77973_b()) == null) {
                return JsonNull.INSTANCE;
            }
            jsonObject.addProperty(NAME, Item.field_150901_e.func_148750_c((Object)src.func_77973_b()));
            if (src.func_77960_j() != 0) {
                jsonObject.addProperty(META_VALUE, (Number)src.func_77960_j());
            }
            if (src.func_77978_p() != null) {
                jsonObject.addProperty(TAG_COMPOUND, src.func_77978_p().toString());
            }
            return jsonObject;
        }
        return JsonNull.INSTANCE;
    }
}

