/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.knowledge.PlayerKnowledge;
import com.pahimar.ee3.reference.Reference;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.serialize.EnergyValueMapSerializer;
import com.pahimar.ee3.util.serialize.FluidStackSerializer;
import com.pahimar.ee3.util.serialize.ItemStackSerializer;
import com.pahimar.ee3.util.serialize.OreStackSerializer;
import com.pahimar.ee3.util.serialize.PlayerKnowledgeSerializer;
import com.pahimar.ee3.util.serialize.WrappedStackSerializer;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SerializationHelper {
    public static final Type ENERGY_VALUE_MAP_TYPE = new TypeToken<Map<WrappedStack, EnergyValue>>(){}.getType();
    public static final Type WRAPPED_STACK_SET_TYPE = new TypeToken<Set<WrappedStack>>(){}.getType();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer()).registerTypeAdapter(OreStack.class, (Object)new OreStackSerializer()).registerTypeAdapter(FluidStack.class, (Object)new FluidStackSerializer()).registerTypeAdapter(WrappedStack.class, (Object)new WrappedStackSerializer()).registerTypeAdapter(PlayerKnowledge.class, (Object)new PlayerKnowledgeSerializer()).registerTypeAdapter(ENERGY_VALUE_MAP_TYPE, (Object)new EnergyValueMapSerializer()).create();
    private static File instanceDataDirectory;
    private static File instancePlayerDataDirectory;

    @Deprecated
    public static File getInstanceDataDirectory() {
        return instanceDataDirectory;
    }

    public static void initModDataDirectories() {
        instanceDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "data" + File.separator + Reference.LOWERCASE_MOD_ID);
        instanceDataDirectory.mkdirs();
        instancePlayerDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "playerdata" + File.separator + Reference.LOWERCASE_MOD_ID);
        instancePlayerDataDirectory.mkdirs();
    }

    public static Set<WrappedStack> readSetFromFile(File file) {
        TreeSet<WrappedStack> wrappedStackSet = new TreeSet();
        try {
            wrappedStackSet = (Set)GSON.fromJson(SerializationHelper.readJsonFile(file), WRAPPED_STACK_SET_TYPE);
        }
        catch (JsonParseException exception) {
            LogHelper.error("Unable to parse contents from file '{}'", file.getAbsoluteFile());
        }
        catch (FileNotFoundException e) {
            LogHelper.warn("Unable to find file '{}'", file.getAbsoluteFile());
        }
        return wrappedStackSet;
    }

    public static void writeSetToFile(Set<WrappedStack> wrappedStackSet, File file) {
        SerializationHelper.writeJsonFile(file, GSON.toJson(wrappedStackSet));
    }

    public static Map<WrappedStack, EnergyValue> readMapFromFile(File file) throws FileNotFoundException {
        Map<WrappedStack, EnergyValue> valueMap = new TreeMap<WrappedStack, EnergyValue>();
        try {
            valueMap = (Map)GSON.fromJson(SerializationHelper.readJsonFile(file), ENERGY_VALUE_MAP_TYPE);
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return valueMap;
    }

    public static void writeMapToFile(Map<WrappedStack, EnergyValue> valueMap, File file) {
        SerializationHelper.writeJsonFile(file, GSON.toJson(valueMap, ENERGY_VALUE_MAP_TYPE));
    }

    public static String readJsonFile(File file) throws FileNotFoundException {
        StringBuilder jsonStringBuilder = new StringBuilder();
        if (file != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line;
                jsonStringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    jsonStringBuilder.append(line);
                }
            }
            catch (IOException exception) {
                if (exception instanceof FileNotFoundException) {
                    throw (FileNotFoundException)exception;
                }
                exception.printStackTrace();
            }
        }
        return jsonStringBuilder.toString();
    }

    public static void writeJsonFile(File file, String fileContents) {
        if (file != null) {
            file.getParentFile().mkdirs();
            File tempFile = new File(file.getAbsolutePath() + "_tmp");
            if (tempFile.exists()) {
                tempFile.delete();
            }
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tempFile));){
                bufferedWriter.write(fileContents);
                bufferedWriter.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            if (file.exists()) {
                file.delete();
            }
            if (file.exists()) {
                LogHelper.warn("Failed to delete " + file);
            } else {
                tempFile.renameTo(file);
            }
        }
    }
}

