/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import java.util.Comparator;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidHelper {
    public static final Comparator<FluidStack> COMPARATOR = new Comparator<FluidStack>(){

        @Override
        public int compare(FluidStack fluidStack1, FluidStack fluidStack2) {
            if (fluidStack1 != null && fluidStack2 != null) {
                if (fluidStack1.getFluid() != null && fluidStack2.getFluid() != null) {
                    if (FluidRegistry.getFluidName((FluidStack)fluidStack1) != null && FluidRegistry.getFluidName((FluidStack)fluidStack2) != null) {
                        if (FluidRegistry.getFluidName((FluidStack)fluidStack1).equalsIgnoreCase(FluidRegistry.getFluidName((FluidStack)fluidStack2))) {
                            if (fluidStack1.amount == fluidStack2.amount) {
                                if (fluidStack1.tag != null && fluidStack2.tag != null) {
                                    return fluidStack1.tag.hashCode() - fluidStack2.tag.hashCode();
                                }
                                if (fluidStack1.tag != null) {
                                    return -1;
                                }
                                if (fluidStack2.tag != null) {
                                    return 1;
                                }
                                return 0;
                            }
                            return fluidStack1.amount - fluidStack2.amount;
                        }
                        return FluidRegistry.getFluidName((FluidStack)fluidStack1).compareToIgnoreCase(FluidRegistry.getFluidName((FluidStack)fluidStack2));
                    }
                    if (FluidRegistry.getFluidName((FluidStack)fluidStack1) != null) {
                        return -1;
                    }
                    if (FluidRegistry.getFluidName((FluidStack)fluidStack2) != null) {
                        return 1;
                    }
                    return 0;
                }
                if (fluidStack1.getFluid() != null) {
                    return -1;
                }
                if (fluidStack2.getFluid() != null) {
                    return 1;
                }
                return 0;
            }
            if (fluidStack1 != null) {
                return -1;
            }
            if (fluidStack2 != null) {
                return 1;
            }
            return 0;
        }
    };

    public static void registerFluids() {
        Fluid milk;
        if (!FluidRegistry.isFluidRegistered((String)"milk") && FluidRegistry.registerFluid((Fluid)(milk = new Fluid("milk").setUnlocalizedName("ee3.milk")))) {
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(milk, 1000), (ItemStack)new ItemStack(Items.field_151117_aB), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
    }

    public static int compare(FluidStack fluidStack1, FluidStack fluidStack2) {
        return COMPARATOR.compare(fluidStack1, fluidStack2);
    }

    public static String toString(FluidStack fluidStack) {
        if (fluidStack != null) {
            return String.format("%sxfluidStack.%s", fluidStack.amount, fluidStack.getFluid().getName());
        }
        return "fluidStack[null]";
    }
}

