/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.item.ItemAlchemicalDust;
import com.pahimar.ee3.item.crafting.RecipeAludel;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileEntityAludel;
import com.pahimar.ee3.recipe.AludelRecipeManager;
import com.pahimar.ee3.tileentity.TileEntityEE;
import com.pahimar.ee3.tileentity.TileEntityGlassBell;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAludel
extends TileEntityEE
implements ISidedInventory {
    public static final int INVENTORY_SIZE = 4;
    public static final int FUEL_INVENTORY_INDEX = 0;
    public static final int INPUT_INVENTORY_INDEX = 1;
    public static final int DUST_INVENTORY_INDEX = 2;
    public static final int OUTPUT_INVENTORY_INDEX = 3;
    public int deviceCookTime;
    public int fuelBurnTime;
    public int itemCookTime;
    public ItemStack outputItemStack;
    public boolean hasGlassBell = false;
    private ItemStack[] inventory = new ItemStack[4];

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == ForgeDirection.DOWN.ordinal()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 3;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 3;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityGlassBell) {
            return this.func_94041_b(slotIndex, itemStack);
        }
        return false;
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return slotIndex == 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slotIndex = tagCompound.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.deviceCookTime = nbtTagCompound.func_74762_e("deviceCookTime");
        this.fuelBurnTime = nbtTagCompound.func_74762_e("fuelBurnTime");
        this.itemCookTime = nbtTagCompound.func_74762_e("itemCookTime");
        this.hasGlassBell = nbtTagCompound.func_74767_n("hasGlassBell");
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            this.func_70299_a(slotIndex, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:aludel";
    }

    public boolean func_145818_k_() {
        return this.hasCustomName();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        switch (slotIndex) {
            case 0: {
                return TileEntityFurnace.func_145954_b((ItemStack)itemStack);
            }
            case 1: {
                return true;
            }
            case 2: {
                return itemStack.func_77973_b() instanceof ItemAlchemicalDust;
            }
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
        nbtTagCompound.func_74768_a("deviceCookTime", this.deviceCookTime);
        nbtTagCompound.func_74768_a("fuelBurnTime", this.fuelBurnTime);
        nbtTagCompound.func_74768_a("itemCookTime", this.itemCookTime);
        nbtTagCompound.func_74757_a("hasGlassBell", this.hasGlassBell);
    }

    @Override
    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityAludel(this, this.inventory[3]));
    }

    public void func_145845_h() {
        boolean isBurning = this.deviceCookTime > 0;
        boolean sendUpdate = false;
        if (this.deviceCookTime > 0) {
            --this.deviceCookTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.deviceCookTime == 0 && this.canInfuse()) {
                this.fuelBurnTime = this.deviceCookTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventory[0]);
                if (this.deviceCookTime > 0) {
                    sendUpdate = true;
                    if (this.inventory[0] != null) {
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                        }
                    }
                }
            }
            if (this.deviceCookTime > 0 && this.canInfuse()) {
                ++this.itemCookTime;
                if (this.itemCookTime == 200) {
                    this.itemCookTime = 0;
                    this.infuseItem();
                    sendUpdate = true;
                }
            } else {
                this.itemCookTime = 0;
            }
            if (isBurning != this.deviceCookTime > 0) {
                sendUpdate = true;
            }
        }
        if (sendUpdate) {
            this.func_70296_d();
            this.state = this.deviceCookTime > 0 ? (byte)1 : 0;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, (int)this.state);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTileEntityAludel(this, this.inventory[3]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0));
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public void func_70296_d() {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTileEntityAludel(this, this.inventory[3]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0));
        this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.hasGlassBell) {
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
    }

    private boolean canInfuse() {
        if (!this.hasGlassBell || this.inventory[1] == null || this.inventory[2] == null) {
            return false;
        }
        ItemStack infusedItemStack = AludelRecipeManager.getInstance().getResult(this.inventory[1], this.inventory[2]);
        if (infusedItemStack == null) {
            return false;
        }
        if (this.inventory[3] == null) {
            return true;
        }
        boolean outputEquals = this.inventory[3].func_77969_a(infusedItemStack);
        int mergedOutputStackSize = this.inventory[3].field_77994_a + infusedItemStack.field_77994_a;
        if (outputEquals) {
            return mergedOutputStackSize <= this.func_70297_j_() && mergedOutputStackSize <= infusedItemStack.func_77976_d();
        }
        return false;
    }

    public void infuseItem() {
        if (this.canInfuse()) {
            RecipeAludel recipe = AludelRecipeManager.getInstance().getRecipe(this.inventory[1], this.inventory[2]);
            if (this.inventory[3] == null) {
                this.inventory[3] = recipe.getRecipeOutput().func_77946_l();
            } else if (this.inventory[3].func_77969_a(recipe.getRecipeOutput())) {
                this.inventory[3].field_77994_a += recipe.getRecipeOutput().field_77994_a;
            }
            this.func_70298_a(1, recipe.getRecipeInputs()[0].getStackSize());
            this.func_70298_a(2, recipe.getRecipeInputs()[1].getStackSize());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.itemCookTime * scale / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.fuelBurnTime > 0) {
            return this.deviceCookTime * scale / this.fuelBurnTime;
        }
        return 0;
    }
}

