/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.api.array.AlchemyArray;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileEntityAlchemyArray;
import com.pahimar.ee3.tileentity.TileEntityDummyArray;
import com.pahimar.ee3.tileentity.TileEntityEE;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAlchemyArray
extends TileEntityEE
implements ISidedInventory {
    private AlchemyArray alchemyArray = null;
    private ForgeDirection rotation = ForgeDirection.UNKNOWN;
    private int size = 0;
    private int tickCount;

    public AlchemyArray getAlchemyArray() {
        return this.alchemyArray;
    }

    public void setAlchemyArray(AlchemyArray alchemyArray) {
        this.setAlchemyArray(alchemyArray, 1);
    }

    public void setAlchemyArray(AlchemyArray alchemyArray, int size) {
        this.alchemyArray = alchemyArray;
        this.size = size;
    }

    public ForgeDirection getRotation() {
        return this.rotation;
    }

    public void setRotation(ForgeDirection rotation) {
        this.rotation = rotation;
    }

    public void setRotation(int rotation, int facing) {
        if (this.orientation == ForgeDirection.UP) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.NORTH;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.EAST;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.SOUTH;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.WEST;
            }
        } else if (this.orientation == ForgeDirection.DOWN) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.NORTH;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.EAST;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.SOUTH;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.WEST;
            }
        } else if (this.orientation == ForgeDirection.NORTH) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.UP;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.EAST;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.DOWN;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.WEST;
            }
        } else if (this.orientation == ForgeDirection.SOUTH) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.DOWN;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.EAST;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.UP;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.WEST;
            }
        } else if (this.orientation == ForgeDirection.EAST) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.NORTH;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.UP;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.SOUTH;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.DOWN;
            }
        } else if (this.orientation == ForgeDirection.WEST) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.NORTH;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.DOWN;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.SOUTH;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.UP;
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.orientation == ForgeDirection.UP || this.orientation == ForgeDirection.DOWN) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.size), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - this.size), (double)(this.field_145851_c + this.size), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + this.size));
        }
        if (this.orientation == ForgeDirection.NORTH || this.orientation == ForgeDirection.SOUTH) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.size), (double)(this.field_145848_d - this.size), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + this.size), (double)(this.field_145848_d + this.size), (double)(this.field_145849_e + 1));
        }
        if (this.orientation == ForgeDirection.EAST || this.orientation == ForgeDirection.WEST) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - this.size), (double)(this.field_145849_e - this.size), (double)(this.field_145851_c + 1), (double)(this.field_145848_d + this.size), (double)(this.field_145849_e + this.size));
        }
        return super.getRenderBoundingBox();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickCount;
            if (this.tickCount % 100 == 0 && !this.areDummyBlocksValid()) {
                this.func_145843_s();
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.onUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tickCount);
        }
    }

    public int getLightLevel() {
        if (this.alchemyArray != null) {
            return this.alchemyArray.getLightLevel();
        }
        return 0;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.onBlockPlacedBy(world, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityLiving, itemStack);
    }

    public void onBlockPlacedBy(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayPlacedBy(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entityLiving, itemStack);
        }
    }

    public void onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        this.onBlockActivated(world, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityPlayer, sideHit, hitX, hitY, hitZ);
    }

    public void onBlockActivated(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayActivated(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entityPlayer, sideHit, hitX, hitY, hitZ);
        }
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        this.onBlockClicked(world, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityPlayer);
    }

    public void onBlockClicked(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayClicked(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entityPlayer);
        }
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z, Explosion explosion) {
        this.onBlockDestroyedByExplosion(world, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e, explosion);
    }

    public void onBlockDestroyedByExplosion(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Explosion explosion) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayDestroyedByExplosion(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, explosion);
        }
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, int metaData) {
        this.onBlockDestroyedByPlayer(world, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e, metaData);
    }

    public void onBlockDestroyedByPlayer(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, int metaData) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayDestroyedByPlayer(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, metaData);
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        this.onEntityCollidedWithBlock(world, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e, entity);
    }

    public void onEntityCollidedWithBlock(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Entity entity) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onEntityCollidedWithArray(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entity);
        }
    }

    public void onFallenUpon(World world, int x, int y, int z, Entity entity, float fallDistance) {
        this.onFallenUpon(world, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e, entity, fallDistance);
    }

    public void onFallenUpon(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Entity entity, float fallDistance) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayFallenUpon(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entity, fallDistance);
        }
    }

    public void onUpdate(World world, int x, int y, int z, int tickCount) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onUpdate(world, x, y, z, tickCount);
        }
    }

    @Override
    public Packet func_145844_m() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityAlchemyArray(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.rotation = ForgeDirection.getOrientation((int)nbtTagCompound.func_74762_e("rotation"));
        this.size = nbtTagCompound.func_74762_e("size");
        NBTTagCompound alchemyArrayTagCompound = nbtTagCompound.func_74775_l("alchemyArray");
        if (!alchemyArrayTagCompound.func_82582_d()) {
            this.alchemyArray = AlchemyArray.readArrayFromNBT(alchemyArrayTagCompound);
            try {
                Class<?> clazz = Class.forName(this.alchemyArray.getClassName(), true, Loader.instance().getModClassLoader());
                this.alchemyArray = (AlchemyArray)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.alchemyArray.readFromNBT(alchemyArrayTagCompound);
            }
            catch (Exception e) {
                this.func_145843_s();
                if (this.field_145850_b != null) {
                    this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        } else {
            this.func_145843_s();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("rotation", this.rotation.ordinal());
        nbtTagCompound.func_74768_a("size", this.size);
        NBTTagCompound alchemyArrayTagCompound = new NBTTagCompound();
        if (this.alchemyArray != null) {
            this.alchemyArray.writeToNBT(alchemyArrayTagCompound);
        }
        nbtTagCompound.func_74782_a("alchemyArray", (NBTBase)alchemyArrayTagCompound);
    }

    private boolean areDummyBlocksValid() {
        boolean validDummyBlocks;
        block7: {
            int coordOffset;
            block8: {
                block6: {
                    validDummyBlocks = true;
                    coordOffset = this.size / 2;
                    if (this.orientation != ForgeDirection.UP && this.orientation != ForgeDirection.DOWN) break block6;
                    for (int i = this.field_145851_c - coordOffset; i <= this.field_145851_c + coordOffset; ++i) {
                        for (int j = this.field_145849_e - coordOffset; j <= this.field_145849_e + coordOffset; ++j) {
                            if (i == this.field_145851_c && j == this.field_145849_e || this.isValidDummyBlock(i, this.field_145848_d, j)) continue;
                            validDummyBlocks = false;
                        }
                    }
                    break block7;
                }
                if (this.orientation != ForgeDirection.NORTH && this.orientation != ForgeDirection.SOUTH) break block8;
                for (int i = this.field_145851_c - coordOffset; i <= this.field_145851_c + coordOffset; ++i) {
                    for (int j = this.field_145848_d - coordOffset; j <= this.field_145848_d + coordOffset; ++j) {
                        if (i == this.field_145851_c && j == this.field_145848_d || this.isValidDummyBlock(i, j, this.field_145849_e)) continue;
                        validDummyBlocks = false;
                    }
                }
                break block7;
            }
            if (this.orientation != ForgeDirection.EAST && this.orientation != ForgeDirection.WEST) break block7;
            for (int i = this.field_145848_d - coordOffset; i <= this.field_145848_d + coordOffset; ++i) {
                for (int j = this.field_145849_e - coordOffset; j <= this.field_145849_e + coordOffset; ++j) {
                    if (i == this.field_145848_d && j == this.field_145849_e || this.isValidDummyBlock(this.field_145851_c, i, j)) continue;
                    validDummyBlocks = false;
                }
            }
        }
        return validDummyBlocks;
    }

    private boolean isValidDummyBlock(int x, int y, int z) {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityDummyArray) {
            TileEntityDummyArray tileEntityDummyArray = (TileEntityDummyArray)this.field_145850_b.func_147438_o(x, y, z);
            return tileEntityDummyArray.getOrientation() == this.orientation && tileEntityDummyArray.getTrueXCoord() == this.field_145851_c && tileEntityDummyArray.getTrueYCoord() == this.field_145848_d && tileEntityDummyArray.getTrueZCoord() == this.field_145849_e;
        }
        return false;
    }

    public int func_70302_i_() {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_70301_a(slotIndex);
        }
        return null;
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_70298_a(slotIndex, decrementAmount);
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_70304_b(slotIndex);
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (this.alchemyArray instanceof IInventory) {
            ((IInventory)this.alchemyArray).func_70299_a(slotIndex, itemStack);
        }
    }

    public String func_145825_b() {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_145825_b();
        }
        return null;
    }

    public boolean func_145818_k_() {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_145818_k_();
        }
        return false;
    }

    public int func_70297_j_() {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_70300_a(entityplayer);
        }
        return false;
    }

    public void func_70295_k_() {
        if (this.alchemyArray instanceof IInventory) {
            ((IInventory)this.alchemyArray).func_70295_k_();
        }
    }

    public void func_70305_f() {
        if (this.alchemyArray instanceof IInventory) {
            ((IInventory)this.alchemyArray).func_70305_f();
        }
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).func_94041_b(slotIndex, itemStack);
        }
        return false;
    }

    public int[] func_94128_d(int slotIndex) {
        return new int[0];
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }
}

