/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.test;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class EnergyValueTestSuite {
    public static final Marker TEST_MARKER = MarkerManager.getMarker((String)"EE3_ENERGY_VALUE_TEST", (Marker)LogHelper.MOD_MARKER);
    private static final Marker SUCCESS_MARKER = MarkerManager.getMarker((String)"EE3_TEST_SUCCESS", (Marker)TEST_MARKER);
    private static final Marker FAILURE_MARKER = MarkerManager.getMarker((String)"EE3_TEST_FAILURE", (Marker)TEST_MARKER);
    private static final Marker FAILURE_WRONG_VALUE_MARKER = MarkerManager.getMarker((String)"EE3_TEST_FAILURE_WRONG_VALUE", (Marker)FAILURE_MARKER);
    private static final Marker FAILURE_NO_VALUE_MARKER = MarkerManager.getMarker((String)"EE3_TEST_FAILURE_NO_VALUE", (Marker)FAILURE_MARKER);
    private Map<WrappedStack, EnergyValue> testSuiteValueMap;

    public EnergyValueTestSuite() {
        this.testSuiteValueMap = new TreeMap<WrappedStack, EnergyValue>();
    }

    public EnergyValueTestSuite(File file) {
        this.load(file);
    }

    public EnergyValueTestSuite add(Object object, Object value) {
        if (WrappedStack.canBeWrapped(object)) {
            WrappedStack wrappedStack = WrappedStack.wrap(object, 1);
            if (value instanceof Number) {
                this.testSuiteValueMap.put(wrappedStack, new EnergyValue((Number)value));
            } else if (value instanceof EnergyValue) {
                this.testSuiteValueMap.put(wrappedStack, (EnergyValue)value);
            } else if (value == null) {
                this.testSuiteValueMap.put(wrappedStack, null);
            }
        }
        return this;
    }

    public EnergyValueTestSuite remove(Object object) {
        if (WrappedStack.canBeWrapped(object)) {
            this.testSuiteValueMap.remove(WrappedStack.wrap(object, 1));
        }
        return this;
    }

    public void run() {
        this.run(false);
    }

    public void run(boolean strict) {
        ArrayList<String> successMessages = new ArrayList<String>();
        ArrayList<String> failureMessagesWrongValue = new ArrayList<String>();
        ArrayList<String> failureMessagesNoValue = new ArrayList<String>();
        for (WrappedStack wrappedStack : this.testSuiteValueMap.keySet()) {
            EnergyValue expectedValue = this.testSuiteValueMap.get(wrappedStack);
            EnergyValue actualValue = EnergyValueRegistryProxy.getEnergyValue(wrappedStack, strict);
            if (actualValue == null && expectedValue == null) {
                successMessages.add(String.format("SUCCESS: Object '%s' had the expected energy value [Expected (%s), Found (%s)]", wrappedStack, expectedValue, actualValue));
                continue;
            }
            if (actualValue == null) {
                failureMessagesNoValue.add(String.format("FAILURE: Object '%s' did not have the expected energy value [Expected (%s), Found (%s)]", wrappedStack, expectedValue, actualValue));
                continue;
            }
            if (actualValue == null || expectedValue == null) continue;
            if (actualValue.equals(expectedValue)) {
                successMessages.add(String.format("SUCCESS: Object '%s' had the expected energy value [Expected (%s), Found (%s)]", wrappedStack, expectedValue, actualValue));
                continue;
            }
            failureMessagesWrongValue.add(String.format("FAILURE: Object '%s' did not have the expected energy value [Expected (%s), Found (%s)]", wrappedStack, expectedValue, actualValue));
        }
        for (String successMessage : successMessages) {
            LogHelper.info(SUCCESS_MARKER, successMessage);
        }
        for (String failureMessage : failureMessagesWrongValue) {
            LogHelper.warn(FAILURE_WRONG_VALUE_MARKER, failureMessage);
        }
        for (String failureMessage : failureMessagesNoValue) {
            LogHelper.warn(FAILURE_NO_VALUE_MARKER, failureMessage);
        }
    }

    public EnergyValueTestSuite load(File file) {
        try {
            this.testSuiteValueMap = SerializationHelper.readMapFromFile(file);
        }
        catch (FileNotFoundException e) {
            LogHelper.warn(TEST_MARKER, "Could not load test file from disk: " + e.getMessage());
            this.testSuiteValueMap = new TreeMap<WrappedStack, EnergyValue>();
        }
        return this;
    }

    public void save(File file) {
        SerializationHelper.writeMapToFile(this.testSuiteValueMap, file);
    }
}

