/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.google.gson.JsonParseException;
import com.pahimar.ee3.api.blacklist.BlacklistRegistryProxy;
import com.pahimar.ee3.blacklist.BlacklistRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.CompressionHelper;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Set;

public class MessageSyncBlacklist
implements IMessage,
IMessageHandler<MessageSyncBlacklist, IMessage> {
    public BlacklistRegistryProxy.Blacklist blacklist;
    public Set<WrappedStack> blacklistSet;

    public MessageSyncBlacklist() {
    }

    public MessageSyncBlacklist(BlacklistRegistryProxy.Blacklist blacklist) {
        this.blacklist = blacklist;
        this.blacklistSet = BlacklistRegistryProxy.getBlacklist(blacklist);
    }

    public void fromBytes(ByteBuf buf) {
        int blacklistOrdinal = buf.readInt();
        this.blacklist = blacklistOrdinal == 0 ? BlacklistRegistryProxy.Blacklist.KNOWLEDGE : (blacklistOrdinal == 1 ? BlacklistRegistryProxy.Blacklist.EXCHANGE : null);
        if (this.blacklist != null) {
            int compressedJsonLength = buf.readInt();
            if (compressedJsonLength != 0) {
                byte[] compressedBlacklist = buf.readBytes(compressedJsonLength).array();
                if (compressedBlacklist != null) {
                    String jsonBlacklist = CompressionHelper.decompress(compressedBlacklist);
                    try {
                        this.blacklistSet = (Set)SerializationHelper.GSON.fromJson(jsonBlacklist, SerializationHelper.WRAPPED_STACK_SET_TYPE);
                    }
                    catch (JsonParseException e) {
                        LogHelper.warn("Failed to receive {} blacklist data from server", new Object[]{this.blacklist});
                        this.blacklistSet = null;
                    }
                } else {
                    this.blacklistSet = null;
                }
            }
        } else {
            this.blacklistSet = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        if (this.blacklist != null) {
            buf.writeInt(this.blacklist.ordinal());
            if (this.blacklistSet != null) {
                byte[] compressedBlacklist = CompressionHelper.compress(SerializationHelper.GSON.toJson(this.blacklistSet, SerializationHelper.WRAPPED_STACK_SET_TYPE));
                if (compressedBlacklist != null) {
                    buf.writeInt(compressedBlacklist.length);
                    buf.writeBytes(compressedBlacklist);
                } else {
                    buf.writeInt(0);
                }
            } else {
                buf.writeInt(0);
            }
        } else {
            buf.writeInt(-1);
        }
    }

    public IMessage onMessage(MessageSyncBlacklist message, MessageContext ctx) {
        if (message.blacklist != null && message.blacklistSet != null) {
            BlacklistRegistry.INSTANCE.load(message.blacklistSet, message.blacklist);
        }
        return null;
    }
}

