/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.google.gson.JsonParseException;
import com.pahimar.ee3.api.blacklist.BlacklistRegistryProxy;
import com.pahimar.ee3.blacklist.BlacklistRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.CompressionHelper;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class MessageSetBlacklistEntry
implements IMessage,
IMessageHandler<MessageSetBlacklistEntry, IMessage> {
    public BlacklistRegistryProxy.Blacklist blacklist;
    public boolean isBlacklistAction;
    public WrappedStack wrappedStack;

    public MessageSetBlacklistEntry() {
    }

    public MessageSetBlacklistEntry(Object object, BlacklistRegistryProxy.Blacklist blacklist) {
        this(object, blacklist, true);
    }

    public MessageSetBlacklistEntry(Object object, BlacklistRegistryProxy.Blacklist blacklist, boolean isBlacklistAction) {
        this.wrappedStack = WrappedStack.canBeWrapped(object) ? WrappedStack.wrap(object, 1) : null;
        this.blacklist = blacklist;
        this.isBlacklistAction = isBlacklistAction;
    }

    public void fromBytes(ByteBuf buf) {
        int blacklistOrdinal = buf.readInt();
        if (blacklistOrdinal >= 0) {
            this.blacklist = blacklistOrdinal == 0 ? BlacklistRegistryProxy.Blacklist.KNOWLEDGE : (blacklistOrdinal == 1 ? BlacklistRegistryProxy.Blacklist.EXCHANGE : null);
            if (this.blacklist != null) {
                this.isBlacklistAction = buf.readBoolean();
                int compressedJsonLength = buf.readInt();
                if (compressedJsonLength != 0) {
                    byte[] compressedWrappedStack = buf.readBytes(compressedJsonLength).array();
                    if (compressedWrappedStack != null) {
                        String jsonWrappedStack = CompressionHelper.decompress(compressedWrappedStack);
                        try {
                            this.wrappedStack = (WrappedStack)SerializationHelper.GSON.fromJson(jsonWrappedStack, WrappedStack.class);
                        }
                        catch (JsonParseException e) {
                            LogHelper.warn("Failed to receive {} blacklist data from server", new Object[]{this.blacklist});
                            this.wrappedStack = null;
                        }
                    } else {
                        this.wrappedStack = null;
                    }
                } else {
                    this.wrappedStack = null;
                }
            }
        } else {
            this.blacklist = null;
            this.isBlacklistAction = false;
            this.wrappedStack = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        if (this.blacklist != null) {
            buf.writeBoolean(this.isBlacklistAction);
            if (this.wrappedStack != null && this.wrappedStack.getWrappedObject() != null) {
                byte[] compressedWrappedStack = CompressionHelper.compress(SerializationHelper.GSON.toJson((Object)this.wrappedStack));
                buf.writeInt(compressedWrappedStack.length);
                buf.writeBytes(compressedWrappedStack);
            } else {
                buf.writeInt(0);
            }
        } else {
            buf.writeInt(-1);
        }
    }

    public IMessage onMessage(MessageSetBlacklistEntry message, MessageContext ctx) {
        if (message.blacklist != null && message.wrappedStack != null) {
            if (message.isBlacklistAction) {
                BlacklistRegistryProxy.addToBlacklist(message.wrappedStack, message.blacklist);
                BlacklistRegistry.INSTANCE.setShouldSave(false);
            } else {
                BlacklistRegistryProxy.removeFromBlacklist(message.wrappedStack, message.blacklist);
                BlacklistRegistry.INSTANCE.setShouldSave(false);
            }
        }
        return null;
    }
}

