/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.google.gson.JsonSyntaxException;
import com.pahimar.ee3.knowledge.PlayerKnowledge;
import com.pahimar.ee3.tileentity.TileEntityTransmutationTablet;
import com.pahimar.ee3.util.CompressionHelper;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MessagePlayerKnowledge
implements IMessage,
IMessageHandler<MessagePlayerKnowledge, IMessage> {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public PlayerKnowledge playerKnowledge;

    public MessagePlayerKnowledge() {
    }

    public MessagePlayerKnowledge(TileEntityTransmutationTablet transmutationTablet, Collection<ItemStack> knownItemStacks) {
        if (transmutationTablet != null) {
            this.xCoord = transmutationTablet.field_145851_c;
            this.yCoord = transmutationTablet.field_145848_d;
            this.zCoord = transmutationTablet.field_145849_e;
        } else {
            this.xCoord = 0;
            this.yCoord = Integer.MIN_VALUE;
            this.zCoord = 0;
        }
        this.playerKnowledge = knownItemStacks != null ? new PlayerKnowledge(knownItemStacks) : new PlayerKnowledge();
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        byte[] compressedJson = null;
        int readableBytes = buf.readInt();
        if (readableBytes > 0) {
            compressedJson = buf.readBytes(readableBytes).array();
        }
        if (compressedJson != null) {
            try {
                this.playerKnowledge = (PlayerKnowledge)SerializationHelper.GSON.fromJson(CompressionHelper.decompress(compressedJson), PlayerKnowledge.class);
            }
            catch (JsonSyntaxException e) {
                this.playerKnowledge = new PlayerKnowledge();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        byte[] compressedJson = null;
        if (this.playerKnowledge != null) {
            compressedJson = CompressionHelper.compress(SerializationHelper.GSON.toJson((Object)this.playerKnowledge));
        }
        if (compressedJson != null) {
            buf.writeInt(compressedJson.length);
            buf.writeBytes(compressedJson);
        } else {
            buf.writeInt(0);
        }
    }

    public IMessage onMessage(MessagePlayerKnowledge message, MessageContext ctx) {
        TileEntity tileEntity;
        if (message.yCoord != Integer.MIN_VALUE && (tileEntity = FMLClientHandler.instance().getWorldClient().func_147438_o(message.xCoord, message.yCoord, message.zCoord)) instanceof TileEntityTransmutationTablet) {
            ((TileEntityTransmutationTablet)tileEntity).handlePlayerKnowledgeUpdate(message.playerKnowledge);
        }
        return null;
    }
}

