/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.api.blacklist.BlacklistRegistryProxy;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.api.knowledge.PlayerKnowledgeRegistryProxy;
import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.inventory.InventoryTransmutationTablet;
import com.pahimar.ee3.inventory.element.IElementButtonHandler;
import com.pahimar.ee3.inventory.element.IElementSliderHandler;
import com.pahimar.ee3.inventory.element.IElementTextFieldHandler;
import com.pahimar.ee3.item.ItemAlchenomicon;
import com.pahimar.ee3.item.ItemMiniumStone;
import com.pahimar.ee3.item.ItemPhilosophersStone;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessagePlayerKnowledge;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.tileentity.TileEntityTransmutationTablet;
import com.pahimar.ee3.util.FilterUtils;
import com.pahimar.ee3.util.ItemStackUtils;
import com.pahimar.repackage.cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerTransmutationTablet
extends ContainerEE
implements IElementTextFieldHandler,
IElementSliderHandler,
IElementButtonHandler {
    private InventoryTransmutationTablet inventoryTransmutationTablet;
    private final TileEntityTransmutationTablet transmutationTablet;
    private final World world;
    private EnergyValue energyValue;
    private String searchTerm;
    private int sortOption;
    private int sortOrder;
    private int scrollBarPosition;

    public ContainerTransmutationTablet(InventoryPlayer inventoryPlayer, TileEntityTransmutationTablet transmutationTablet) {
        this.transmutationTablet = transmutationTablet;
        this.world = transmutationTablet.func_145831_w();
        this.handleTomeSync(transmutationTablet.func_70301_a(9));
        this.sortOption = 0;
        this.scrollBarPosition = 0;
        this.energyValue = transmutationTablet.getAvailableEnergy();
        this.func_75146_a(new SlotTabletInput(this, (IInventory)transmutationTablet, 0, 62, 24));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)transmutationTablet, 1, 35, 35));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)transmutationTablet, 2, 26, 61));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)transmutationTablet, 3, 35, 87));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)transmutationTablet, 4, 62, 99));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)transmutationTablet, 5, 89, 87));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)transmutationTablet, 6, 98, 61));
        this.func_75146_a(new SlotTabletInput(this, (IInventory)transmutationTablet, 7, 89, 35));
        this.func_75146_a(new Slot((IInventory)transmutationTablet, 8, 62, 61){

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(ItemStack itemStack) {
                return itemStack.func_77973_b() instanceof ItemMiniumStone || itemStack.func_77973_b() instanceof ItemPhilosophersStone;
            }
        });
        this.func_75146_a(new SlotAlchenomicon((IInventory)transmutationTablet, 9, 152, 15));
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotTabletOutput(this, this.inventoryTransmutationTablet, i * 3 + j, 175 + j * 20, 38 + i * 20));
            }
        }
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 164 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 222));
        }
        this.updateInventory();
    }

    public EnergyValue getEnergyValue() {
        return this.energyValue;
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return this.transmutationTablet != null && this.transmutationTablet.func_70300_a(entityPlayer);
    }

    public void func_75142_b() {
        super.func_75142_b();
        EnergyValue tileEnergyValue = this.transmutationTablet.getAvailableEnergy();
        for (Object crafter : this.field_75149_d) {
            ICrafting iCrafting = (ICrafting)crafter;
            if (this.energyValue.compareTo(tileEnergyValue) == 0) continue;
            this.energyValue = tileEnergyValue;
            int energyValueAsInt = Float.floatToRawIntBits(tileEnergyValue.getValue());
            iCrafting.func_71112_a((Container)this, 0, energyValueAsInt & 0xFFFF);
            iCrafting.func_71112_a((Container)this, 1, energyValueAsInt >>> 16);
        }
        this.updateInventory();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int valueType, int updatedValue) {
        if (valueType == 0) {
            int energyValueAsInt = Float.floatToRawIntBits(this.energyValue.getValue());
            energyValueAsInt = energyValueAsInt & 0xFFFF0000 | updatedValue;
            this.energyValue = new EnergyValue(Float.valueOf(Float.intBitsToFloat(energyValueAsInt)));
        } else if (valueType == 1) {
            int energyValueAsInt = Float.floatToRawIntBits(this.energyValue.getValue());
            energyValueAsInt = energyValueAsInt & 0xFFFF | updatedValue << 16;
            this.energyValue = new EnergyValue(Float.valueOf(Float.intBitsToFloat(energyValueAsInt)));
        } else if (valueType == 2) {
            this.sortOption = updatedValue;
        } else if (valueType == 3) {
            this.scrollBarPosition = updatedValue;
        } else if (valueType == 4) {
            this.sortOrder = updatedValue;
        }
        if (valueType >= 0 && valueType <= 4) {
            this.updateInventory();
        }
    }

    private void sendKnowledgeToClient(Collection<ItemStack> knownItemStacks) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessagePlayerKnowledge(this.transmutationTablet, knownItemStacks), new NetworkRegistry.TargetPoint(this.world.field_73011_w.field_76574_g, (double)this.transmutationTablet.field_145851_c, (double)this.transmutationTablet.field_145848_d, (double)this.transmutationTablet.field_145849_e, 5.0));
    }

    private void handleTomeSync(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemAlchenomicon && ItemStackUtils.getOwnerName(itemStack) != null) {
            if (!this.world.field_72995_K) {
                Set<ItemStack> knownItemStacks = PlayerKnowledgeRegistryProxy.getKnownItemStacks(ItemStackUtils.getOwnerName(itemStack));
                this.inventoryTransmutationTablet = new InventoryTransmutationTablet(knownItemStacks);
                this.sendKnowledgeToClient(knownItemStacks);
            } else {
                this.inventoryTransmutationTablet = new InventoryTransmutationTablet(this.transmutationTablet.getPlayerKnowledge());
            }
        } else {
            this.inventoryTransmutationTablet = new InventoryTransmutationTablet();
            if (!this.world.field_72995_K) {
                this.sendKnowledgeToClient(null);
            }
        }
    }

    @Override
    public void handleElementTextFieldUpdate(String elementName, String updatedText) {
        if (elementName.equalsIgnoreCase("searchField")) {
            this.searchTerm = updatedText;
            this.updateInventory();
        }
    }

    @Override
    public void handleElementSliderUpdate(String elementName, int elementValue) {
        if (elementName.equals("scrollBar")) {
            this.scrollBarPosition = elementValue;
            this.updateInventory();
        }
    }

    private void updateInventory() {
        ItemStack[] newInventory = new ItemStack[30];
        Set<ItemStack> filteredSet = FilterUtils.filterByDisplayName(this.inventoryTransmutationTablet.getKnownTransmutations(), this.searchTerm, FilterUtils.NameFilterType.CONTAINS);
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>(FilterUtils.filterByEnergyValue(filteredSet, this.energyValue));
        if (this.sortOption == 0 && this.sortOrder == 0) {
            Collections.sort(filteredList, Comparators.DISPLAY_NAME_COMPARATOR);
        } else if (this.sortOption == 0 && this.sortOrder == 1) {
            Collections.sort(filteredList, Comparators.DISPLAY_NAME_COMPARATOR.reversed());
        } else if (this.sortOption == 1 && this.sortOrder == 0) {
            Collections.sort(filteredList, Comparators.ENERGY_VALUE_ITEM_STACK_COMPARATOR);
        } else if (this.sortOption == 1 && this.sortOrder == 1) {
            Collections.sort(filteredList, Comparators.ENERGY_VALUE_ITEM_STACK_COMPARATOR.reversed());
        } else if (this.sortOption == 2 && this.sortOrder == 0) {
            Collections.sort(filteredList, Comparators.ID_COMPARATOR);
        } else if (this.sortOption == 2 && this.sortOrder == 1) {
            Collections.sort(filteredList, Comparators.ID_COMPARATOR.reversed());
        }
        if (filteredList.size() <= 30) {
            this.scrollBarPosition = 0;
        }
        int adjustedStartIndex = (int)((float)this.scrollBarPosition / 187.0f * (float)filteredList.size());
        adjustedStartIndex -= adjustedStartIndex % 3;
        int startIndex = Math.max(0, Math.min(adjustedStartIndex, filteredList.size() - 30));
        int endIndex = Math.min(adjustedStartIndex + 30, filteredList.size());
        filteredList.subList(startIndex, endIndex).toArray(newInventory);
        for (int i = 0; i < 30; ++i) {
            this.func_75139_a(i + 10).func_75215_d(newInventory[i]);
        }
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotItemStack = slot.func_75211_c();
            itemStack = slotItemStack.func_77946_l();
            if (slotIndex < 10 ? !this.func_75135_a(slotItemStack, 10, this.field_75151_b.size(), false) : (slotIndex >= 10 && slotIndex < 40 ? !this.mergeTransmutedItemStack(entityPlayer, slot, slotItemStack, 40, this.field_75151_b.size(), false) : (slotItemStack.func_77973_b() instanceof ItemAlchenomicon ? !this.func_75135_a(slotItemStack, 9, 10, false) : (slotItemStack.func_77973_b() instanceof ItemMiniumStone || slotItemStack.func_77973_b() instanceof ItemPhilosophersStone ? !this.func_75135_a(slotItemStack, 8, 10, false) : !this.func_75135_a(slotItemStack, 0, 10, false))))) {
                return null;
            }
            if (slotItemStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    private boolean mergeTransmutedItemStack(EntityPlayer entityPlayer, Slot transmutationOutputSlot, ItemStack itemStack, int slotMin, int slotMax, boolean ascending) {
        int currentSlotIndex;
        int numCanTransmute = MathHelper.floor(this.transmutationTablet.getAvailableEnergy().getValue() / EnergyValueRegistryProxy.getEnergyValue(itemStack).getValue());
        int numTransmuted = 0;
        ItemStack itemStack1 = itemStack.func_77946_l();
        itemStack1.field_77994_a = Math.min(numCanTransmute, itemStack1.func_77976_d());
        if (numCanTransmute <= 0) {
            return false;
        }
        int n = currentSlotIndex = ascending ? slotMax - 1 : slotMin;
        while (itemStack1.field_77994_a > 0 && (!ascending && currentSlotIndex < slotMax || ascending && currentSlotIndex >= slotMin)) {
            Slot slot = (Slot)this.field_75151_b.get(currentSlotIndex);
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot == null) {
                stackInSlot = itemStack1.func_77946_l();
                stackInSlot.field_77994_a = itemStack1.field_77994_a;
                slot.func_75215_d(stackInSlot);
                numTransmuted = itemStack1.field_77994_a;
                itemStack1.field_77994_a = 0;
                slot.func_75218_e();
            } else if (slot.func_75214_a(itemStack1) && ItemStackUtils.equalsIgnoreStackSize(itemStack1, stackInSlot)) {
                int combinedStackSize = stackInSlot.field_77994_a + itemStack1.field_77994_a;
                int slotStackSizeLimit = Math.min(stackInSlot.func_77976_d(), slot.func_75219_a());
                if (combinedStackSize <= slotStackSizeLimit) {
                    stackInSlot.field_77994_a = combinedStackSize;
                    numTransmuted = itemStack1.field_77994_a;
                    itemStack1.field_77994_a = 0;
                    slot.func_75218_e();
                } else if (stackInSlot.field_77994_a < slotStackSizeLimit) {
                    itemStack1.field_77994_a = slotStackSizeLimit - stackInSlot.field_77994_a;
                    stackInSlot.field_77994_a = slotStackSizeLimit;
                    numTransmuted = itemStack1.field_77994_a;
                    itemStack1.field_77994_a = 0;
                    slot.func_75218_e();
                }
            }
            currentSlotIndex += ascending ? -1 : 1;
        }
        ((SlotTabletOutput)transmutationOutputSlot).onShiftPickupFromSlot(entityPlayer, ItemStackUtils.clone(itemStack, numTransmuted));
        return false;
    }

    @Override
    public void handleElementButtonClick(String elementName, int mouseButton) {
        if (elementName.equals("sortOption")) {
            if (mouseButton == 0) {
                this.sortOption = (this.sortOption + 1) % 3;
            } else if (mouseButton == 1) {
                this.sortOption = (this.sortOption + 2) % 3;
            }
        } else if (elementName.equals("sortOrder")) {
            this.sortOrder = 1 - this.sortOrder;
        }
        for (Object crafter : this.field_75149_d) {
            ICrafting iCrafting = (ICrafting)crafter;
            iCrafting.func_71112_a((Container)this, 2, this.sortOption);
            iCrafting.func_71112_a((Container)this, 4, this.sortOrder);
        }
    }

    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        if (button == 0 && flag == 6) {
            return null;
        }
        return super.func_75144_a(slot, button, flag, player);
    }

    private class SlotTabletInput
    extends Slot {
        private ContainerTransmutationTablet containerTransmutationTablet;

        public SlotTabletInput(ContainerTransmutationTablet containerTransmutationTablet2, IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
            this.containerTransmutationTablet = containerTransmutationTablet2;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return EnergyValueRegistryProxy.hasEnergyValue(itemStack) && BlacklistRegistryProxy.isExchangeable(itemStack);
        }

        public void func_82870_a(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.func_82870_a(entityPlayer, itemStack);
            this.containerTransmutationTablet.transmutationTablet.updateEnergyValueFromInventory();
            this.containerTransmutationTablet.updateInventory();
        }

        public void func_75215_d(ItemStack itemStack) {
            super.func_75215_d(itemStack);
            this.containerTransmutationTablet.transmutationTablet.updateEnergyValueFromInventory();
            this.containerTransmutationTablet.updateInventory();
        }
    }

    private class SlotTabletOutput
    extends Slot {
        private ContainerTransmutationTablet containerTransmutationTablet;

        public SlotTabletOutput(ContainerTransmutationTablet containerTransmutationTablet2, IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
            this.containerTransmutationTablet = containerTransmutationTablet2;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer entityPlayer) {
            return this.func_75216_d();
        }

        public void func_82870_a(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.func_82870_a(entityPlayer, itemStack);
            if (this.func_75216_d()) {
                ItemStack unitItemStack = ItemStackUtils.clone(itemStack, 1);
                ContainerTransmutationTablet.this.transmutationTablet.consumeInventoryForEnergyValue(unitItemStack);
            }
            ContainerTransmutationTablet.this.updateInventory();
        }

        public void onShiftPickupFromSlot(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.func_82870_a(entityPlayer, itemStack);
            if (this.func_75216_d()) {
                ContainerTransmutationTablet.this.transmutationTablet.consumeInventoryForEnergyValue(itemStack);
            }
            ContainerTransmutationTablet.this.updateInventory();
        }

        public void func_75218_e() {
            super.func_75218_e();
            ContainerTransmutationTablet.this.transmutationTablet.updateEnergyValueFromInventory();
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.func_75216_d();
        }
    }

    private class SlotAlchenomicon
    extends Slot {
        public SlotAlchenomicon(IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
        }

        public int func_75219_a() {
            return 1;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof ItemAlchenomicon;
        }

        public void func_75218_e() {
            super.func_75218_e();
            ContainerTransmutationTablet.this.handleTomeSync(this.func_75211_c());
            ContainerTransmutationTablet.this.updateInventory();
        }
    }
}

