/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.api.knowledge.PlayerKnowledgeRegistryProxy;
import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.inventory.InventoryAlchenomicon;
import com.pahimar.ee3.inventory.element.IElementButtonHandler;
import com.pahimar.ee3.inventory.element.IElementTextFieldHandler;
import com.pahimar.ee3.item.ItemAlchenomicon;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.FilterUtils;
import com.pahimar.ee3.util.ItemStackUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAlchenomicon
extends ContainerEE
implements IElementButtonHandler,
IElementTextFieldHandler {
    private final InventoryAlchenomicon inventoryAlchenomicon;
    private int pageOffset;
    private int maxPageOffset;
    private String searchTerm;
    private boolean requiresUpdate = false;
    private static final int MAX_ROW_INDEX = 8;
    private static final int MAX_COLUMN_INDEX = 5;

    public ContainerAlchenomicon(EntityPlayer entityPlayer, ItemStack itemStack) {
        int columnIndex;
        int rowIndex;
        TreeSet<ItemStack> knownTransmutations = new TreeSet<ItemStack>(Comparators.DISPLAY_NAME_COMPARATOR);
        if (itemStack.func_77973_b() instanceof ItemAlchenomicon && ItemStackUtils.getOwnerName(itemStack) != null) {
            String playerName = ItemStackUtils.getOwnerName(itemStack);
            knownTransmutations.addAll(PlayerKnowledgeRegistryProxy.getKnownItemStacks(playerName));
        }
        this.inventoryAlchenomicon = new InventoryAlchenomicon(knownTransmutations);
        this.pageOffset = 0;
        this.maxPageOffset = knownTransmutations.size() / 80;
        int i = 0;
        for (rowIndex = 0; rowIndex < 8; ++rowIndex) {
            for (columnIndex = 0; columnIndex < 5; ++columnIndex) {
                this.func_75146_a(new Slot(this.inventoryAlchenomicon, i, 18 + columnIndex * 20, 18 + rowIndex * 19){

                    public boolean func_82869_a(EntityPlayer player) {
                        return false;
                    }

                    @SideOnly(value=Side.CLIENT)
                    public boolean func_111238_b() {
                        return false;
                    }
                });
                ++i;
            }
        }
        i = 40;
        for (rowIndex = 0; rowIndex < 8; ++rowIndex) {
            for (columnIndex = 0; columnIndex < 5; ++columnIndex) {
                this.func_75146_a(new Slot(this.inventoryAlchenomicon, i, 140 + columnIndex * 20, 18 + rowIndex * 19){

                    public boolean func_82869_a(EntityPlayer player) {
                        return false;
                    }

                    @SideOnly(value=Side.CLIENT)
                    public boolean func_111238_b() {
                        return false;
                    }
                });
                ++i;
            }
        }
    }

    public void func_75132_a(ICrafting iCrafting) {
        super.func_75132_a(iCrafting);
        iCrafting.func_71112_a((Container)this, 0, this.pageOffset);
        iCrafting.func_71112_a((Container)this, 1, this.maxPageOffset);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.requiresUpdate) {
            for (Object crafter : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter;
                icrafting.func_71112_a((Container)this, 0, this.pageOffset);
                icrafting.func_71112_a((Container)this, 1, this.maxPageOffset);
            }
            this.requiresUpdate = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int valueType, int updatedValue) {
        if (valueType == 0) {
            this.pageOffset = updatedValue;
        } else if (valueType == 1) {
            this.maxPageOffset = updatedValue;
        }
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return true;
    }

    public int getInventorySize() {
        return this.inventoryAlchenomicon.func_70302_i_();
    }

    public int getKnownTransmutationsCount() {
        return this.inventoryAlchenomicon.getKnownTransmutations().size();
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public int getMaxPageOffset() {
        return this.maxPageOffset;
    }

    @Override
    public void handleElementButtonClick(String elementName, int mouseButton) {
        if (elementName.equalsIgnoreCase("prev") && mouseButton == 0 && this.pageOffset > 0) {
            --this.pageOffset;
            this.updateInventory();
        } else if (elementName.equalsIgnoreCase("next") && mouseButton == 0 && this.pageOffset < this.maxPageOffset) {
            ++this.pageOffset;
            this.updateInventory();
        }
    }

    @Override
    public void handleElementTextFieldUpdate(String elementName, String updatedText) {
        if (elementName.equalsIgnoreCase("searchField")) {
            this.searchTerm = updatedText;
            this.pageOffset = 0;
            this.updateInventory();
        }
    }

    private void updateInventory() {
        this.requiresUpdate = true;
        boolean shouldUpdateInventory = false;
        ItemStack[] newInventory = new ItemStack[80];
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>(FilterUtils.filterByDisplayName(this.inventoryAlchenomicon.getKnownTransmutations(), this.searchTerm, FilterUtils.NameFilterType.CONTAINS, Comparators.DISPLAY_NAME_COMPARATOR));
        this.maxPageOffset = filteredList.size() / 80;
        if (this.pageOffset > this.maxPageOffset) {
            this.pageOffset = 0;
        }
        if (this.pageOffset == 0) {
            if (filteredList.size() <= 80) {
                newInventory = filteredList.toArray(newInventory);
                shouldUpdateInventory = true;
            } else {
                newInventory = filteredList.subList(0, 80).toArray(newInventory);
                shouldUpdateInventory = true;
            }
        } else if (this.pageOffset < this.maxPageOffset) {
            newInventory = filteredList.subList(this.pageOffset * 80, (this.pageOffset + 1) * 80).toArray(newInventory);
            shouldUpdateInventory = true;
        } else if (this.pageOffset == this.maxPageOffset) {
            newInventory = filteredList.subList(this.pageOffset * 80, filteredList.size() - 1).toArray(newInventory);
            shouldUpdateInventory = true;
        }
        if (shouldUpdateInventory) {
            for (int i = 0; i < 80; ++i) {
                this.inventoryAlchenomicon.func_70299_a(i, newInventory[i]);
                this.inventoryAlchenomicon.func_70296_d();
            }
        }
    }
}

