/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.handler;

import com.pahimar.ee3.util.ConfigurationHelper;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration configuration;
    private static final String CATEGORY_SOUND = "general.sound";
    private static final String CATEGORY_ENERGY_VALUE = "general.energy_value";
    private static final String CATEGORY_PLAYER_KNOWLEDGE = "general.player_knowledge";
    private static final String CATEGORY_SERVER = "general.server";

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile, true);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        Settings.serverSyncThreshold = configuration.getInt("sync_threshold", CATEGORY_SERVER, 5, 0, Short.MAX_VALUE, StatCollector.func_74838_a((String)"server.sync_threshold.comment"), "server.sync_threshold.label");
        Settings.regenerateEnergyValuesWhen = ConfigurationHelper.getString(configuration, "regenerate_values_when", CATEGORY_ENERGY_VALUE, "As Needed", StatCollector.func_74838_a((String)"energy_value.regenerate_values_when.comment"), Settings.ENERGY_VALUE_REGENERATE_WHEN_OPTIONS, "energy_value.regenerate_values_when.label");
        Settings.energyValueDebugLoggingEnabled = configuration.getBoolean("debug_logging_enabled", CATEGORY_ENERGY_VALUE, false, StatCollector.func_74838_a((String)"energy_value.debug_logging_enabled.comment"), "energy_value.debug_logging_enabled.label");
        Settings.soundMode = ConfigurationHelper.getString(configuration, "mode", CATEGORY_SOUND, "All", StatCollector.func_74838_a((String)"sound.mode.comment"), Settings.SOUND_MODE_OPTIONS, "sound.mode.label");
        Settings.playerKnowledgeTemplateEnabled = configuration.getBoolean("use_template", CATEGORY_PLAYER_KNOWLEDGE, true, StatCollector.func_74838_a((String)"player_knowledge.use_template.comment"), "player_knowledge.use_template.label");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("EE3")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static class Settings {
        public static int serverSyncThreshold;
        private static final String SERVER_SYNC_THRESHOLD_NAME = "sync_threshold";
        private static final String SERVER_SYNC_THRESHOLD_LABEL = "server.sync_threshold.label";
        private static final String SERVER_SYNC_THRESHOLD_COMMENT = "server.sync_threshold.comment";
        private static final int SERVER_SYNC_THRESHOLD_DEFAULT = 5;
        private static final int SERVER_SYNC_THRESHOLD_MIN = 0;
        private static final int SERVER_SYNC_THRESHOLD_MAX = Short.MAX_VALUE;
        public static String regenerateEnergyValuesWhen;
        private static final String ENERGY_VALUE_REGENERATE_WHEN_NAME = "regenerate_values_when";
        private static final String ENERGY_VALUE_REGENERATE_WHEN_LABEL = "energy_value.regenerate_values_when.label";
        private static final String ENERGY_VALUE_REGENERATE_WHEN_COMMENT = "energy_value.regenerate_values_when.comment";
        private static final String ENERGY_VALUE_REGENERATE_WHEN_DEFAULT = "As Needed";
        private static final String[] ENERGY_VALUE_REGENERATE_WHEN_OPTIONS;
        public static boolean energyValueDebugLoggingEnabled;
        private static final String ENERGY_VALUE_DEBUG_LOGGING_ENABLED_NAME = "debug_logging_enabled";
        private static final String ENERGY_VALUE_DEBUG_LOGGING_ENABLED_LABEL = "energy_value.debug_logging_enabled.label";
        private static final String ENERGY_VALUE_DEBUG_LOGGING_ENABLED_COMMENT = "energy_value.debug_logging_enabled.comment";
        private static final boolean ENERGY_VALUE_DEBUG_LOGGING_ENABLED_DEFAULT = false;
        public static String soundMode;
        private static final String SOUND_MODE_NAME = "mode";
        private static final String SOUND_MODE_LABEL = "sound.mode.label";
        private static final String SOUND_MODE_COMMENT = "sound.mode.comment";
        private static final String SOUND_MODE_DEFAULT = "All";
        private static final String[] SOUND_MODE_OPTIONS;
        public static boolean playerKnowledgeTemplateEnabled;
        private static final String USE_PLAYER_KNOWLEDGE_TEMPLATE_NAME = "use_template";
        private static final String USE_PLAYER_KNOWLEDGE_TEMPLATE_LABEL = "player_knowledge.use_template.label";
        private static final String USE_PLAYER_KNOWLEDGE_TEMPLATE_COMMENT = "player_knowledge.use_template.comment";
        private static final boolean USE_PLAYER_KNOWLEDGE_TEMPLATE_DEFAULT = true;

        static {
            ENERGY_VALUE_REGENERATE_WHEN_OPTIONS = new String[]{ENERGY_VALUE_REGENERATE_WHEN_DEFAULT, "Always"};
            SOUND_MODE_OPTIONS = new String[]{SOUND_MODE_DEFAULT, "Self", "None"};
        }
    }
}

