/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.handler;

import com.pahimar.ee3.api.blacklist.BlacklistRegistryProxy;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.api.knowledge.PlayerKnowledgeRegistryProxy;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.inventory.ContainerAlchenomicon;
import com.pahimar.ee3.inventory.ContainerResearchStation;
import com.pahimar.ee3.inventory.ContainerTransmutationTablet;
import com.pahimar.ee3.util.IOwnable;
import com.pahimar.ee3.util.ItemStackUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ItemTooltipEventHandler {
    @SubscribeEvent
    public void handleItemTooltipEvent(ItemTooltipEvent event) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) || event.entityPlayer != null && (event.entityPlayer.field_71070_bA instanceof ContainerAlchenomicon || event.entityPlayer.field_71070_bA instanceof ContainerTransmutationTablet)) {
            WrappedStack wrappedItemStack = WrappedStack.wrap(event.itemStack);
            EnergyValue energyValue = EnergyValueRegistryProxy.getEnergyValue(wrappedItemStack);
            EnergyValue stackEnergyValue = EnergyValueRegistryProxy.getEnergyValueForStack(wrappedItemStack);
            if (energyValue != null) {
                if (wrappedItemStack.getStackSize() > 1) {
                    event.toolTip.add(String.format("Exchange Energy (Item): %s", energyValue));
                    event.toolTip.add(String.format("Exchange Energy (Stack of %s): %s", event.itemStack.field_77994_a, stackEnergyValue));
                } else {
                    FluidStack fluidStack;
                    EnergyValue fluidStackEnergyValue;
                    event.toolTip.add(String.format("Exchange Energy: %s", stackEnergyValue));
                    if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)event.itemStack) != null && (fluidStackEnergyValue = EnergyValueRegistryProxy.getEnergyValueForStack(fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)event.itemStack))) != null) {
                        event.toolTip.add(String.format(" - Exchange Energy (%smB of %s): %s", fluidStack.amount, fluidStack.getLocalizedName(), fluidStackEnergyValue));
                        event.toolTip.add(String.format(" - Exchange Energy (Container): %s", new EnergyValue(Float.valueOf(energyValue.getValue() - fluidStackEnergyValue.getValue()))));
                    }
                }
            } else {
                event.toolTip.add("No Exchange Energy value");
            }
            if (!BlacklistRegistryProxy.isLearnable(wrappedItemStack)) {
                event.toolTip.add("Not learnable");
            }
            if (!BlacklistRegistryProxy.isExchangeable(wrappedItemStack)) {
                event.toolTip.add("Not exchangeable");
            }
        }
        if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && event.entityPlayer != null && event.entityPlayer.field_71070_bA instanceof ContainerResearchStation && PlayerKnowledgeRegistryProxy.doesPlayerKnow(event.entityPlayer, (Object)event.itemStack)) {
            event.toolTip.add("You know how to transmute this");
        }
        if (event.itemStack.func_77973_b() instanceof IOwnable) {
            UUID playerUUID = ItemStackUtils.getOwnerUUID(event.itemStack);
            if (playerUUID != null && UsernameCache.containsUUID((UUID)playerUUID)) {
                event.toolTip.add(StatCollector.func_74837_a((String)"tooltip.ee3:belongsTo", (Object[])new Object[]{UsernameCache.getLastKnownUsername((UUID)playerUUID)}));
            } else if (ItemStackUtils.getOwnerName(event.itemStack) != null) {
                event.toolTip.add(StatCollector.func_74837_a((String)"tooltip.ee3:belongsTo", (Object[])new Object[]{ItemStackUtils.getOwnerName(event.itemStack)}));
            }
        }
    }
}

