/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.gui.component;

import com.pahimar.ee3.client.gui.GuiBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Comparator;
import net.minecraft.util.ResourceLocation;

public abstract class GuiComponent
implements Comparable<GuiComponent> {
    public static Comparator<GuiComponent> orderingComparator = new Comparator<GuiComponent>(){

        @Override
        public int compare(GuiComponent guiComponent1, GuiComponent guiComponent2) {
            if (guiComponent1.ordering == guiComponent2.ordering) {
                if (guiComponent1.zIndex == guiComponent2.zIndex) {
                    if (guiComponent1.id != null && guiComponent2.id != null) {
                        return guiComponent1.id.compareToIgnoreCase(guiComponent2.id);
                    }
                    return guiComponent1.hashCode() - guiComponent2.hashCode();
                }
                return guiComponent2.zIndex - guiComponent1.zIndex;
            }
            return guiComponent1.ordering - guiComponent2.ordering;
        }
    };
    public static Comparator<GuiComponent> zIndexComparator = new Comparator<GuiComponent>(){

        @Override
        public int compare(GuiComponent guiComponent1, GuiComponent guiComponent2) {
            if (guiComponent1.zIndex == guiComponent2.zIndex) {
                if (guiComponent1.ordering == guiComponent2.ordering) {
                    if (guiComponent1.id != null && guiComponent2.id != null) {
                        return guiComponent1.id.compareToIgnoreCase(guiComponent2.id);
                    }
                    return guiComponent1.hashCode() - guiComponent2.hashCode();
                }
                return guiComponent1.ordering - guiComponent2.ordering;
            }
            return guiComponent2.zIndex - guiComponent1.zIndex;
        }
    };
    protected final GuiBase parentGui;
    protected final String id;
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation texture;
    protected int positionX;
    protected int positionY;
    protected int componentWidth;
    protected int componentHeight;
    protected int textureWidth;
    protected int textureHeight;
    protected int ordering = 0;
    protected int zIndex = 0;
    protected boolean isVisible = true;
    protected boolean isEnabled = true;
    protected boolean isFocusable = true;

    public GuiComponent(GuiBase parentGui, String id) {
        this(parentGui, id, null, 0, 0);
    }

    public GuiComponent(GuiBase parentGui, String id, ResourceLocation texture, int positionX, int positionY) {
        this(parentGui, id, texture, positionX, positionY, 256, 256);
    }

    public GuiComponent(GuiBase parentGui, String id, ResourceLocation texture, int positionX, int positionY, int componentWidth, int componentHeight) {
        this(parentGui, id, texture, positionX, positionY, componentWidth, componentHeight, 256, 256);
    }

    public GuiComponent(GuiBase parentGui, String id, ResourceLocation texture, int positionX, int positionY, int componentWidth, int componentHeight, int textureWidth, int textureHeight) {
        this.parentGui = parentGui;
        this.id = id;
        this.texture = texture;
        this.positionX = positionX;
        this.positionY = positionY;
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public final GuiBase getParentGui() {
        return this.parentGui;
    }

    public final String getId() {
        return this.id;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public GuiComponent setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public GuiComponent setTexture(ResourceLocation texture, int textureWidth, int textureHeight) {
        this.texture = texture;
        return this.setTextureSize(textureWidth, textureHeight);
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public GuiComponent setPosition(int positionX, int positionY) {
        this.positionX = positionX;
        this.positionY = positionY;
        return this;
    }

    public int getComponentWidth() {
        return this.componentWidth;
    }

    public int getComponentHeight() {
        return this.componentHeight;
    }

    public GuiComponent setComponentSize(int componentWidth, int componentHeight) {
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        return this;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public GuiComponent setTextureSize(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        return this;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public GuiComponent setOrdering(int ordering) {
        this.ordering = ordering;
        return this;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public GuiComponent setZIndex(int zIndex) {
        this.zIndex = zIndex;
        return this;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public GuiComponent setVisible(boolean isVisible) {
        if (this.isVisible && !isVisible) {
            this.onHide();
        } else if (!this.isVisible && isVisible) {
            this.onShow();
        }
        this.isVisible = isVisible;
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public GuiComponent setEnabled(boolean isEnabled) {
        if (this.isEnabled && !isEnabled) {
            this.onDisable();
        } else if (!this.isEnabled && isEnabled) {
            this.onEnable();
        }
        this.isEnabled = isEnabled;
        return this;
    }

    public boolean isFocusable() {
        return this.isFocusable;
    }

    public GuiComponent setIsFocusable(boolean isFocusable) {
        this.isFocusable = isFocusable;
        return this;
    }

    public boolean hasFocus() {
        if (this.isFocusable) {
            return this.getParentGui().getActiveGuiComponentId().equals(this.getId());
        }
        return false;
    }

    public abstract void drawForeground(int var1, int var2, float var3);

    public abstract void drawBackground(int var1, int var2, float var3);

    public abstract void onUpdate(int var1, int var2, float var3);

    public boolean intersectsWith(int xCoord, int yCoord) {
        return xCoord >= this.positionX && xCoord <= this.positionX + this.componentWidth && yCoord >= this.positionY && yCoord <= this.positionY + this.componentHeight;
    }

    public boolean intersectsWith(int xCoord, int yCoord, int zIndex) {
        return xCoord >= this.positionX && xCoord <= this.positionX + this.componentWidth && yCoord >= this.positionY && yCoord <= this.positionY + this.componentHeight && zIndex == this.zIndex;
    }

    public abstract void onMouseButtonClicked(int var1, int var2, int var3);

    public boolean onMouseButtonClick(int rawMouseX, int rawMouseY, int mouseButton) {
        this.onMouseButtonClicked(rawMouseX, rawMouseY, mouseButton);
        return false;
    }

    public abstract void onMouseButtonDown(int var1, int var2, int var3);

    public abstract void onMouseButtonUp(int var1, int var2, int var3);

    public abstract void onMouseButtonRelease(int var1, int var2, int var3, long var4);

    public abstract void onMouseMove(int var1, int var2, int var3, int var4);

    public abstract void onMouseEnter(int var1, int var2);

    public abstract void onMouseOver(int var1, int var2, float var3);

    public abstract void onMouseLeave(int var1, int var2);

    public abstract void onMouseWheel(int var1, int var2, int var3);

    public abstract void onKeyPressed(char var1, int var2);

    public boolean onKeyPress(char characterTyped, int keyPressed) {
        this.onKeyPress(characterTyped, keyPressed);
        return false;
    }

    public abstract void onFocusGained();

    public abstract void onFocusLost();

    public abstract void onInit();

    public abstract void onClose();

    public abstract void onHide();

    public abstract void onShow();

    public abstract void onEnable();

    public abstract void onDisable();

    @Override
    public int compareTo(GuiComponent guiComponent) {
        return orderingComparator.compare(this, guiComponent);
    }
}

