/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.api.array.AlchemyArray;
import com.pahimar.ee3.array.AlchemyArrayRegistry;
import com.pahimar.ee3.block.BlockTileEntityEE;
import com.pahimar.ee3.reference.RenderIds;
import com.pahimar.ee3.reference.Sounds;
import com.pahimar.ee3.settings.ChalkSettings;
import com.pahimar.ee3.tileentity.TileEntityAlchemyArray;
import com.pahimar.ee3.tileentity.TileEntityEE;
import com.pahimar.ee3.util.CommonSoundHelper;
import com.pahimar.ee3.util.EntityHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAlchemyArray
extends BlockTileEntityEE {
    public BlockAlchemyArray() {
        super(Material.field_151594_q);
        this.func_149647_a(null);
        this.func_149663_c("alchemyArray");
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderIds.alchemyArray;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)world.func_147438_o(x, y, z);
            return tileEntityAlchemyArray.getLightLevel();
        }
        return 0;
    }

    public Item func_149650_a(int par1, Random random, int par2) {
        return null;
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int x, int y, int z) {
        if (iBlockAccess.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)iBlockAccess.func_147438_o(x, y, z);
            switch (tileEntityAlchemyArray.getOrientation()) {
                case DOWN: {
                    this.func_149676_a(0.0f, 1.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
                    break;
                }
                case UP: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                    break;
                }
                case NORTH: {
                    this.func_149676_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case SOUTH: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                    break;
                }
                case EAST: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                    break;
                }
                case WEST: {
                    this.func_149676_a(1.0f, 0.0f, 0.0f, 0.9375f, 1.0f, 1.0f);
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                default: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                }
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN));
    }

    public boolean func_149707_d(World world, int x, int y, int z, int sideHit) {
        ForgeDirection side = ForgeDirection.getOrientation((int)sideHit);
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && (side == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || side == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || side == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || side == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || side == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || side == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST));
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)world.func_147438_o(x, y, z);
            boolean invalidateAlchemyArray = false;
            if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.UP && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.DOWN && !world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.NORTH && !world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.SOUTH && !world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.EAST && !world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.WEST && !world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) {
                invalidateAlchemyArray = true;
            }
            if (invalidateAlchemyArray) {
                tileEntityAlchemyArray.func_145843_s();
                world.func_147468_f(x, y, z);
            }
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int sideHit, float hitX, float hitY, float hitZ, int metaData) {
        return sideHit;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray && entityLiving instanceof EntityPlayer) {
            NBTTagCompound customEntityData = EntityHelper.getCustomEntityData((Entity)entityLiving);
            ChalkSettings chalkSettings = new ChalkSettings();
            chalkSettings.readFromNBT(customEntityData);
            AlchemyArray alchemyArray = AlchemyArrayRegistry.getInstance().getAlchemyArray(chalkSettings.getIndex());
            if (alchemyArray != null) {
                int facing = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                world.func_72921_c(x, y, z, world.func_72805_g(x, y, z), 3);
                ((TileEntityEE)world.func_147438_o(x, y, z)).setOrientation(world.func_72805_g(x, y, z));
                ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).setRotation(chalkSettings.getRotation(), facing);
                ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).setAlchemyArray(alchemyArray, chalkSettings.getSize());
                CommonSoundHelper.playSoundAtPlayer((EntityPlayer)entityLiving, Sounds.Chalk.getRandomChalkSound(), 1.0f, 1.0f);
                ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).onBlockPlacedBy(world, x, y, z, entityLiving, itemStack);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).onBlockActivated(world, x, y, z, entityPlayer, sideHit, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).onBlockClicked(world, x, y, z, entityPlayer);
        }
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).onBlockDestroyedByExplosion(world, x, y, z, explosion);
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int metaData) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).onBlockDestroyedByPlayer(world, x, y, z, metaData);
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).onEntityCollidedWithBlock(world, x, y, z, entity);
        }
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float fallDistance) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityAlchemyArray) {
            ((TileEntityAlchemyArray)world.func_147438_o(x, y, z)).onFallenUpon(world, x, y, z, entity, fallDistance);
        }
    }

    public TileEntity func_149915_a(World world, int metaData) {
        return new TileEntityAlchemyArray();
    }
}

