/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.blacklist;

import com.pahimar.ee3.api.blacklist.BlacklistRegistryProxy;
import com.pahimar.ee3.api.event.BlacklistEvent;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.LoaderHelper;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.OreDictionaryHelper;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class BlacklistRegistry {
    public static final BlacklistRegistry INSTANCE = new BlacklistRegistry();
    private static final Marker BLACKLIST_MARKER = MarkerManager.getMarker((String)"EE3_BLACKLIST", (Marker)LogHelper.MOD_MARKER);
    private static final Marker KNOWLEDGE_MARKER = MarkerManager.getMarker((String)"EE3_KNOWLEDGE", (Marker)BLACKLIST_MARKER);
    private static final Marker KNOWLEDGE_BLACKLIST_MARKER = MarkerManager.getMarker((String)"EE3_KNOWLEDGE_BLACKLIST", (Marker)KNOWLEDGE_MARKER);
    private static final Marker KNOWLEDGE_WHITELIST_MARKER = MarkerManager.getMarker((String)"EE3_KNOWLEDGE_WHITELIST", (Marker)KNOWLEDGE_MARKER);
    private static final Marker EXCHANGE_MARKER = MarkerManager.getMarker((String)"EE3_EXCHANGE", (Marker)BLACKLIST_MARKER);
    private static final Marker EXCHANGE_BLACKLIST_MARKER = MarkerManager.getMarker((String)"EE3_EXCHANGE_BLACKLIST", (Marker)EXCHANGE_MARKER);
    private static final Marker EXCHANGE_WHITELIST_MARKER = MarkerManager.getMarker((String)"EE3_EXCHANGE_WHITELIST", (Marker)EXCHANGE_MARKER);
    private final Set<WrappedStack> knowledgeBlacklist = new TreeSet<WrappedStack>();
    private final Set<WrappedStack> exchangeBlacklist = new TreeSet<WrappedStack>();
    public static File knowledgeBlacklistFile;
    public static File exchangeBlacklistFile;
    private transient boolean shouldSave = true;

    private BlacklistRegistry() {
    }

    public Set<WrappedStack> getKnowledgeBlacklist() {
        return Collections.unmodifiableSet(this.knowledgeBlacklist);
    }

    public Set<WrappedStack> getExchangeBlacklist() {
        return Collections.unmodifiableSet(this.exchangeBlacklist);
    }

    public boolean isLearnable(Object object) {
        if (WrappedStack.canBeWrapped(object)) {
            WrappedStack wrappedObject = WrappedStack.wrap(object, 1);
            if (object instanceof ItemStack && ((ItemStack)object).func_77951_h()) {
                return false;
            }
            if (EnergyValueRegistryProxy.hasEnergyValue(wrappedObject)) {
                if (this.knowledgeBlacklist.contains(wrappedObject)) {
                    return false;
                }
                if (object instanceof ItemStack) {
                    Collection<String> oreNames = OreDictionaryHelper.getOreNames((ItemStack)object);
                    for (String oreName : oreNames) {
                        if (!this.knowledgeBlacklist.contains(WrappedStack.wrap(new OreStack(oreName)))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isExchangeable(Object object) {
        WrappedStack wrappedObject;
        if (WrappedStack.canBeWrapped(object) && EnergyValueRegistryProxy.hasEnergyValue(wrappedObject = WrappedStack.wrap(object, 1))) {
            if (this.exchangeBlacklist.contains(wrappedObject)) {
                return false;
            }
            if (object instanceof ItemStack) {
                Collection<String> oreNames = OreDictionaryHelper.getOreNames((ItemStack)object);
                for (String oreName : oreNames) {
                    if (!this.exchangeBlacklist.contains(WrappedStack.wrap(new OreStack(oreName)))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void addToBlacklist(Object object, BlacklistRegistryProxy.Blacklist blacklist) {
        if (WrappedStack.canBeWrapped(object)) {
            WrappedStack wrappedStack = WrappedStack.wrap(object, 1);
            if (blacklist == BlacklistRegistryProxy.Blacklist.KNOWLEDGE) {
                if (wrappedStack != null && !MinecraftForge.EVENT_BUS.post((Event)new BlacklistEvent.KnowledgeBlacklistEvent(object))) {
                    LogHelper.trace(KNOWLEDGE_BLACKLIST_MARKER, "[{}] Mod with ID '{}' added object {} to the player knowledge blacklist", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedStack);
                    this.knowledgeBlacklist.add(WrappedStack.wrap(object, 1));
                    this.save(blacklist);
                }
            } else if (blacklist == BlacklistRegistryProxy.Blacklist.EXCHANGE && wrappedStack != null && !MinecraftForge.EVENT_BUS.post((Event)new BlacklistEvent.ExchangeBlacklistEvent(object))) {
                LogHelper.trace(EXCHANGE_BLACKLIST_MARKER, "[{}] Mod with ID '{}' added object {} to the exchange blacklist", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedStack);
                this.exchangeBlacklist.add(WrappedStack.wrap(object, 1));
                this.save(blacklist);
            }
        }
    }

    public void removeFromBlacklist(Object object, BlacklistRegistryProxy.Blacklist blacklist) {
        if (WrappedStack.canBeWrapped(object)) {
            WrappedStack wrappedStack = WrappedStack.wrap(object, 1);
            if (blacklist == BlacklistRegistryProxy.Blacklist.KNOWLEDGE) {
                if (wrappedStack != null && !MinecraftForge.EVENT_BUS.post((Event)new BlacklistEvent.KnowledgeWhitelistEvent(object))) {
                    LogHelper.trace(KNOWLEDGE_WHITELIST_MARKER, "[{}] Mod with ID '{}' removed object {} from the player knowledge blacklist", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedStack);
                    this.knowledgeBlacklist.remove(wrappedStack);
                    this.save(blacklist);
                }
            } else if (blacklist == BlacklistRegistryProxy.Blacklist.EXCHANGE && wrappedStack != null && !MinecraftForge.EVENT_BUS.post((Event)new BlacklistEvent.ExchangeWhitelistEvent(object))) {
                LogHelper.trace(EXCHANGE_WHITELIST_MARKER, "[{}] Mod with ID '{}' removed object {} from the exchange blacklist", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedStack);
                this.exchangeBlacklist.remove(wrappedStack);
                this.save(blacklist);
            }
        }
    }

    public void setShouldSave(boolean shouldSave) {
        this.shouldSave = shouldSave;
    }

    public void load() {
        if (knowledgeBlacklistFile != null) {
            Set<WrappedStack> knowledgeBlacklistSet = SerializationHelper.readSetFromFile(knowledgeBlacklistFile);
            this.knowledgeBlacklist.clear();
            this.knowledgeBlacklist.addAll(knowledgeBlacklistSet.stream().filter(wrappedStack -> wrappedStack != null).collect(Collectors.toList()));
        }
        if (exchangeBlacklistFile != null) {
            Set<WrappedStack> exchangeBlacklistSet = SerializationHelper.readSetFromFile(exchangeBlacklistFile);
            this.exchangeBlacklist.clear();
            this.exchangeBlacklist.addAll(exchangeBlacklistSet.stream().filter(wrappedStack -> wrappedStack != null).collect(Collectors.toList()));
        }
    }

    public void load(Set<WrappedStack> blacklistSet, BlacklistRegistryProxy.Blacklist blacklist) {
        if (blacklist != null && blacklistSet != null) {
            this.setShouldSave(false);
            if (blacklist == BlacklistRegistryProxy.Blacklist.KNOWLEDGE) {
                LogHelper.info("Received {} player knowledge blacklist entries from server", blacklistSet.size());
                this.knowledgeBlacklist.clear();
                this.knowledgeBlacklist.addAll(blacklistSet.stream().filter(wrappedStack -> wrappedStack != null).collect(Collectors.toList()));
            } else if (blacklist == BlacklistRegistryProxy.Blacklist.EXCHANGE) {
                LogHelper.info("Received {} exchange blacklist entries from server", blacklistSet.size());
                this.exchangeBlacklist.clear();
                this.exchangeBlacklist.addAll(blacklistSet.stream().filter(wrappedStack -> wrappedStack != null).collect(Collectors.toList()));
            }
        }
    }

    public void save(BlacklistRegistryProxy.Blacklist blacklist) {
        if (this.shouldSave) {
            if (blacklist == BlacklistRegistryProxy.Blacklist.KNOWLEDGE && knowledgeBlacklistFile != null) {
                SerializationHelper.writeJsonFile(knowledgeBlacklistFile, SerializationHelper.GSON.toJson(this.knowledgeBlacklist));
            } else if (blacklist == BlacklistRegistryProxy.Blacklist.EXCHANGE && exchangeBlacklistFile != null) {
                SerializationHelper.writeJsonFile(exchangeBlacklistFile, SerializationHelper.GSON.toJson(this.exchangeBlacklist));
            }
        }
    }

    public void saveAll() {
        if (this.shouldSave && knowledgeBlacklistFile != null && exchangeBlacklistFile != null) {
            LogHelper.trace(BLACKLIST_MARKER, "Saving all blacklists to disk", exchangeBlacklistFile.getAbsolutePath());
            SerializationHelper.writeJsonFile(knowledgeBlacklistFile, SerializationHelper.GSON.toJson(this.knowledgeBlacklist));
            SerializationHelper.writeJsonFile(exchangeBlacklistFile, SerializationHelper.GSON.toJson(this.exchangeBlacklist));
        }
    }
}

