/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api.exchange;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.WrappedStack;
import cpw.mods.fml.common.Mod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public final class EnergyValueRegistryProxy {
    @Mod.Instance(value="EE3")
    private static Object ee3Mod;

    public static Map<WrappedStack, EnergyValue> getPreCalculationEnergyValues() {
        return EnergyValueRegistryProxy.getEnergyValues(Phase.PRE_CALCULATION);
    }

    public static Map<WrappedStack, EnergyValue> getPostCalculationEnergyValues() {
        return EnergyValueRegistryProxy.getEnergyValues(Phase.POST_CALCULATION);
    }

    public static Map<WrappedStack, EnergyValue> getEnergyValues() {
        return EnergyValueRegistryProxy.getEnergyValues(Phase.ALL);
    }

    public static Map<WrappedStack, EnergyValue> getEnergyValues(Phase phase) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            if (phase == Phase.PRE_ASSIGNMENT || phase == Phase.PRE_CALCULATION) {
                EE3Wrapper.ee3mod.getEnergyValueRegistry().getPreCalculationStackValueMap();
            } else if (phase == Phase.POST_ASSIGNMENT || phase == Phase.POST_CALCULATION) {
                EE3Wrapper.ee3mod.getEnergyValueRegistry().getPostCalculationStackValueMap();
            } else if (phase == Phase.ALL) {
                EE3Wrapper.ee3mod.getEnergyValueRegistry().getEnergyValues();
            }
        }
        return null;
    }

    public static boolean hasEnergyValue(Object object) {
        return EnergyValueRegistryProxy.hasEnergyValue(object, false);
    }

    public static boolean hasEnergyValue(Object object, boolean strict) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getEnergyValueRegistry().hasEnergyValue(object, strict);
        }
        return false;
    }

    public static EnergyValue getEnergyValue(Object object) {
        return EnergyValueRegistryProxy.getEnergyValue(object, false);
    }

    public static EnergyValue getEnergyValue(Object object, boolean strict) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getEnergyValueRegistry().getEnergyValue(object, strict);
        }
        return null;
    }

    public static EnergyValue getEnergyValueForStack(Object object) {
        return EnergyValueRegistryProxy.getEnergyValueForStack(object, false);
    }

    public static EnergyValue getEnergyValueForStack(Object object, boolean strict) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getEnergyValueRegistry().getEnergyValueForStack(object, strict);
        }
        return null;
    }

    public static List getStacksInRange(Number start, Number finish) {
        return EnergyValueRegistryProxy.getStacksInRange(start, finish);
    }

    public static List getStacksInRange(EnergyValue start, EnergyValue finish) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            return new ArrayList<ItemStack>(EE3Wrapper.ee3mod.getEnergyValueRegistry().getStacksInRange(start, finish));
        }
        return Collections.EMPTY_LIST;
    }

    @Deprecated
    public static void addPreAssignedEnergyValue(Object object, float energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, Float.valueOf(energyValue), Phase.PRE_CALCULATION);
    }

    @Deprecated
    public static void addPreAssignedEnergyValue(Object object, EnergyValue energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, energyValue, Phase.PRE_CALCULATION);
    }

    @Deprecated
    public static void addPreCalculationEnergyValue(Object object, float energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, Float.valueOf(energyValue), Phase.PRE_CALCULATION);
    }

    @Deprecated
    public static void addPreCalculationEnergyValue(Object object, EnergyValue energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, energyValue, Phase.PRE_CALCULATION);
    }

    @Deprecated
    public static void addPostAssignedEnergyValue(Object object, float energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, Float.valueOf(energyValue));
    }

    @Deprecated
    public static void addPostAssignedEnergyValue(Object object, EnergyValue energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, energyValue);
    }

    @Deprecated
    public static void addPostCalculationEnergyValue(Object object, float energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, Float.valueOf(energyValue));
    }

    @Deprecated
    public static void addPostCalculationEnergyValue(Object object, EnergyValue energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, energyValue);
    }

    public static void setEnergyValue(Object object, Number energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, new EnergyValue(energyValue), Phase.POST_CALCULATION);
    }

    public static void setEnergyValue(Object object, EnergyValue energyValue) {
        EnergyValueRegistryProxy.setEnergyValue(object, energyValue, Phase.POST_CALCULATION);
    }

    public static void setEnergyValue(Object object, Number energyValue, Phase phase) {
        EnergyValueRegistryProxy.setEnergyValue(object, new EnergyValue(energyValue), phase);
    }

    public static void setEnergyValue(Object object, EnergyValue energyValue, Phase phase) {
        EnergyValueRegistryProxy.init();
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod.getEnergyValueRegistry().setEnergyValue(object, energyValue, phase);
        }
    }

    private static void init() {
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod = (EquivalentExchange3)EnergyValueRegistryProxy.ee3Mod;
        }
    }

    public static enum Phase {
        PRE_ASSIGNMENT,
        PRE_CALCULATION,
        POST_ASSIGNMENT,
        POST_CALCULATION,
        RUNTIME,
        ALL;

    }

    private static class EE3Wrapper {
        private static EquivalentExchange3 ee3mod;

        private EE3Wrapper() {
        }
    }
}

