/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api.blacklist;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.exchange.WrappedStack;
import cpw.mods.fml.common.Mod;
import java.util.Set;

public class BlacklistRegistryProxy {
    @Mod.Instance(value="EE3")
    private static Object ee3Mod;

    public static Set<WrappedStack> getKnowledgeBlacklist() {
        return BlacklistRegistryProxy.getBlacklist(Blacklist.KNOWLEDGE);
    }

    public static Set<WrappedStack> getExchangeBlacklist() {
        return BlacklistRegistryProxy.getBlacklist(Blacklist.EXCHANGE);
    }

    public static Set<WrappedStack> getBlacklist(Blacklist blacklist) {
        BlacklistRegistryProxy.init();
        if (ee3Mod != null) {
            if (blacklist == Blacklist.KNOWLEDGE) {
                return EE3Wrapper.ee3mod.getBlacklistRegistry().getKnowledgeBlacklist();
            }
            if (blacklist == Blacklist.EXCHANGE) {
                return EE3Wrapper.ee3mod.getBlacklistRegistry().getExchangeBlacklist();
            }
        }
        return null;
    }

    public static boolean isLearnable(Object object) {
        BlacklistRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getBlacklistRegistry().isLearnable(object);
        }
        return false;
    }

    public static boolean isExchangeable(Object object) {
        BlacklistRegistryProxy.init();
        if (ee3Mod != null) {
            return EE3Wrapper.ee3mod.getBlacklistRegistry().isExchangeable(object);
        }
        return false;
    }

    public static void setAsLearnable(Object object) {
        BlacklistRegistryProxy.removeFromBlacklist(object, Blacklist.KNOWLEDGE);
    }

    public static void setAsNotLearnable(Object object) {
        BlacklistRegistryProxy.addToBlacklist(object, Blacklist.KNOWLEDGE);
    }

    public static void setAsExchangeable(Object object) {
        BlacklistRegistryProxy.removeFromBlacklist(object, Blacklist.EXCHANGE);
    }

    public static void setAsNotExchangeable(Object object) {
        BlacklistRegistryProxy.addToBlacklist(object, Blacklist.EXCHANGE);
    }

    public static void addToBlacklist(Object object, Blacklist blacklist) {
        BlacklistRegistryProxy.init();
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod.getBlacklistRegistry().addToBlacklist(object, blacklist);
        }
    }

    public static void removeFromBlacklist(Object object, Blacklist blacklist) {
        BlacklistRegistryProxy.init();
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod.getBlacklistRegistry().removeFromBlacklist(object, blacklist);
        }
    }

    private static void init() {
        if (ee3Mod != null) {
            EE3Wrapper.ee3mod = (EquivalentExchange3)BlacklistRegistryProxy.ee3Mod;
        }
    }

    public static enum Blacklist {
        KNOWLEDGE,
        EXCHANGE;

    }

    private static class EE3Wrapper {
        private static EquivalentExchange3 ee3mod;

        private EE3Wrapper() {
        }
    }
}

