/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3;

import com.pahimar.ee3.array.AlchemyArrayRegistry;
import com.pahimar.ee3.blacklist.BlacklistRegistry;
import com.pahimar.ee3.command.CommandEE;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.handler.ConfigurationHandler;
import com.pahimar.ee3.handler.CraftingHandler;
import com.pahimar.ee3.handler.FuelHandler;
import com.pahimar.ee3.handler.GuiHandler;
import com.pahimar.ee3.handler.WorldEventHandler;
import com.pahimar.ee3.init.Abilities;
import com.pahimar.ee3.init.AlchemyArrays;
import com.pahimar.ee3.init.EnergyValues;
import com.pahimar.ee3.init.ModBlocks;
import com.pahimar.ee3.init.ModItems;
import com.pahimar.ee3.init.Recipes;
import com.pahimar.ee3.init.TileEntities;
import com.pahimar.ee3.knowledge.PlayerKnowledgeRegistry;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.proxy.IProxy;
import com.pahimar.ee3.recipe.AludelRecipeManager;
import com.pahimar.ee3.recipe.RecipeRegistry;
import com.pahimar.ee3.reference.Files;
import com.pahimar.ee3.test.EETestSuite;
import com.pahimar.ee3.test.EnergyValueTestSuite;
import com.pahimar.ee3.test.VanillaTestSuite;
import com.pahimar.ee3.util.FluidHelper;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import com.pahimar.ee3.util.TileEntityDataHelper;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;

@Mod(modid="EE3", name="Equivalent Exchange 3", certificateFingerprint="37a1abf2e9877f91d4db47e6d1301499663575c7", version="0.3.0.547", dependencies="required-after:Forge@[10.13.3,)", guiFactory="com.pahimar.ee3.client.gui.GuiFactory")
public class EquivalentExchange3 {
    @Mod.Instance(value="EE3")
    public static EquivalentExchange3 instance;
    @SidedProxy(clientSide="com.pahimar.ee3.proxy.ClientProxy", serverSide="com.pahimar.ee3.proxy.ServerProxy")
    public static IProxy proxy;

    @Mod.EventHandler
    public void invalidFingerprint(FMLFingerprintViolationEvent event) {
        if ("37a1abf2e9877f91d4db47e6d1301499663575c7".equals("@FINGERPRINT@")) {
            LogHelper.info("The copy of Equivalent Exchange 3 that you are running is a development version of the mod, and as such may be unstable and/or incomplete.");
        } else {
            LogHelper.warn("The copy of Equivalent Exchange 3 that you are running has been modified from the original, and unpredictable things may happen. Please consider re-downloading the original version of the mod.");
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        Files.updateFileReferences();
        SerializationHelper.initModDataDirectories();
        event.registerServerCommand((ICommand)new CommandEE());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        Files.init(event);
        PacketHandler.init();
        proxy.registerKeybindings();
        ModItems.init();
        ModBlocks.init();
        FluidHelper.registerFluids();
        EnergyValues.init();
        AlchemyArrays.registerAlchemyArrays();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        BlacklistRegistry.INSTANCE.load();
        TileEntities.init();
        proxy.initRenderingAndTextures();
        proxy.registerEventHandlers();
        CraftingHandler.init();
        Recipes.init();
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.pahimar.ee3.waila.WailaDataProvider.callbackRegister");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Abilities.init();
        new VanillaTestSuite().build().save();
        new EETestSuite().build().save();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        WorldEventHandler.hasInitilialized = false;
        EnergyValueRegistry.INSTANCE.save();
        PlayerKnowledgeRegistry.INSTANCE.saveAll();
        BlacklistRegistry.INSTANCE.saveAll();
    }

    @Mod.EventHandler
    public void handleMissingMappingEvent(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.type != GameRegistry.Type.ITEM || !mapping.name.equals("EE3:alchemicalTome")) continue;
            mapping.remap((Item)ModItems.alchenomicon);
        }
    }

    public EnergyValueRegistry getEnergyValueRegistry() {
        return EnergyValueRegistry.INSTANCE;
    }

    public RecipeRegistry getRecipeRegistry() {
        return RecipeRegistry.INSTANCE;
    }

    public AludelRecipeManager getAludelRecipeManager() {
        return AludelRecipeManager.getInstance();
    }

    public BlacklistRegistry getBlacklistRegistry() {
        return BlacklistRegistry.INSTANCE;
    }

    public AlchemyArrayRegistry getAlchemyArrayRegistry() {
        return AlchemyArrayRegistry.getInstance();
    }

    public PlayerKnowledgeRegistry getPlayerKnowledgeRegistry() {
        return PlayerKnowledgeRegistry.INSTANCE;
    }

    public TileEntityDataHelper getTileEntityDataHelper() {
        return TileEntityDataHelper.getInstance();
    }

    public void runEnergyValueTestSuite(File file) {
        this.runEnergyValueTestSuite(file, false);
    }

    public void runEnergyValueTestSuite(File file, boolean strict) {
        new EnergyValueTestSuite(file).run(strict);
    }
}

